/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.PropertyDefinition;

final class PropertyEditorModification<T> {
    private PropertyDefinition<T> propertyDefinition;
    private Type type;
    private final SortedSet<T> values;
    private final SortedSet<T> originalValues;

    private PropertyEditorModification(PropertyDefinition<T> propertyDefinition, Type type, SortedSet<T> values, SortedSet<T> originalValues) {
        this.propertyDefinition = propertyDefinition;
        this.type = type;
        this.values = new TreeSet<T>(values);
        this.originalValues = new TreeSet<T>(originalValues);
    }

    static <T> PropertyEditorModification<T> createResetModification(PropertyDefinition<T> propertyDefinition, SortedSet<T> originalValues) {
        return new PropertyEditorModification<T>(propertyDefinition, Type.RESET, new TreeSet<T>(propertyDefinition), originalValues);
    }

    static <T> PropertyEditorModification<T> createAddModification(PropertyDefinition<T> propertyDefinition, SortedSet<T> addedValues, SortedSet<T> originalValues) {
        return new PropertyEditorModification<T>(propertyDefinition, Type.ADD, addedValues, originalValues);
    }

    static <T> PropertyEditorModification<T> createSetModification(PropertyDefinition<T> propertyDefinition, SortedSet<T> newValues, SortedSet<T> originalValues) {
        return new PropertyEditorModification<T>(propertyDefinition, Type.SET, newValues, originalValues);
    }

    static <T> PropertyEditorModification<T> createRemoveModification(PropertyDefinition<T> propertyDefinition, SortedSet<T> removedValues, SortedSet<T> originalValues) {
        return new PropertyEditorModification<T>(propertyDefinition, Type.REMOVE, removedValues, originalValues);
    }

    PropertyDefinition<T> getPropertyDefinition() {
        return this.propertyDefinition;
    }

    Type getType() {
        return this.type;
    }

    SortedSet<T> getModificationValues() {
        return this.values;
    }

    SortedSet<T> getOriginalValues() {
        return this.originalValues;
    }

    public String toString() {
        return "Property name: " + this.getPropertyDefinition() + "\nMod type: " + (Object)((Object)this.getType()) + "\nMod values: " + this.getModificationValues() + "\nOriginal values: " + this.getOriginalValues();
    }

    static enum Type {
        SET,
        RESET,
        ADD,
        REMOVE;

    }
}

