/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.forgerock.http.io.BranchingInputStream;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.IO;
import org.forgerock.util.Factory;

final class PipeBufferedStream {
    private final OutputStream outputStream = new PipeOutputStream();
    private final BranchingInputStream inputStream;
    private final Buffer buffer;
    private int position = 0;

    PipeBufferedStream() {
        Factory bufferFactory = IO.newTemporaryStorage();
        this.inputStream = IO.newBranchingInputStream((InputStream)new PipeInputStream(), (Factory)bufferFactory);
        this.buffer = (Buffer)bufferFactory.newInstance();
    }

    public OutputStream getIn() {
        return this.outputStream;
    }

    public BranchingInputStream getOut() {
        return this.inputStream;
    }

    private class PipeInputStream
    extends InputStream {
        private PipeInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (PipeBufferedStream.this.position >= PipeBufferedStream.this.buffer.length()) {
                return -1;
            }
            byte[] b = new byte[1];
            PipeBufferedStream.this.buffer.read(PipeBufferedStream.this.position++, b, 0, 1);
            return b[0];
        }
    }

    private class PipeOutputStream
    extends OutputStream {
        private PipeOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
            PipeBufferedStream.this.buffer.append(new byte[]{(byte)i}, 0, 1);
        }
    }
}

