/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.forgerock.http.Handler;
import org.forgerock.http.header.AcceptLanguageHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.routing.Version;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.AdviceContext;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ConflictException;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.CountPolicy;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryFilters;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestType;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourcePath;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.http.HttpContext;
import org.forgerock.json.resource.http.HttpContextFactory;
import org.forgerock.json.resource.http.HttpUtils;
import org.forgerock.json.resource.http.RequestRunner;
import org.forgerock.json.resource.http.SecurityContextFactory;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Reject;
import org.forgerock.util.i18n.PreferredLocales;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

final class HttpAdapter
implements Handler {
    private final ConnectionFactory connectionFactory;
    private final HttpContextFactory contextFactory;

    public HttpAdapter(ConnectionFactory connectionFactory) {
        this(connectionFactory, (HttpContextFactory)null);
    }

    public HttpAdapter(ConnectionFactory connectionFactory, final Context parentContext) {
        this(connectionFactory, new HttpContextFactory(){

            @Override
            public Context createContext(Context parent, org.forgerock.http.protocol.Request request) {
                return parentContext;
            }
        });
    }

    public HttpAdapter(ConnectionFactory connectionFactory, HttpContextFactory contextFactory) {
        this.contextFactory = contextFactory != null ? contextFactory : SecurityContextFactory.getHttpServletContextFactory();
        this.connectionFactory = (ConnectionFactory)Reject.checkNotNull((Object)connectionFactory);
    }

    public Promise<Response, NeverThrowsException> handle(Context context, org.forgerock.http.protocol.Request request) {
        try {
            RequestType requestType = HttpUtils.determineRequestType(request);
            switch (requestType) {
                case CREATE: {
                    return this.doCreate(context, request);
                }
                case READ: {
                    return this.doRead(context, request);
                }
                case UPDATE: {
                    return this.doUpdate(context, request);
                }
                case DELETE: {
                    return this.doDelete(context, request);
                }
                case PATCH: {
                    return this.doPatch(context, request);
                }
                case ACTION: {
                    return this.doAction(context, request);
                }
                case QUERY: {
                    return this.doQuery(context, request);
                }
            }
            throw new NotSupportedException("Operation " + requestType + " not supported");
        }
        catch (ResourceException e) {
            return HttpUtils.fail(request, e);
        }
    }

    Promise<Response, NeverThrowsException> doDelete(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            HttpUtils.rejectIfNoneMatch(req);
            String ifMatchRevision = HttpUtils.getIfMatch(req, HttpUtils.PROTOCOL_VERSION_1);
            Form parameters = req.getForm();
            DeleteRequest request = Requests.newDeleteRequest((ResourcePath)this.getResourcePath(context, req)).setRevision(ifMatchRevision).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doRead(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            HttpUtils.rejectIfMatch(req);
            Form parameters = req.getForm();
            String rev = HttpUtils.getIfNoneMatch(req);
            if ("*".equals(rev)) {
                throw new PreconditionFailedException("If-None-Match * not appropriate for " + HttpUtils.getMethod(req) + " requests");
            }
            ReadRequest request = Requests.newReadRequest((ResourcePath)this.getResourcePath(context, req)).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                if (HttpUtils.PARAM_MIME_TYPE.equalsIgnoreCase(name)) {
                    if (values.size() != 1 || ((String)values.get(0)).split(",").length > 1) {
                        throw new BadRequestException("Only one mime type value allowed");
                    }
                    if (((List)parameters.get((Object)HttpUtils.PARAM_FIELDS)).size() == 1) continue;
                    throw new BadRequestException("The mime type parameter requires only 1 field to be specified");
                }
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doQuery(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            HttpUtils.rejectIfMatch(req);
            Form parameters = req.getForm();
            HttpUtils.rejectIfNoneMatch(req);
            QueryRequest request = Requests.newQueryRequest((ResourcePath)this.getResourcePath(context, req)).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                if (name.equalsIgnoreCase(HttpUtils.PARAM_SORT_KEYS)) {
                    for (String s : values) {
                        try {
                            request.addSortKey(s.split(","));
                        }
                        catch (IllegalArgumentException e) {
                            throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a comma " + "separated list of sort keys");
                        }
                    }
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_ID)) {
                    request.setQueryId(HttpUtils.asSingleValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_EXPRESSION)) {
                    request.setQueryExpression(HttpUtils.asSingleValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGED_RESULTS_COOKIE)) {
                    request.setPagedResultsCookie(HttpUtils.asSingleValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGED_RESULTS_OFFSET)) {
                    request.setPagedResultsOffset(HttpUtils.asIntValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_PAGE_SIZE)) {
                    request.setPageSize(HttpUtils.asIntValue(name, values));
                    continue;
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_QUERY_FILTER)) {
                    String s = HttpUtils.asSingleValue(name, values);
                    try {
                        request.setQueryFilter(QueryFilters.parse((String)s));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a valid query filter");
                    }
                }
                if (name.equalsIgnoreCase(HttpUtils.PARAM_TOTAL_PAGED_RESULTS_POLICY)) {
                    String policy = HttpUtils.asSingleValue(name, values);
                    try {
                        request.setTotalPagedResultsPolicy(CountPolicy.valueOf((String)policy.toUpperCase()));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new BadRequestException("The value '" + policy + "' for parameter '" + name + "' could not be parsed as a valid count policy");
                    }
                }
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            if (request.getQueryId() != null && request.getQueryFilter() != null) {
                throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_ID + " and " + HttpUtils.PARAM_QUERY_FILTER + " are mutually exclusive");
            }
            if (request.getQueryId() != null && request.getQueryExpression() != null) {
                throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_ID + " and " + HttpUtils.PARAM_QUERY_EXPRESSION + " are mutually exclusive");
            }
            if (request.getQueryFilter() != null && request.getQueryExpression() != null) {
                throw new BadRequestException("The parameters " + HttpUtils.PARAM_QUERY_FILTER + " and " + HttpUtils.PARAM_QUERY_EXPRESSION + " are mutually exclusive");
            }
            if (request.getPagedResultsOffset() > 0 && request.getPagedResultsCookie() != null) {
                throw new BadRequestException("The parameters " + HttpUtils.PARAM_PAGED_RESULTS_OFFSET + " and " + HttpUtils.PARAM_PAGED_RESULTS_COOKIE + " are mutually exclusive");
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doPatch(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            if (req.getHeaders().getFirst("If-None-Match") != null) {
                throw new PreconditionFailedException("Use of If-None-Match not supported for PATCH requests");
            }
            String ifMatchRevision = HttpUtils.getIfMatch(req, HttpUtils.PROTOCOL_VERSION_1);
            Form parameters = req.getForm();
            PatchRequest request = Requests.newPatchRequest((ResourcePath)this.getResourcePath(context, req), (PatchOperation[])new PatchOperation[0]).setRevision(ifMatchRevision).setResourceVersion(requestedResourceVersion);
            request.getPatchOperations().addAll(HttpUtils.getJsonPatchContent(req));
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doCreate(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            if ("POST".equals(HttpUtils.getMethod(req))) {
                HttpUtils.rejectIfNoneMatch(req);
                HttpUtils.rejectIfMatch(req);
                Form parameters = req.getForm();
                JsonValue content = HttpUtils.getJsonContent(req);
                CreateRequest request = Requests.newCreateRequest((ResourcePath)this.getResourcePath(context, req), (JsonValue)content).setResourceVersion(requestedResourceVersion);
                for (Map.Entry p : parameters.entrySet()) {
                    List values;
                    String name = (String)p.getKey();
                    if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request) || name.equalsIgnoreCase(HttpUtils.PARAM_ACTION)) continue;
                    request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
                }
                return this.doRequest(context, req, resp, (Request)request);
            }
            if (req.getHeaders().getFirst("If-Match") != null && req.getHeaders().getFirst("If-None-Match") != null) {
                throw new PreconditionFailedException("Simultaneous use of If-Match and If-None-Match not supported for PUT requests");
            }
            Form parameters = req.getForm();
            JsonValue content = HttpUtils.getJsonContent(req);
            ResourcePath resourcePath = this.getResourcePath(context, req);
            if (resourcePath.isEmpty()) {
                throw new BadRequestException("No new resource ID in HTTP PUT request");
            }
            CreateRequest request = Requests.newCreateRequest((ResourcePath)resourcePath.parent(), (JsonValue)content).setNewResourceId(resourcePath.leaf()).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doAction(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            HttpUtils.rejectIfNoneMatch(req);
            HttpUtils.rejectIfMatch(req);
            Form parameters = req.getForm();
            String action = HttpUtils.asSingleValue(HttpUtils.PARAM_ACTION, HttpUtils.getParameter(req, HttpUtils.PARAM_ACTION));
            JsonValue content = HttpUtils.getJsonActionContent(req);
            ActionRequest request = Requests.newActionRequest((ResourcePath)this.getResourcePath(context, req), (String)action).setContent(content).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request) || name.equalsIgnoreCase(HttpUtils.PARAM_ACTION)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    Promise<Response, NeverThrowsException> doUpdate(Context context, org.forgerock.http.protocol.Request req) {
        try {
            Version requestedResourceVersion = HttpUtils.getRequestedResourceVersion(req);
            Response resp = HttpUtils.prepareResponse(req);
            this.preprocessRequest(req);
            if (req.getHeaders().getFirst("If-Match") != null && req.getHeaders().getFirst("If-None-Match") != null) {
                throw new PreconditionFailedException("Simultaneous use of If-Match and If-None-Match not supported for PUT requests");
            }
            String ifMatchRevision = HttpUtils.getIfMatch(req, HttpUtils.PROTOCOL_VERSION_1);
            Form parameters = req.getForm();
            JsonValue content = HttpUtils.getJsonContent(req);
            UpdateRequest request = Requests.newUpdateRequest((ResourcePath)this.getResourcePath(context, req), (JsonValue)content).setRevision(ifMatchRevision).setResourceVersion(requestedResourceVersion);
            for (Map.Entry p : parameters.entrySet()) {
                List values;
                String name = (String)p.getKey();
                if (this.parseCommonParameter(name, values = (List)p.getValue(), (Request)request)) continue;
                request.setAdditionalParameter(name, HttpUtils.asSingleValue(name, values));
            }
            return this.doRequest(context, req, resp, (Request)request);
        }
        catch (Exception e) {
            return HttpUtils.fail(req, e);
        }
    }

    private Promise<Response, NeverThrowsException> doRequest(Context context, org.forgerock.http.protocol.Request req, Response resp, Request request) throws Exception {
        Context ctx = this.newRequestContext(context, req);
        AcceptLanguageHeader acceptLanguageHeader = (AcceptLanguageHeader)req.getHeaders().get(AcceptLanguageHeader.class);
        if (acceptLanguageHeader != null) {
            request.setPreferredLocales(acceptLanguageHeader.getLocales());
        } else {
            request.setPreferredLocales(new PreferredLocales(null));
        }
        final RequestRunner runner = new RequestRunner(ctx, request, req, resp);
        return this.connectionFactory.getConnectionAsync().thenAsync((AsyncFunction)new AsyncFunction<Connection, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(Connection connection) {
                return runner.handleResult(connection);
            }
        }, (AsyncFunction)new AsyncFunction<ResourceException, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(ResourceException error) {
                return runner.handleError(error);
            }
        });
    }

    private ResourcePath getResourcePath(Context context, org.forgerock.http.protocol.Request req) throws ResourceException {
        try {
            if (context.containsContext(UriRouterContext.class)) {
                ResourcePath reqPath = ResourcePath.valueOf((String)req.getUri().getRawPath());
                return reqPath.subSequence(this.getMatchedUri(context).size(), reqPath.size());
            }
            return ResourcePath.valueOf((String)req.getUri().getRawPath());
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private ResourcePath getMatchedUri(Context context) {
        ArrayList<ResourcePath> matched = new ArrayList<ResourcePath>();
        Context ctx = context;
        while (ctx.containsContext(UriRouterContext.class)) {
            UriRouterContext uriRouterContext = (UriRouterContext)ctx.asContext(UriRouterContext.class);
            matched.add(ResourcePath.valueOf((String)uriRouterContext.getMatchedUri()));
            ctx = uriRouterContext.getParent();
        }
        Collections.reverse(matched);
        ResourcePath matchedUri = new ResourcePath();
        for (ResourcePath resourcePath : matched) {
            matchedUri = matchedUri.concat(resourcePath);
        }
        return matchedUri;
    }

    private Context newRequestContext(Context context, org.forgerock.http.protocol.Request req) throws ResourceException {
        Context parent = this.contextFactory.createContext(context, req);
        return new AdviceContext((Context)new HttpContext(parent, req), HttpUtils.RESTRICTED_HEADER_NAMES);
    }

    private boolean parseCommonParameter(String name, List<String> values, Request request) throws ResourceException {
        if (name.equalsIgnoreCase(HttpUtils.PARAM_FIELDS)) {
            for (String s : values) {
                try {
                    request.addField(s.split(","));
                }
                catch (IllegalArgumentException e) {
                    throw new BadRequestException("The value '" + s + "' for parameter '" + name + "' could not be parsed as a comma separated list of JSON pointers");
                }
            }
            return true;
        }
        if (name.equalsIgnoreCase("_prettyPrint")) {
            HttpUtils.asBooleanValue(name, values);
            return true;
        }
        return false;
    }

    private void preprocessRequest(org.forgerock.http.protocol.Request req) throws ResourceException {
        String contentType = ContentTypeHeader.valueOf((Message)req).getType();
        if (!(req.getMethod().equalsIgnoreCase("GET") || contentType == null || HttpUtils.CONTENT_TYPE_REGEX.matcher(contentType).matches() || HttpUtils.isMultiPartRequest(contentType))) {
            throw new BadRequestException("The request could not be processed because it specified the content-type '" + contentType + "' when only the content-type '" + "application/json" + "' and '" + "multipart/form-data" + "' are supported");
        }
        if (req.getHeaders().getFirst("If-Modified-Since") != null) {
            throw new ConflictException("Header If-Modified-Since not supported");
        }
        if (req.getHeaders().getFirst("If-Unmodified-Since") != null) {
            throw new ConflictException("Header If-Unmodified-Since not supported");
        }
    }
}

