/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.PackedLong;
import java.io.IOException;
import java.io.InputStream;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;

public final class ByteSequenceReader {
    private int pos;
    private final ByteSequence sequence;
    private InputStream inputStream;

    ByteSequenceReader(ByteSequence sequence) {
        this.sequence = sequence;
    }

    public byte readByte() {
        byte b = this.sequence.byteAt(this.pos);
        ++this.pos;
        return b;
    }

    public void readBytes(byte[] b) {
        this.readBytes(b, 0, b.length);
    }

    public void readBytes(byte[] b, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > b.length || length > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        this.sequence.subSequence(this.pos, this.pos + length).copyTo(b, offset);
        this.pos += length;
    }

    public int readBERLength() {
        int newPos = this.pos + 1;
        if (newPos > this.sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int length = this.sequence.byteAt(this.pos) & 0x7F;
        if (length != this.sequence.byteAt(this.pos)) {
            int numLengthBytes = length;
            newPos = this.pos + 1 + numLengthBytes;
            if (numLengthBytes > 4 || newPos > this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            length = 0;
            for (int i = this.pos + 1; i < newPos; ++i) {
                length = length << 8 | this.sequence.byteAt(i) & 0xFF;
            }
        }
        this.pos = newPos;
        return length;
    }

    public ByteSequence readByteSequence(int length) {
        int newPos = this.pos + length;
        ByteSequence subSequence = this.sequence.subSequence(this.pos, newPos);
        this.pos = newPos;
        return subSequence;
    }

    public ByteString readByteString(int length) {
        return this.readByteSequence(length).toByteString();
    }

    public int readInt() {
        if (this.remaining() < 4) {
            throw new IndexOutOfBoundsException();
        }
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v <<= 8;
            v |= this.sequence.byteAt(this.pos++) & 0xFF;
        }
        return v;
    }

    public long readLong() {
        if (this.remaining() < 8) {
            throw new IndexOutOfBoundsException();
        }
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(this.sequence.byteAt(this.pos++) & 0xFF);
        }
        return v;
    }

    public long readCompactUnsignedLong() {
        try {
            return PackedLong.readCompactUnsignedLong(this.asInputStream());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public int readCompactUnsignedInt() {
        long l = this.readCompactUnsignedLong();
        if (l > Integer.MAX_VALUE) {
            throw new IllegalStateException(CoreMessages.ERR_INVALID_COMPACTED_UNSIGNED_INT.get((Object)Integer.MAX_VALUE, (Object)l).toString());
        }
        return (int)l;
    }

    public short readShort() {
        if (this.remaining() < 2) {
            throw new IndexOutOfBoundsException();
        }
        short v = 0;
        for (int i = 0; i < 2; ++i) {
            v = (short)(v << 8);
            v = (short)(v | this.sequence.byteAt(this.pos++) & 0xFF);
        }
        return v;
    }

    public String readStringUtf8(int length) {
        if (this.remaining() < length) {
            throw new IndexOutOfBoundsException();
        }
        int newPos = this.pos + length;
        String str = this.sequence.subSequence(this.pos, this.pos + length).toString();
        this.pos = newPos;
        return str;
    }

    public int position() {
        return this.pos;
    }

    public void position(int pos) {
        if (pos > this.sequence.length() || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.pos = pos;
    }

    public int remaining() {
        return this.sequence.length() - this.pos;
    }

    public void rewind() {
        this.position(0);
    }

    public byte peek() {
        return this.sequence.byteAt(this.pos);
    }

    public byte peek(int offset) {
        return this.sequence.byteAt(this.pos + offset);
    }

    public void skip(int length) {
        this.position(this.pos + length);
    }

    public String toString() {
        return this.sequence.toString();
    }

    private InputStream asInputStream() {
        if (this.inputStream == null) {
            this.inputStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    if (ByteSequenceReader.this.pos >= ByteSequenceReader.this.sequence.length()) {
                        return -1;
                    }
                    return ByteSequenceReader.this.sequence.byteAt(ByteSequenceReader.this.pos++) & 0xFF;
                }
            };
        }
        return this.inputStream;
    }
}

