/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.Collection;
import org.forgerock.i18n.LocalizedIllegalArgumentException;

public final class AddressMask {
    private static final int IN4ADDRSZ = 4;
    private static final int IPV4MAXPREFIX = 32;
    private static final int IN6ADDRSZ = 16;
    private static final int IPV6MAXPREFIX = 128;
    private String[] hostName;
    private String hostPattern;
    private byte[] ruleMask;
    private byte[] prefixMask;
    private final String ruleString;
    private RuleType ruleType;
    private final BitSet wildCard = new BitSet();

    public static boolean matchesAny(Collection<AddressMask> masks, InetAddress address) {
        if (address != null) {
            for (AddressMask mask : masks) {
                if (!mask.matches(address)) continue;
                return true;
            }
        }
        return false;
    }

    public static AddressMask valueOf(String mask) {
        return new AddressMask(mask);
    }

    private AddressMask(String rule) {
        this.determineRuleType(rule);
        switch (this.ruleType) {
            case IPv6: {
                this.processIPv6(rule);
                break;
            }
            case IPv4: {
                this.processIpv4(rule);
                break;
            }
            case HOST: {
                this.processHost(rule);
                break;
            }
            case HOSTPATTERN: {
                this.processHostPattern(rule);
                break;
            }
            case ALLWILDCARD: {
                this.processAllWilds(rule);
            }
        }
        this.ruleString = rule;
    }

    public boolean matches(InetAddress address) {
        boolean ret = false;
        switch (this.ruleType) {
            case IPv6: 
            case IPv4: {
                ret = this.matchAddress(address.getAddress());
                break;
            }
            case HOST: {
                ret = this.matchHostName(address.getHostName());
                break;
            }
            case HOSTPATTERN: {
                ret = this.matchPattern(address.getHostName());
                break;
            }
            case ALLWILDCARD: {
                ret = this.matchAddress(address.getAddress());
                if (ret) break;
                ret = this.matchHostName(address.getHostName());
            }
        }
        return ret;
    }

    public String toString() {
        return this.ruleString;
    }

    private void determineRuleType(String ruleString) {
        if (ruleString.endsWith(".")) {
            throw this.genericDecodeError();
        }
        if (ruleString.startsWith(".")) {
            this.ruleType = RuleType.HOSTPATTERN;
        } else if (ruleString.startsWith("[") || ruleString.indexOf(58) != -1) {
            this.ruleType = RuleType.IPv6;
        } else {
            int wildcardsCount = 0;
            String[] s = ruleString.split("\\.", -1);
            this.ruleType = RuleType.HOST;
            for (String value : s) {
                if ("*".equals(value)) {
                    ++wildcardsCount;
                    continue;
                }
                if (!Character.isDigit(value.charAt(0))) continue;
                this.ruleType = RuleType.IPv4;
                break;
            }
            if (wildcardsCount == s.length) {
                this.ruleType = RuleType.ALLWILDCARD;
            }
        }
    }

    private boolean matchAddress(byte[] remoteMask) {
        if (this.ruleType == RuleType.ALLWILDCARD) {
            return true;
        }
        if (this.prefixMask == null) {
            return false;
        }
        if (remoteMask.length != this.prefixMask.length) {
            return false;
        }
        for (int i = 0; i < this.prefixMask.length; ++i) {
            if (this.wildCard.get(i) || (this.ruleMask[i] & this.prefixMask[i]) == (remoteMask[i] & this.prefixMask[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchHostName(String remoteHostName) {
        String[] s = remoteHostName.split("\\.", -1);
        if (s.length != this.hostName.length) {
            return false;
        }
        if (this.ruleType == RuleType.ALLWILDCARD) {
            return true;
        }
        for (int i = 0; i < s.length; ++i) {
            if ("*".equals(this.hostName[i]) || s[i].equalsIgnoreCase(this.hostName[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchPattern(String remoteHostName) {
        int len = remoteHostName.length() - this.hostPattern.length();
        return len > 0 && remoteHostName.regionMatches(true, len, this.hostPattern, 0, this.hostPattern.length());
    }

    private void prefixMask(int prefix) {
        int i = 0;
        while (prefix > 8) {
            this.prefixMask[i] = -1;
            prefix -= 8;
            ++i;
        }
        this.prefixMask[i] = (byte)(255 << 8 - prefix);
    }

    private void processAllWilds(String rule) {
        String[] s = rule.split("\\.", -1);
        if (s.length == 4) {
            for (int i = 0; i < 4; ++i) {
                this.wildCard.set(i);
            }
        }
        this.hostName = rule.split("\\.", -1);
    }

    private void processHost(String rule) {
        String[] s = rule.split("^[0-9a-zA-z-.*]+");
        if (s.length > 0) {
            throw this.genericDecodeError();
        }
        this.hostName = rule.split("\\.", -1);
    }

    private void processHostPattern(String rule) {
        String[] s = rule.split("^[0-9a-zA-z-.]+");
        if (s.length > 0) {
            throw this.genericDecodeError();
        }
        this.hostPattern = rule;
    }

    private void processIpv4(String rule) {
        String[] s = rule.split("/", -1);
        this.ruleMask = new byte[4];
        this.prefixMask = new byte[4];
        this.prefixMask(this.processPrefix(s, 32));
        this.processIPv4Subnet(s.length == 0 ? rule : s[0]);
    }

    private void processIPv4Subnet(String subnet) {
        String[] s = subnet.split("\\.", -1);
        try {
            if (s.length != 4) {
                throw this.genericDecodeError();
            }
            for (int i = 0; i < 4; ++i) {
                String quad = s[i].trim();
                if ("*".equals(quad)) {
                    this.wildCard.set(i);
                    continue;
                }
                long val = Integer.parseInt(quad);
                if (val < 0L || val > 255L) {
                    throw this.genericDecodeError();
                }
                this.ruleMask[i] = (byte)(val & 0xFFL);
            }
        }
        catch (NumberFormatException nfex) {
            throw this.genericDecodeError();
        }
    }

    private void processIPv6(String rule) {
        InetAddress addr;
        boolean isValid;
        String[] s = rule.split("/", -1);
        String address = s[0];
        String ipv6Literal = address.charAt(0) == '[' && address.charAt(address.length() - 1) == ']' ? address.substring(1, address.length() - 1) : address;
        try {
            Class<?> ipUtils = Class.forName("sun.net.util.IPAddressUtil");
            Method method = ipUtils.getMethod("isIPv6LiteralAddress", String.class);
            isValid = (Boolean)method.invoke(null, ipv6Literal);
        }
        catch (Exception e) {
            isValid = true;
        }
        if (!isValid) {
            throw this.genericDecodeError();
        }
        try {
            addr = InetAddress.getByName(address);
        }
        catch (UnknownHostException ex) {
            throw this.genericDecodeError();
        }
        if (addr instanceof Inet6Address) {
            this.ruleType = RuleType.IPv6;
            Inet6Address addr6 = (Inet6Address)addr;
            this.ruleMask = addr6.getAddress();
            this.prefixMask = new byte[16];
            this.prefixMask(this.processPrefix(s, 128));
        } else {
            if (s.length == 2) {
                throw this.genericDecodeError();
            }
            this.ruleMask = addr.getAddress();
            this.ruleType = RuleType.IPv4;
            this.prefixMask = new byte[4];
            this.prefixMask(this.processPrefix(s, 32));
        }
    }

    private int processPrefix(String[] s, int maxPrefix) {
        int prefix = maxPrefix;
        try {
            if (s.length < 1 || s.length > 2) {
                throw this.genericDecodeError();
            }
            if (s.length == 2) {
                if (s[0].indexOf(42) > -1) {
                    throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ADDRESSMASK_WILDCARD_DECODE_ERROR.get());
                }
                prefix = Integer.parseInt(s[1]);
            }
            if (prefix < 0 || prefix > maxPrefix) {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_ADDRESSMASK_PREFIX_DECODE_ERROR.get());
            }
        }
        catch (NumberFormatException nfex) {
            throw this.genericDecodeError();
        }
        return prefix;
    }

    private LocalizedIllegalArgumentException genericDecodeError() {
        return new LocalizedIllegalArgumentException(CoreMessages.ERR_ADDRESSMASK_FORMAT_DECODE_ERROR.get());
    }

    static enum RuleType {
        ALLWILDCARD,
        HOST,
        HOSTPATTERN,
        IPv4,
        IPv6;

    }
}

