/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class SessionId {
    private static final AtomicInteger counter = new AtomicInteger(1);
    private final int _id = counter.getAndIncrement();
    private final AtomicReference<Thread> _owner = new AtomicReference();

    public SessionId() {
        this.assign();
    }

    public boolean equals(Object id) {
        if (id == null || !(id instanceof SessionId)) {
            return false;
        }
        return this._id == ((SessionId)id)._id;
    }

    public int hashCode() {
        return this._id;
    }

    public boolean isAlive() {
        return this._owner.get().isAlive();
    }

    public String toString() {
        return "[" + this._id + (!this.isAlive() ? "*]" : "]");
    }

    void assign() {
        this._owner.set(Thread.currentThread());
    }

    boolean interrupt() {
        Thread t = this._owner.get();
        if (t != null && t != Thread.currentThread()) {
            t.interrupt();
            return true;
        }
        return false;
    }

    public String ownerName() {
        Thread t = this._owner.get();
        if (t == null) {
            return "null";
        }
        return t.getName();
    }
}

