/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import java.util.ArrayList;
import java.util.List;

public class Splitter {
    private static final char QUOTECHAR = '\"';
    private static final char ESCAPECHAR = '\\';
    private final char delimiter;
    private final List<String> tokens = new ArrayList<String>();
    private StateType prevState;
    private StateType state;
    private int startIndex;
    private int curIndex;
    private String row;

    public Splitter(char delimiter) {
        this.delimiter = delimiter;
    }

    public String[] tokenize(String inrow) {
        this.row = inrow;
        this.state = StateType.COLLECT;
        this.tokens.clear();
        this.startIndex = 0;
        this.curIndex = 0;
        block5: for (int cur = 0; cur < this.row.length(); ++cur) {
            char c = this.row.charAt(cur);
            switch (this.state) {
                case COLLECT: {
                    if (this.isDelimiter(c)) {
                        this.outputToken();
                        this.curIndex = this.startIndex = cur + 1;
                        continue block5;
                    }
                    if (this.isQuote(c) && this.isQuoteState()) {
                        this.state = StateType.QUOTE;
                    } else if (this.isEscape(c)) {
                        this.prevState = this.state;
                        this.state = StateType.COLLECTANY;
                    }
                    ++this.curIndex;
                    continue block5;
                }
                case COLLECTANY: {
                    ++this.curIndex;
                    this.state = this.prevState;
                    continue block5;
                }
                case QUOTE: {
                    if (this.isEscape(c)) {
                        this.prevState = this.state;
                        this.state = StateType.COLLECTANY;
                    } else if (this.isQuote(c)) {
                        this.state = StateType.COLLECT;
                    }
                    ++this.curIndex;
                }
            }
        }
        this.outputToken();
        String[] retvals = new String[this.tokens.size()];
        this.tokens.toArray(retvals);
        return retvals;
    }

    private boolean isQuote(char c) {
        return c == '\"';
    }

    private boolean isEscape(char c) {
        return c == '\\';
    }

    private boolean isDelimiter(char c) {
        return c == this.delimiter;
    }

    private void outputToken() {
        if (this.startIndex < this.curIndex) {
            this.tokens.add(this.row.substring(this.startIndex, this.curIndex));
        } else {
            this.tokens.add("");
        }
    }

    private boolean isQuoteState() {
        for (int i = this.startIndex; i < this.curIndex; ++i) {
            if (Character.isWhitespace(this.row.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StateType {
        COLLECT,
        COLLECTANY,
        QUOTE;

    }
}

