/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbitration;

import com.sleepycat.je.Durability;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.ReplicationMutableConfig;
import com.sleepycat.je.rep.arbitration.ArbiterProvider;
import com.sleepycat.je.rep.arbitration.DesignatedPrimaryProvider;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Logger;

public class Arbiter {
    private volatile boolean active;
    private final ArbiterProvider provider;
    private final RepImpl repImpl;
    private final Logger logger;

    public Arbiter(RepImpl repImpl) {
        this.repImpl = repImpl;
        this.provider = new DesignatedPrimaryProvider(repImpl);
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public synchronized boolean activateArbitration() {
        this.active = this.provider.attemptActivation();
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endArbitration() {
        Arbiter arbiter = this;
        synchronized (arbiter) {
            if (!this.active) {
                return;
            }
            this.provider.endArbitration();
            this.active = false;
        }
        LoggerUtils.info(this.logger, this.repImpl, "Arbitration is inactivated");
    }

    public boolean activationPossible() {
        return this.provider.activationPossible();
    }

    public boolean isApplicable(QuorumPolicy quorumPolicy) {
        return this.active && quorumPolicy.equals((Object)QuorumPolicy.SIMPLE_MAJORITY);
    }

    public boolean isApplicable(Durability.ReplicaAckPolicy ackPolicy) {
        return this.active && ackPolicy.equals((Object)Durability.ReplicaAckPolicy.SIMPLE_MAJORITY);
    }

    public int getElectionQuorumSize(QuorumPolicy quorumPolicy) {
        return this.provider.getElectionQuorumSize(quorumPolicy);
    }

    public int getAckCount(Durability.ReplicaAckPolicy ackPolicy) {
        return this.provider.getAckCount(ackPolicy);
    }

    public synchronized void processConfigChange(ReplicationMutableConfig newConfig) {
        if (!this.active) {
            return;
        }
        if (this.provider.shouldEndArbitration(newConfig)) {
            this.endArbitration();
        }
    }

    public synchronized boolean isActive() {
        return this.active;
    }
}

