/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.ReplicatedDatabaseConfig;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.Txn;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameLNLogEntry
extends LNLogEntry<NameLN> {
    public static final int LAST_FORMAT_CHANGE = 8;
    private DbOperationType operationType;
    private DatabaseId truncateOldDbId;
    private ReplicatedDatabaseConfig replicatedCreateConfig;

    public NameLNLogEntry() {
        super(NameLN.class);
    }

    public NameLNLogEntry(LogEntryType entryType, NameLN nameLN, DatabaseId dbId, byte[] key, long abortLsn, boolean abortKnownDeleted, Txn txn, ReplicationContext repContext) {
        super(entryType, nameLN, dbId, key, abortLsn, abortKnownDeleted, txn);
        ReplicationContext operationContext = repContext;
        this.operationType = repContext.getDbOperationType();
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            this.replicatedCreateConfig = ((DbOpReplicationContext)operationContext).getCreateConfig();
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            this.truncateOldDbId = ((DbOpReplicationContext)operationContext).getTruncateOldDbId();
        }
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        this.readBaseLNEntry(envImpl, header, entryBuffer, false);
        int version = header.getVersion();
        if (version >= 6) {
            this.operationType = DbOperationType.readTypeFromLog(entryBuffer, version);
            if (DbOperationType.isWriteConfigType(this.operationType)) {
                this.replicatedCreateConfig = new ReplicatedDatabaseConfig();
                this.replicatedCreateConfig.readFromLog(entryBuffer, version);
            }
            if (this.operationType == DbOperationType.TRUNCATE) {
                this.truncateOldDbId = new DatabaseId();
                this.truncateOldDbId.readFromLog(entryBuffer, version);
            }
        } else {
            this.operationType = DbOperationType.NONE;
        }
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        super.dumpEntry(sb, verbose);
        this.operationType.dumpLog(sb, verbose);
        if (this.replicatedCreateConfig != null) {
            this.replicatedCreateConfig.dumpLog(sb, verbose);
        }
        if (this.truncateOldDbId != null) {
            this.truncateOldDbId.dumpLog(sb, verbose);
        }
        return sb;
    }

    @Override
    public int getSize() {
        int size = this.getBaseLNEntrySize(false) + this.operationType.getLogSize();
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            size += this.replicatedCreateConfig.getLogSize();
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            size += this.truncateOldDbId.getLogSize();
        }
        return size;
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer) {
        this.writeEntry(destBuffer, 8);
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer, int logVersion) {
        this.writeBaseLNEntry(destBuffer, false, logVersion);
        assert (this.operationType.getLastFormatChange() <= 8) : "Format of loggable newer than format of entry";
        this.operationType.writeToLog(destBuffer, logVersion);
        if (DbOperationType.isWriteConfigType(this.operationType)) {
            assert (this.replicatedCreateConfig.getLastFormatChange() <= 8) : "Format of loggable newer than format of entry";
            this.replicatedCreateConfig.writeToLog(destBuffer, logVersion);
        }
        if (this.operationType == DbOperationType.TRUNCATE) {
            assert (this.truncateOldDbId.getLastFormatChange() <= 8) : "Format of loggable newer than format of entry";
            this.truncateOldDbId.writeToLog(destBuffer, logVersion);
        }
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        if (!super.logicalEquals(other)) {
            return false;
        }
        NameLNLogEntry otherEntry = (NameLNLogEntry)other;
        if (!this.operationType.logicalEquals(otherEntry.operationType)) {
            return false;
        }
        if (this.truncateOldDbId != null && !this.truncateOldDbId.logicalEquals(otherEntry.truncateOldDbId)) {
            return false;
        }
        return this.replicatedCreateConfig == null || this.replicatedCreateConfig.logicalEquals(otherEntry.replicatedCreateConfig);
    }

    public DbOperationType getOperationType() {
        return this.operationType;
    }

    public ReplicatedDatabaseConfig getReplicatedCreateConfig() {
        return this.replicatedCreateConfig;
    }

    public DatabaseId getTruncateOldDbId() {
        return this.truncateOldDbId;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
        super.dumpRep(sb);
        sb.append(" dbop=").append(this.operationType);
    }
}

