/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INContainingEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.IN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BINDeltaLogEntry
extends SingleItemEntry<BINDelta>
implements INContainingEntry {
    public BINDeltaLogEntry(Class<BINDelta> logClass) {
        super(logClass);
    }

    public BINDeltaLogEntry(BINDelta delta) {
        super(LogEntryType.LOG_BIN_DELTA, delta);
    }

    @Override
    public Object getResolvedItem(DatabaseImpl dbImpl) {
        return this.getIN(dbImpl);
    }

    @Override
    public IN getIN(DatabaseImpl dbImpl) throws DatabaseException {
        BINDelta delta = (BINDelta)this.getMainItem();
        return delta.reconstituteBIN(dbImpl);
    }

    @Override
    public DatabaseId getDbId() {
        BINDelta delta = (BINDelta)this.getMainItem();
        return delta.getDbId();
    }

    @Override
    public long getPrevFullLsn() {
        return -1L;
    }

    @Override
    public long getPrevDeltaLsn() {
        BINDelta delta = (BINDelta)this.getMainItem();
        return delta.getPrevDeltaLsn();
    }
}

