/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CompressedOopsDetector;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class MemoryBudget
implements EnvConfigObserver {
    public static boolean CLEANUP_DONE = false;
    public static boolean DEBUG_ADMIN = Boolean.getBoolean("memAdmin");
    public static boolean DEBUG_LOCK = Boolean.getBoolean("memLock");
    public static boolean DEBUG_TXN = Boolean.getBoolean("memTxn");
    public static boolean DEBUG_TREEADMIN = Boolean.getBoolean("memTreeAdmin");
    public static boolean DEBUG_TREE = Boolean.getBoolean("memTree");
    private static final int LONG_OVERHEAD_32 = 16;
    private static final int LONG_OVERHEAD_64 = 24;
    private static final int LONG_OVERHEAD_OOPS = 24;
    private static final int LONG_OVERHEAD_DALVIK = 24;
    private static final int ARRAY_OVERHEAD_32 = 16;
    private static final int ARRAY_OVERHEAD_64 = 24;
    private static final int ARRAY_OVERHEAD_OOPS = 16;
    private static final int ARRAY_OVERHEAD_DALVIK = 24;
    private static final int ARRAY_SIZE_INCLUDED_32 = 4;
    private static final int ARRAY_SIZE_INCLUDED_64 = 0;
    private static final int ARRAY_SIZE_INCLUDED_OOPS = 0;
    private static final int ARRAY_SIZE_INCLUDED_DALVIK = 4;
    private static final int OBJECT_OVERHEAD_32 = 8;
    private static final int OBJECT_OVERHEAD_64 = 16;
    private static final int OBJECT_OVERHEAD_OOPS = 16;
    private static final int OBJECT_OVERHEAD_DALVIK = 16;
    private static final int OBJECT_ARRAY_ITEM_OVERHEAD_32 = 4;
    private static final int OBJECT_ARRAY_ITEM_OVERHEAD_64 = 8;
    private static final int OBJECT_ARRAY_ITEM_OVERHEAD_OOPS = 4;
    private static final int OBJECT_ARRAY_ITEM_OVERHEAD_DALVIK = 4;
    private static final int HASHMAP_OVERHEAD_32 = 120;
    private static final int HASHMAP_OVERHEAD_64 = 219;
    private static final int HASHMAP_OVERHEAD_OOPS = 128;
    private static final int HASHMAP_OVERHEAD_DALVIK = 56;
    private static final int HASHMAP_ENTRY_OVERHEAD_32 = 24;
    private static final int HASHMAP_ENTRY_OVERHEAD_64 = 52;
    private static final int HASHMAP_ENTRY_OVERHEAD_OOPS = 32;
    private static final int HASHMAP_ENTRY_OVERHEAD_DALVIK = 72;
    private static final int HASHSET_OVERHEAD_32 = 136;
    private static final int HASHSET_OVERHEAD_64 = 240;
    private static final int HASHSET_OVERHEAD_OOPS = 144;
    private static final int HASHSET_OVERHEAD_DALVIK = 72;
    private static final int HASHSET_ENTRY_OVERHEAD_32 = 24;
    private static final int HASHSET_ENTRY_OVERHEAD_64 = 55;
    private static final int HASHSET_ENTRY_OVERHEAD_OOPS = 32;
    private static final int HASHSET_ENTRY_OVERHEAD_DALVIK = 72;
    private static final int TWOHASHMAPS_OVERHEAD_32 = 240;
    private static final int TWOHASHMAPS_OVERHEAD_64 = 438;
    private static final int TWOHASHMAPS_OVERHEAD_OOPS = 256;
    private static final int TWOHASHMAPS_OVERHEAD_DALVIK = 112;
    private static final int TREEMAP_OVERHEAD_32 = 48;
    private static final int TREEMAP_OVERHEAD_64 = 80;
    private static final int TREEMAP_OVERHEAD_OOPS = 48;
    private static final int TREEMAP_OVERHEAD_DALVIK = 40;
    private static final int TREEMAP_ENTRY_OVERHEAD_32 = 32;
    private static final int TREEMAP_ENTRY_OVERHEAD_64 = 64;
    private static final int TREEMAP_ENTRY_OVERHEAD_OOPS = 40;
    private static final int TREEMAP_ENTRY_OVERHEAD_DALVIK = 616;
    private static final int MAPLN_OVERHEAD_32 = 920;
    private static final int MAPLN_OVERHEAD_64 = 1624;
    private static final int MAPLN_OVERHEAD_OOPS = 1016;
    private static final int MAPLN_OVERHEAD_DALVIK = 952;
    private static final int LN_OVERHEAD_32 = 16;
    private static final int LN_OVERHEAD_64 = 32;
    private static final int LN_OVERHEAD_OOPS = 24;
    private static final int LN_OVERHEAD_DALVIK = 24;
    private static final int VERSIONEDLN_OVERHEAD_32 = 8;
    private static final int VERSIONEDLN_OVERHEAD_64 = 8;
    private static final int VERSIONEDLN_OVERHEAD_OOPS = 8;
    private static final int VERSIONEDLN_OVERHEAD_DALVIK = 8;
    private static final int DUPCOUNTLN_OVERHEAD_32 = 32;
    private static final int DUPCOUNTLN_OVERHEAD_64 = 48;
    private static final int DUPCOUNTLN_OVERHEAD_OOPS = 40;
    private static final int DUPCOUNTLN_OVERHEAD_DALVIK = 32;
    private static final int BIN_FIXED_OVERHEAD_32 = 384;
    private static final int BIN_FIXED_OVERHEAD_64 = 512;
    private static final int BIN_FIXED_OVERHEAD_OOPS = 344;
    private static final int BIN_FIXED_OVERHEAD_DALVIK = 168;
    private static final int BINDELTA_OVERHEAD_32 = 48;
    private static final int BINDELTA_OVERHEAD_64 = 72;
    private static final int BINDELTA_OVERHEAD_OOPS = 64;
    private static final int BINDELTA_OVERHEAD_DALVIK = 64;
    private static final int DELTAINFO_OVERHEAD_32 = 24;
    private static final int DELTAINFO_OVERHEAD_64 = 40;
    private static final int DELTAINFO_OVERHEAD_OOPS = 32;
    private static final int DELTAINFO_OVERHEAD_DALVIK = 32;
    private static final int SPARSE_TARGET_ENTRY_OVERHEAD_32 = 72;
    private static final int SPARSE_TARGET_ENTRY_OVERHEAD_64 = 120;
    private static final int SPARSE_TARGET_ENTRY_OVERHEAD_OOPS = 80;
    private static final int SPARSE_TARGET_ENTRY_OVERHEAD_DALVIK = 96;
    private static final int DEFAULT_TARGET_ENTRY_OVERHEAD_32 = 16;
    private static final int DEFAULT_TARGET_ENTRY_OVERHEAD_64 = 24;
    private static final int DEFAULT_TARGET_ENTRY_OVERHEAD_OOPS = 16;
    private static final int DEFAULT_TARGET_ENTRY_OVERHEAD_DALVIK = 16;
    private static final int MAX_KEY_SIZE_KEYVALS_OVERHEAD_32 = 16;
    private static final int MAX_KEY_SIZE_KEYVALS_OVERHEAD_64 = 32;
    private static final int MAX_KEY_SIZE_KEYVALS_OVERHEAD_OOPS = 24;
    private static final int MAX_KEY_SIZE_KEYVALS_OVERHEAD_DALVIK = 24;
    private static final int DEFAULT_KEYVALS_OVERHEAD_32 = 16;
    private static final int DEFAULT_KEYVALS_OVERHEAD_64 = 24;
    private static final int DEFAULT_KEYVALS_OVERHEAD_OOPS = 16;
    private static final int DEFAULT_KEYVALS_OVERHEAD_DALVIK = 16;
    private static final int DEFAULT_VLSN_CACHE_OVERHEAD_32 = 16;
    private static final int DEFAULT_VLSN_CACHE_OVERHEAD_64 = 32;
    private static final int DEFAULT_VLSN_CACHE_OVERHEAD_OOPS = 24;
    private static final int DEFAULT_VLSN_CACHE_OVERHEAD_DALVIK = 24;
    private static final int DIN_FIXED_OVERHEAD_32 = 120;
    private static final int DIN_FIXED_OVERHEAD_64 = 176;
    private static final int DIN_FIXED_OVERHEAD_OOPS = 120;
    private static final int DIN_FIXED_OVERHEAD_DALVIK = 128;
    private static final int DBIN_FIXED_OVERHEAD_32 = 152;
    private static final int DBIN_FIXED_OVERHEAD_64 = 232;
    private static final int DBIN_FIXED_OVERHEAD_OOPS = 168;
    private static final int DBIN_FIXED_OVERHEAD_DALVIK = 168;
    private static final int IN_FIXED_OVERHEAD_32 = 336;
    private static final int IN_FIXED_OVERHEAD_64 = 439;
    private static final int IN_FIXED_OVERHEAD_OOPS = 295;
    private static final int IN_FIXED_OVERHEAD_DALVIK = 120;
    private static final int KEY_OVERHEAD_32 = 16;
    private static final int KEY_OVERHEAD_64 = 24;
    private static final int KEY_OVERHEAD_OOPS = 16;
    private static final int KEY_OVERHEAD_DALVIK = 16;
    private static final int LOCKIMPL_OVERHEAD_32 = 24;
    private static final int LOCKIMPL_OVERHEAD_64 = 48;
    private static final int LOCKIMPL_OVERHEAD_OOPS = 32;
    private static final int LOCKIMPL_OVERHEAD_DALVIK = 32;
    private static final int THINLOCKIMPL_OVERHEAD_32 = 16;
    private static final int THINLOCKIMPL_OVERHEAD_64 = 32;
    private static final int THINLOCKIMPL_OVERHEAD_OOPS = 24;
    private static final int THINLOCKIMPL_OVERHEAD_DALVIK = 24;
    private static final int LOCKINFO_OVERHEAD_32 = 16;
    private static final int LOCKINFO_OVERHEAD_64 = 32;
    private static final int LOCKINFO_OVERHEAD_OOPS = 24;
    private static final int LOCKINFO_OVERHEAD_DALVIK = 24;
    private static final int WRITE_LOCKINFO_OVERHEAD_32 = 32;
    private static final int WRITE_LOCKINFO_OVERHEAD_64 = 40;
    private static final int WRITE_LOCKINFO_OVERHEAD_OOPS = 32;
    private static final int WRITE_LOCKINFO_OVERHEAD_DALVIK = 40;
    private static final int TXN_OVERHEAD_32 = 224;
    private static final int TXN_OVERHEAD_64 = 353;
    private static final int TXN_OVERHEAD_OOPS = 232;
    private static final int TXN_OVERHEAD_DALVIK = 263;
    private static final int CHECKPOINT_REFERENCE_SIZE_32 = 56;
    private static final int CHECKPOINT_REFERENCE_SIZE_64 = 103;
    private static final int CHECKPOINT_REFERENCE_SIZE_OOPS = 64;
    private static final int CHECKPOINT_REFERENCE_SIZE_DALVIK = 104;
    private static final int UTILIZATION_PROFILE_ENTRY_32 = 109;
    private static final int UTILIZATION_PROFILE_ENTRY_64 = 161;
    private static final int UTILIZATION_PROFILE_ENTRY_OOPS = 125;
    private static final int UTILIZATION_PROFILE_ENTRY_DALVIK = 145;
    private static final int DBFILESUMMARY_OVERHEAD_32 = 40;
    private static final int DBFILESUMMARY_OVERHEAD_64 = 48;
    private static final int DBFILESUMMARY_OVERHEAD_OOPS = 48;
    private static final int DBFILESUMMARY_OVERHEAD_DALVIK = 48;
    private static final int TFS_LIST_INITIAL_OVERHEAD_32 = 464;
    private static final int TFS_LIST_INITIAL_OVERHEAD_64 = 504;
    private static final int TFS_LIST_INITIAL_OVERHEAD_OOPS = 464;
    private static final int TFS_LIST_INITIAL_OVERHEAD_DALVIK = 472;
    private static final int TFS_LIST_SEGMENT_OVERHEAD_32 = 440;
    private static final int TFS_LIST_SEGMENT_OVERHEAD_64 = 465;
    private static final int TFS_LIST_SEGMENT_OVERHEAD_OOPS = 440;
    private static final int TFS_LIST_SEGMENT_OVERHEAD_DALVIK = 448;
    private static final int LN_INFO_OVERHEAD_32 = 24;
    private static final int LN_INFO_OVERHEAD_64 = 40;
    private static final int LN_INFO_OVERHEAD_OOPS = 24;
    private static final int LN_INFO_OVERHEAD_DALVIK = 24;
    private static final int FILESUMMARYLN_OVERHEAD_32 = 112;
    private static final int FILESUMMARYLN_OVERHEAD_64 = 168;
    private static final int FILESUMMARYLN_OVERHEAD_OOPS = 128;
    private static final int FILESUMMARYLN_OVERHEAD_DALVIK = 128;
    private static final int INENTRY_OVERHEAD_32 = 16;
    private static final int INENTRY_OVERHEAD_64 = 32;
    private static final int INENTRY_OVERHEAD_OOPS = 24;
    private static final int INENTRY_OVERHEAD_DALVIK = 24;
    private static final int DELTAINENTRY_OVERHEAD_32 = 32;
    private static final int DELTAINENTRY_OVERHEAD_64 = 48;
    private static final int DELTAINENTRY_OVERHEAD_OOPS = 32;
    private static final int DELTAINENTRY_OVERHEAD_DALVIK = 40;
    private static final int EMPTY_OBJ_ARRAY = MemoryBudget.objectArraySize(0);
    private static final int ARRAYLIST_OVERHEAD_32 = 40 - EMPTY_OBJ_ARRAY;
    private static final int ARRAYLIST_OVERHEAD_64 = 64 - EMPTY_OBJ_ARRAY;
    private static final int ARRAYLIST_OVERHEAD_OOPS = 40 - EMPTY_OBJ_ARRAY;
    private static final int ARRAYLIST_OVERHEAD_DALVIK = 24 - EMPTY_OBJ_ARRAY;
    private static final int TUPLE_OUTPUT_OVERHEAD_32 = 24;
    private static final int TUPLE_OUTPUT_OVERHEAD_64 = 32;
    private static final int TUPLE_OUTPUT_OVERHEAD_OOPS = 24;
    private static final int TUPLE_OUTPUT_OVERHEAD_DALVIK = 24;
    public static final int LONG_OVERHEAD;
    public static final int ARRAY_OVERHEAD;
    public static final int ARRAY_SIZE_INCLUDED;
    public static final int OBJECT_OVERHEAD;
    public static final int OBJECT_ARRAY_ITEM_OVERHEAD;
    public static final int HASHMAP_OVERHEAD;
    public static final int HASHMAP_ENTRY_OVERHEAD;
    public static final int HASHSET_OVERHEAD;
    public static final int HASHSET_ENTRY_OVERHEAD;
    public static final int TWOHASHMAPS_OVERHEAD;
    public static final int TREEMAP_OVERHEAD;
    public static final int TREEMAP_ENTRY_OVERHEAD;
    public static final int MAPLN_OVERHEAD;
    public static final int LN_OVERHEAD;
    public static final int VERSIONEDLN_OVERHEAD;
    public static final int DUPCOUNTLN_OVERHEAD;
    public static final int BIN_FIXED_OVERHEAD;
    public static final int BINDELTA_OVERHEAD;
    public static final int DELTAINFO_OVERHEAD;
    public static final int SPARSE_TARGET_ENTRY_OVERHEAD;
    public static final int DEFAULT_TARGET_ENTRY_OVERHEAD;
    public static final int DEFAULT_KEYVALS_OVERHEAD;
    public static final int MAX_KEY_SIZE_KEYVALS_OVERHEAD;
    public static final int DEFAULT_VLSN_CACHE_OVERHEAD;
    public static final int DIN_FIXED_OVERHEAD;
    public static final int DBIN_FIXED_OVERHEAD;
    public static final int IN_FIXED_OVERHEAD;
    public static final int KEY_OVERHEAD;
    public static final int LOCKIMPL_OVERHEAD;
    public static final int THINLOCKIMPL_OVERHEAD;
    public static final int LOCKINFO_OVERHEAD;
    public static final int WRITE_LOCKINFO_OVERHEAD;
    public static final int TXN_OVERHEAD;
    public static final int CHECKPOINT_REFERENCE_SIZE;
    public static final int UTILIZATION_PROFILE_ENTRY;
    public static final int DBFILESUMMARY_OVERHEAD;
    public static final int TFS_LIST_INITIAL_OVERHEAD;
    public static final int TFS_LIST_SEGMENT_OVERHEAD;
    public static final int LN_INFO_OVERHEAD;
    public static final int FILESUMMARYLN_OVERHEAD;
    public static final int INENTRY_OVERHEAD;
    public static final int DELTAINENTRY_OVERHEAD;
    public static final int ARRAYLIST_OVERHEAD;
    public static final int TUPLE_OUTPUT_OVERHEAD;
    public static final int PRIMITIVE_LONG_ARRAY_ITEM_OVERHEAD = 8;
    private static final String JVM_ARCH_PROPERTY = "sun.arch.data.model";
    private static final String FORCE_JVM_ARCH = "je.forceJVMArch";
    private static boolean COMPRESSED_OOPS_REQUESTED;
    private static boolean COMPRESSED_OOPS_KNOWN;
    private static boolean COMPRESSED_OOPS_KNOWN_ON;
    public static final long MIN_MAX_MEMORY_SIZE = 98304L;
    public static final String MIN_MAX_MEMORY_SIZE_STRING;
    private static final int DEFAULT_MIN_BTREE_CACHE_SIZE = 512000;
    private static final long N_64MB = 0x4000000L;
    private final AtomicLong treeMemoryUsage = new AtomicLong(0L);
    private final AtomicLong txnMemoryUsage = new AtomicLong(0L);
    private final AtomicLong adminMemoryUsage = new AtomicLong(0L);
    private final AtomicLong treeAdminMemoryUsage = new AtomicLong(0L);
    private final AtomicLong lockMemoryUsage = new AtomicLong(0L);
    private final Totals totals;
    private long logBufferBudget;
    private long trackerBudget;
    private long minTreeMemoryUsage;
    private final EnvironmentImpl envImpl;

    MemoryBudget(EnvironmentImpl envImpl, EnvironmentImpl sharedCacheEnv, DbConfigManager configManager) throws DatabaseException {
        long newMaxMemory;
        this.envImpl = envImpl;
        envImpl.addConfigObserver(this);
        if (envImpl.getSharedCache()) {
            if (sharedCacheEnv != null) {
                this.totals = sharedCacheEnv.getMemoryBudget().totals;
                newMaxMemory = -1L;
            } else {
                this.totals = new SharedTotals();
                newMaxMemory = this.calcMaxMemory(configManager);
            }
        } else {
            this.totals = new PrivateTotals(this);
            newMaxMemory = this.calcMaxMemory(configManager);
        }
        this.reset(newMaxMemory, true, configManager);
        this.checkCompressedOops();
    }

    private void checkCompressedOops() {
        if (COMPRESSED_OOPS_REQUESTED && COMPRESSED_OOPS_KNOWN && !COMPRESSED_OOPS_KNOWN_ON) {
            LoggerUtils.severe(this.envImpl.getLogger(), this.envImpl, "-XX:+UseCompressedOops was specified but is not in effect, probably because the heap size is too large for this JVM option on this platform.  This is likely to cause an OutOfMemoryError!");
        }
    }

    public void envConfigUpdate(DbConfigManager configManager, EnvironmentMutableConfig ignore) throws DatabaseException {
        this.reset(this.calcMaxMemory(configManager), false, configManager);
    }

    private long calcMaxMemory(DbConfigManager configManager) {
        long newMaxMemory = configManager.getLong(EnvironmentParams.MAX_MEMORY);
        long jvmMemory = MemoryBudget.getRuntimeMaxMemory();
        if (newMaxMemory != 0L) {
            if (jvmMemory < newMaxMemory) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " has a value of " + newMaxMemory + " but the JVM is only configured for " + jvmMemory + ". Consider using je.maxMemoryPercent.");
            }
            if (newMaxMemory < 98304L) {
                throw new IllegalArgumentException(EnvironmentParams.MAX_MEMORY.getName() + " is " + newMaxMemory + " which is less than the minimum: " + 98304L);
            }
        } else {
            if (jvmMemory == Long.MAX_VALUE) {
                jvmMemory = 0x4000000L;
            }
            int maxMemoryPercent = configManager.getInt(EnvironmentParams.MAX_MEMORY_PERCENT);
            newMaxMemory = (long)maxMemoryPercent * jvmMemory / 100L;
        }
        return newMaxMemory;
    }

    void reset(long newMaxMemory, boolean newEnv, DbConfigManager configManager) throws DatabaseException {
        long myCachePortion;
        long oldLogBufferBudget = this.logBufferBudget;
        if (newMaxMemory < 0L) {
            newMaxMemory = this.getMaxMemory();
        } else {
            this.totals.setMaxMemory(newMaxMemory);
        }
        if (this.envImpl.getSharedCache()) {
            int nEnvs = DbEnvPool.getInstance().getNSharedCacheEnvironments();
            if (newEnv) {
                ++nEnvs;
            }
            myCachePortion = newMaxMemory / (long)nEnvs;
        } else {
            myCachePortion = newMaxMemory;
        }
        long newLogBufferBudget = configManager.getLong(EnvironmentParams.LOG_MEM_SIZE);
        if (newLogBufferBudget == 0L) {
            newLogBufferBudget = EnvironmentImpl.IS_DALVIK ? myCachePortion >> 7 : myCachePortion >> 4;
        } else if (newLogBufferBudget > myCachePortion / 2L) {
            newLogBufferBudget = myCachePortion / 2L;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long startingBufferSize = newLogBufferBudget / (long)numBuffers;
        int logBufferSize = configManager.getInt(EnvironmentParams.LOG_BUFFER_MAX_SIZE);
        if (startingBufferSize > (long)logBufferSize) {
            startingBufferSize = logBufferSize;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        } else if (startingBufferSize < 2048L) {
            startingBufferSize = 2048L;
            newLogBufferBudget = (long)numBuffers * startingBufferSize;
        }
        long newCriticalThreshold = newMaxMemory * (long)this.envImpl.getConfigManager().getInt(EnvironmentParams.EVICTOR_CRITICAL_PERCENTAGE) / 100L;
        long newTrackerBudget = myCachePortion * (long)this.envImpl.getConfigManager().getInt(EnvironmentParams.CLEANER_DETAIL_MAX_MEMORY_PERCENTAGE) / 100L;
        long newMinTreeMemoryUsage = Math.min(configManager.getLong(EnvironmentParams.MIN_TREE_MEMORY), myCachePortion - newLogBufferBudget);
        this.logBufferBudget = newLogBufferBudget;
        this.totals.setCriticalThreshold(newCriticalThreshold);
        this.trackerBudget = newTrackerBudget;
        this.minTreeMemoryUsage = newMinTreeMemoryUsage;
        this.totals.updateCacheUsage(this.logBufferBudget - oldLogBufferBudget);
        if (!newEnv && oldLogBufferBudget != this.logBufferBudget) {
            this.envImpl.getLogManager().resetPool(configManager);
        }
    }

    public static long getRuntimeMaxMemory() {
        String jvmVersion;
        if ("Mac OS X".equals(System.getProperty("os.name")) && (jvmVersion = System.getProperty("java.version")) != null && jvmVersion.startsWith("1.4.2")) {
            return Long.MAX_VALUE;
        }
        return Runtime.getRuntime().maxMemory();
    }

    void initCacheMemoryUsage(long dbTreeAdminMemory) {
        long totalTree = 0L;
        long treeAdmin = 0L;
        for (IN in : this.envImpl.getInMemoryINs()) {
            totalTree += in.getBudgetedMemorySize();
            treeAdmin += in.getTreeAdminMemorySize();
        }
        this.refreshTreeMemoryUsage(totalTree);
        this.refreshTreeAdminMemoryUsage(treeAdmin + dbTreeAdminMemory);
    }

    void refreshTreeAdminMemoryUsage(long newSize) {
        long oldSize = this.treeAdminMemoryUsage.getAndSet(newSize);
        long diff = newSize - oldSize;
        if (DEBUG_TREEADMIN) {
            System.err.println("RESET = " + newSize);
        }
        if (this.totals.updateCacheUsage(diff)) {
            this.envImpl.alertEvictor();
        }
    }

    void refreshTreeMemoryUsage(long newSize) {
        long oldSize = this.treeMemoryUsage.getAndSet(newSize);
        long diff = newSize - oldSize;
        if (this.totals.updateCacheUsage(diff)) {
            this.envImpl.alertEvictor();
        }
    }

    public boolean isTreeUsageAboveMinimum() {
        return this.treeMemoryUsage.get() > this.minTreeMemoryUsage;
    }

    public long getMinTreeMemoryUsage() {
        return this.minTreeMemoryUsage;
    }

    public void updateTreeMemoryUsage(long increment) {
        this.updateCounter(increment, this.treeMemoryUsage, "tree", DEBUG_TREE);
    }

    public void updateTxnMemoryUsage(long increment) {
        this.updateCounter(increment, this.txnMemoryUsage, "txn", DEBUG_TXN);
    }

    public void updateAdminMemoryUsage(long increment) {
        this.updateCounter(increment, this.adminMemoryUsage, "admin", DEBUG_ADMIN);
    }

    public void updateTreeAdminMemoryUsage(long increment) {
        this.updateCounter(increment, this.treeAdminMemoryUsage, "treeAdmin", DEBUG_TREEADMIN);
    }

    private void updateCounter(long increment, AtomicLong counter, String debugName, boolean debug) {
        if (increment != 0L) {
            long newSize = counter.addAndGet(increment);
            assert (this.sizeNotNegative(newSize)) : this.makeErrorMessage(debugName, newSize, increment);
            if (debug) {
                if (increment > 0L) {
                    System.err.println("INC-------- =" + increment + " " + debugName + " " + newSize);
                } else {
                    System.err.println("-------DEC=" + increment + " " + debugName + " " + newSize);
                }
            }
            if (this.totals.updateCacheUsage(increment)) {
                this.envImpl.alertEvictor();
            }
        }
    }

    private boolean sizeNotNegative(long newSize) {
        if (CLEANUP_DONE) {
            return newSize >= 0L;
        }
        return true;
    }

    public void updateLockMemoryUsage(long increment, int lockTableIndex) {
        if (increment != 0L) {
            this.lockMemoryUsage.addAndGet(increment);
            assert (this.lockMemoryUsage.get() >= 0L) : this.makeErrorMessage("lockMem", this.lockMemoryUsage.get(), increment);
            if (DEBUG_LOCK) {
                if (increment > 0L) {
                    System.err.println("INC-------- =" + increment + " lock[" + lockTableIndex + "] " + this.lockMemoryUsage.get());
                } else {
                    System.err.println("-------DEC=" + increment + " lock[" + lockTableIndex + "] " + this.lockMemoryUsage.get());
                }
            }
            if (this.totals.updateCacheUsage(increment)) {
                this.envImpl.alertEvictor();
            }
        }
    }

    private String makeErrorMessage(String memoryType, long total, long increment) {
        return memoryType + "=" + total + " increment=" + increment + " " + LoggerUtils.getStackTrace(new Throwable());
    }

    void subtractCacheUsage() {
        this.totals.updateCacheUsage(0L - this.getLocalCacheUsage());
    }

    private long getLocalCacheUsage() {
        return this.logBufferBudget + this.treeMemoryUsage.get() + this.adminMemoryUsage.get() + this.treeAdminMemoryUsage.get() + this.getLockMemoryUsage();
    }

    long getVariableCacheUsage() {
        return this.treeMemoryUsage.get() + this.adminMemoryUsage.get() + this.treeAdminMemoryUsage.get() + this.getLockMemoryUsage();
    }

    public long getLockMemoryUsage() {
        long accLockMemoryUsage = this.txnMemoryUsage.get() + this.lockMemoryUsage.get();
        return accLockMemoryUsage;
    }

    public long getCacheMemoryUsage() {
        return this.totals.getCacheUsage();
    }

    public long getMaxMemory() {
        return this.totals.getMaxMemory();
    }

    public long getTreeMemoryUsage() {
        return this.treeMemoryUsage.get();
    }

    public long getAdminMemoryUsage() {
        return this.adminMemoryUsage.get();
    }

    public long getTreeAdminMemoryUsage() {
        return this.treeAdminMemoryUsage.get();
    }

    public long getLogBufferBudget() {
        return this.logBufferBudget;
    }

    public long getTrackerBudget() {
        return this.trackerBudget;
    }

    public static int tupleOutputSize(TupleOutput o) {
        return TUPLE_OUTPUT_OVERHEAD + MemoryBudget.byteArraySize(o.getBufferBytes().length);
    }

    public static int byteArraySize(int arrayLen) {
        int size = ARRAY_OVERHEAD;
        if (arrayLen > ARRAY_SIZE_INCLUDED) {
            size += (arrayLen - ARRAY_SIZE_INCLUDED + 7) / 8 * 8;
        }
        return size;
    }

    public static int shortArraySize(int arrayLen) {
        return MemoryBudget.byteArraySize(arrayLen * 2);
    }

    public static int intArraySize(int arrayLen) {
        return MemoryBudget.byteArraySize(arrayLen * 4);
    }

    public static int objectArraySize(int arrayLen) {
        return MemoryBudget.byteArraySize(arrayLen * OBJECT_ARRAY_ITEM_OVERHEAD);
    }

    StatGroup loadStats() {
        StatGroup stats = new StatGroup("Cache Layout", "Allocation of resources in the cache.");
        new LongStat(stats, DbiStatDefinition.MB_SHARED_CACHE_TOTAL_BYTES, this.totals.isSharedCache() ? this.totals.getCacheUsage() : 0L);
        new LongStat(stats, DbiStatDefinition.MB_TOTAL_BYTES, this.getLocalCacheUsage());
        new LongStat(stats, DbiStatDefinition.MB_DATA_BYTES, this.treeMemoryUsage.get() + this.treeAdminMemoryUsage.get());
        new LongStat(stats, DbiStatDefinition.MB_DATA_ADMIN_BYTES, this.treeAdminMemoryUsage.get());
        new LongStat(stats, DbiStatDefinition.MB_ADMIN_BYTES, this.adminMemoryUsage.get());
        new LongStat(stats, DbiStatDefinition.MB_LOCK_BYTES, this.getLockMemoryUsage());
        return stats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("treeUsage = ").append(this.treeMemoryUsage.get());
        sb.append("treeAdminUsage = ").append(this.treeAdminMemoryUsage.get());
        sb.append("adminUsage = ").append(this.adminMemoryUsage.get());
        sb.append("txnUsage = ").append(this.txnMemoryUsage.get());
        sb.append("lockUsage = ").append(this.getLockMemoryUsage());
        return sb.toString();
    }

    public Totals getTotals() {
        return this.totals;
    }

    static {
        COMPRESSED_OOPS_REQUESTED = false;
        COMPRESSED_OOPS_KNOWN = false;
        COMPRESSED_OOPS_KNOWN_ON = false;
        if (EnvironmentImpl.IS_DALVIK) {
            LONG_OVERHEAD = 24;
            ARRAY_OVERHEAD = 24;
            ARRAY_SIZE_INCLUDED = 4;
            OBJECT_OVERHEAD = 16;
            OBJECT_ARRAY_ITEM_OVERHEAD = 4;
            HASHMAP_OVERHEAD = 56;
            HASHMAP_ENTRY_OVERHEAD = 72;
            HASHSET_OVERHEAD = 72;
            HASHSET_ENTRY_OVERHEAD = 72;
            TWOHASHMAPS_OVERHEAD = 112;
            TREEMAP_OVERHEAD = 40;
            TREEMAP_ENTRY_OVERHEAD = 616;
            MAPLN_OVERHEAD = 952;
            LN_OVERHEAD = 24;
            VERSIONEDLN_OVERHEAD = 8;
            DUPCOUNTLN_OVERHEAD = 32;
            BIN_FIXED_OVERHEAD = 168;
            BINDELTA_OVERHEAD = 64;
            DELTAINFO_OVERHEAD = 32;
            SPARSE_TARGET_ENTRY_OVERHEAD = 96;
            DEFAULT_TARGET_ENTRY_OVERHEAD = 16;
            DEFAULT_KEYVALS_OVERHEAD = 16;
            MAX_KEY_SIZE_KEYVALS_OVERHEAD = 24;
            DEFAULT_VLSN_CACHE_OVERHEAD = 24;
            DIN_FIXED_OVERHEAD = 128;
            DBIN_FIXED_OVERHEAD = 168;
            IN_FIXED_OVERHEAD = 120;
            KEY_OVERHEAD = 16;
            LOCKIMPL_OVERHEAD = 32;
            THINLOCKIMPL_OVERHEAD = 24;
            LOCKINFO_OVERHEAD = 24;
            WRITE_LOCKINFO_OVERHEAD = 40;
            TXN_OVERHEAD = 263;
            CHECKPOINT_REFERENCE_SIZE = 104;
            UTILIZATION_PROFILE_ENTRY = 145;
            DBFILESUMMARY_OVERHEAD = 48;
            TFS_LIST_INITIAL_OVERHEAD = 472;
            TFS_LIST_SEGMENT_OVERHEAD = 448;
            LN_INFO_OVERHEAD = 24;
            FILESUMMARYLN_OVERHEAD = 128;
            INENTRY_OVERHEAD = 24;
            DELTAINENTRY_OVERHEAD = 40;
            ARRAYLIST_OVERHEAD = ARRAYLIST_OVERHEAD_DALVIK;
            TUPLE_OUTPUT_OVERHEAD = 24;
        } else {
            boolean useCompressedOops;
            String javaVersion = System.getProperty("java.version");
            boolean is64 = false;
            String overrideArch = System.getProperty(FORCE_JVM_ARCH);
            try {
                if (overrideArch == null) {
                    String arch = System.getProperty(JVM_ARCH_PROPERTY);
                    if (arch != null) {
                        is64 = Integer.parseInt(arch) == 64;
                    }
                } else {
                    is64 = Integer.parseInt(overrideArch) == 64;
                }
            }
            catch (NumberFormatException NFE) {
                NFE.printStackTrace(System.err);
            }
            Boolean checkCompressedOops = CompressedOopsDetector.isEnabled();
            if (checkCompressedOops != null) {
                COMPRESSED_OOPS_KNOWN = true;
                COMPRESSED_OOPS_KNOWN_ON = checkCompressedOops;
            }
            List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : args) {
                if (!"-XX:+UseCompressedOops".equals(arg)) continue;
                COMPRESSED_OOPS_REQUESTED = true;
                break;
            }
            boolean bl = useCompressedOops = COMPRESSED_OOPS_KNOWN ? COMPRESSED_OOPS_KNOWN_ON : COMPRESSED_OOPS_REQUESTED;
            if (useCompressedOops) {
                LONG_OVERHEAD = 24;
                ARRAY_OVERHEAD = 16;
                ARRAY_SIZE_INCLUDED = 0;
                OBJECT_OVERHEAD = 16;
                OBJECT_ARRAY_ITEM_OVERHEAD = 4;
                HASHMAP_ENTRY_OVERHEAD = 32;
                HASHSET_OVERHEAD = 144;
                HASHSET_ENTRY_OVERHEAD = 32;
                TREEMAP_OVERHEAD = 48;
                MAPLN_OVERHEAD = 1016;
                BIN_FIXED_OVERHEAD = 344;
                BINDELTA_OVERHEAD = 64;
                DELTAINFO_OVERHEAD = 32;
                SPARSE_TARGET_ENTRY_OVERHEAD = 80;
                DEFAULT_TARGET_ENTRY_OVERHEAD = 16;
                DEFAULT_KEYVALS_OVERHEAD = 16;
                MAX_KEY_SIZE_KEYVALS_OVERHEAD = 24;
                DEFAULT_VLSN_CACHE_OVERHEAD = 24;
                DIN_FIXED_OVERHEAD = 120;
                DBIN_FIXED_OVERHEAD = 168;
                IN_FIXED_OVERHEAD = 295;
                HASHMAP_OVERHEAD = 128;
                TWOHASHMAPS_OVERHEAD = 256;
                TREEMAP_ENTRY_OVERHEAD = 40;
                LN_OVERHEAD = 24;
                VERSIONEDLN_OVERHEAD = 8;
                DUPCOUNTLN_OVERHEAD = 40;
                TXN_OVERHEAD = 232;
                CHECKPOINT_REFERENCE_SIZE = 64;
                KEY_OVERHEAD = 16;
                LOCKIMPL_OVERHEAD = 32;
                THINLOCKIMPL_OVERHEAD = 24;
                LOCKINFO_OVERHEAD = 24;
                WRITE_LOCKINFO_OVERHEAD = 32;
                UTILIZATION_PROFILE_ENTRY = 125;
                DBFILESUMMARY_OVERHEAD = 48;
                TFS_LIST_INITIAL_OVERHEAD = 464;
                TFS_LIST_SEGMENT_OVERHEAD = 440;
                LN_INFO_OVERHEAD = 24;
                FILESUMMARYLN_OVERHEAD = 128;
                INENTRY_OVERHEAD = 24;
                DELTAINENTRY_OVERHEAD = 32;
                ARRAYLIST_OVERHEAD = ARRAYLIST_OVERHEAD_OOPS;
                TUPLE_OUTPUT_OVERHEAD = 24;
            } else if (is64) {
                LONG_OVERHEAD = 24;
                ARRAY_OVERHEAD = 24;
                ARRAY_SIZE_INCLUDED = 0;
                OBJECT_OVERHEAD = 16;
                OBJECT_ARRAY_ITEM_OVERHEAD = 8;
                HASHMAP_ENTRY_OVERHEAD = 52;
                HASHSET_OVERHEAD = 240;
                HASHSET_ENTRY_OVERHEAD = 55;
                TREEMAP_OVERHEAD = 80;
                MAPLN_OVERHEAD = 1624;
                BIN_FIXED_OVERHEAD = 512;
                DIN_FIXED_OVERHEAD = 176;
                DBIN_FIXED_OVERHEAD = 232;
                IN_FIXED_OVERHEAD = 439;
                HASHMAP_OVERHEAD = 219;
                TWOHASHMAPS_OVERHEAD = 438;
                BINDELTA_OVERHEAD = 72;
                DELTAINFO_OVERHEAD = 40;
                SPARSE_TARGET_ENTRY_OVERHEAD = 120;
                DEFAULT_TARGET_ENTRY_OVERHEAD = 24;
                DEFAULT_KEYVALS_OVERHEAD = 24;
                MAX_KEY_SIZE_KEYVALS_OVERHEAD = 32;
                DEFAULT_VLSN_CACHE_OVERHEAD = 32;
                TREEMAP_ENTRY_OVERHEAD = 64;
                LN_OVERHEAD = 32;
                VERSIONEDLN_OVERHEAD = 8;
                DUPCOUNTLN_OVERHEAD = 48;
                TXN_OVERHEAD = 353;
                CHECKPOINT_REFERENCE_SIZE = 103;
                KEY_OVERHEAD = 24;
                LOCKIMPL_OVERHEAD = 48;
                THINLOCKIMPL_OVERHEAD = 32;
                LOCKINFO_OVERHEAD = 32;
                WRITE_LOCKINFO_OVERHEAD = 40;
                UTILIZATION_PROFILE_ENTRY = 161;
                DBFILESUMMARY_OVERHEAD = 48;
                TFS_LIST_INITIAL_OVERHEAD = 504;
                TFS_LIST_SEGMENT_OVERHEAD = 465;
                LN_INFO_OVERHEAD = 40;
                FILESUMMARYLN_OVERHEAD = 168;
                INENTRY_OVERHEAD = 32;
                DELTAINENTRY_OVERHEAD = 48;
                ARRAYLIST_OVERHEAD = ARRAYLIST_OVERHEAD_64;
                TUPLE_OUTPUT_OVERHEAD = 32;
            } else {
                LONG_OVERHEAD = 16;
                ARRAY_OVERHEAD = 16;
                ARRAY_SIZE_INCLUDED = 4;
                OBJECT_OVERHEAD = 8;
                OBJECT_ARRAY_ITEM_OVERHEAD = 4;
                HASHMAP_OVERHEAD = 120;
                HASHMAP_ENTRY_OVERHEAD = 24;
                HASHSET_OVERHEAD = 136;
                HASHSET_ENTRY_OVERHEAD = 24;
                TWOHASHMAPS_OVERHEAD = 240;
                TREEMAP_OVERHEAD = 48;
                MAPLN_OVERHEAD = 920;
                TREEMAP_ENTRY_OVERHEAD = 32;
                LN_OVERHEAD = 16;
                VERSIONEDLN_OVERHEAD = 8;
                DUPCOUNTLN_OVERHEAD = 32;
                BIN_FIXED_OVERHEAD = 384;
                BINDELTA_OVERHEAD = 48;
                DELTAINFO_OVERHEAD = 24;
                SPARSE_TARGET_ENTRY_OVERHEAD = 72;
                DEFAULT_TARGET_ENTRY_OVERHEAD = 16;
                DEFAULT_KEYVALS_OVERHEAD = 16;
                MAX_KEY_SIZE_KEYVALS_OVERHEAD = 16;
                DEFAULT_VLSN_CACHE_OVERHEAD = 16;
                DIN_FIXED_OVERHEAD = 120;
                DBIN_FIXED_OVERHEAD = 152;
                IN_FIXED_OVERHEAD = 336;
                TXN_OVERHEAD = 224;
                CHECKPOINT_REFERENCE_SIZE = 56;
                KEY_OVERHEAD = 16;
                LOCKIMPL_OVERHEAD = 24;
                THINLOCKIMPL_OVERHEAD = 16;
                LOCKINFO_OVERHEAD = 16;
                WRITE_LOCKINFO_OVERHEAD = 32;
                UTILIZATION_PROFILE_ENTRY = 109;
                DBFILESUMMARY_OVERHEAD = 40;
                TFS_LIST_INITIAL_OVERHEAD = 464;
                TFS_LIST_SEGMENT_OVERHEAD = 440;
                LN_INFO_OVERHEAD = 24;
                FILESUMMARYLN_OVERHEAD = 112;
                INENTRY_OVERHEAD = 16;
                DELTAINENTRY_OVERHEAD = 32;
                ARRAYLIST_OVERHEAD = ARRAYLIST_OVERHEAD_32;
                TUPLE_OUTPUT_OVERHEAD = 24;
            }
        }
        MIN_MAX_MEMORY_SIZE_STRING = Long.toString(98304L);
    }

    private static class SharedTotals
    extends Totals {
        private final AtomicLong usage = new AtomicLong();

        private SharedTotals() {
        }

        public final long getCacheUsage() {
            return this.usage.get();
        }

        final boolean updateCacheUsage(long increment) {
            return this.usage.addAndGet(increment) > this.maxMemory;
        }

        final boolean isSharedCache() {
            return true;
        }
    }

    private static class PrivateTotals
    extends Totals {
        private final MemoryBudget parent;

        private PrivateTotals(MemoryBudget parent) {
            this.parent = parent;
        }

        public final long getCacheUsage() {
            return this.parent.getLocalCacheUsage();
        }

        final boolean updateCacheUsage(long increment) {
            return this.parent.getLocalCacheUsage() > this.maxMemory;
        }

        final boolean isSharedCache() {
            return false;
        }
    }

    public static abstract class Totals {
        long maxMemory = 0L;
        private long criticalThreshold;

        private Totals() {
        }

        private final void setMaxMemory(long maxMemory) {
            this.maxMemory = maxMemory;
        }

        public final long getMaxMemory() {
            return this.maxMemory;
        }

        private final void setCriticalThreshold(long criticalThreshold) {
            this.criticalThreshold = criticalThreshold;
        }

        public final long getCriticalThreshold() {
            return this.criticalThreshold;
        }

        public abstract long getCacheUsage();

        abstract boolean updateCacheUsage(long var1);

        abstract boolean isSharedCache();
    }
}

