/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonValueUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonValueUtils.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final QueryFilterVisitor<Boolean, JsonValue, JsonPointer> JSONVALUE_FILTER_VISITOR = new QueryFilterVisitor<Boolean, JsonValue, JsonPointer>(){

        public Boolean visitAndFilter(JsonValue p, List<QueryFilter<JsonPointer>> subFilters) {
            for (QueryFilter<JsonPointer> subFilter : subFilters) {
                if (((Boolean)subFilter.accept((QueryFilterVisitor)this, (Object)p)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visitBooleanLiteralFilter(JsonValue p, boolean value) {
            return value;
        }

        public Boolean visitContainsFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!this.isCompatible(valueAssertion, value)) continue;
                if (valueAssertion instanceof String) {
                    String s1 = ((String)valueAssertion).toLowerCase(Locale.ENGLISH);
                    String s2 = ((String)value).toLowerCase(Locale.ENGLISH);
                    if (!s2.contains(s1)) continue;
                    return Boolean.TRUE;
                }
                if (this.compareValues(valueAssertion, value) != 0) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visitEqualsFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
            Boolean result = Boolean.TRUE;
            for (Object value : this.getValues(p, field)) {
                if (this.isCompatible(valueAssertion, value) && this.compareValues(valueAssertion, value) == 0) continue;
                result = Boolean.FALSE;
            }
            return result;
        }

        public Boolean visitExtendedMatchFilter(JsonValue p, JsonPointer field, String matchingRuleId, Object valueAssertion) {
            return Boolean.FALSE;
        }

        public Boolean visitGreaterThanFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!this.isCompatible(valueAssertion, value) || this.compareValues(valueAssertion, value) >= 0) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visitGreaterThanOrEqualToFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!this.isCompatible(valueAssertion, value) || this.compareValues(valueAssertion, value) > 0) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visitLessThanFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!this.isCompatible(valueAssertion, value) || this.compareValues(valueAssertion, value) <= 0) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visitLessThanOrEqualToFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!this.isCompatible(valueAssertion, value) || this.compareValues(valueAssertion, value) < 0) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visitNotFilter(JsonValue p, QueryFilter<JsonPointer> subFilter) {
            return (Boolean)subFilter.accept((QueryFilterVisitor)this, (Object)p) == false;
        }

        public Boolean visitOrFilter(JsonValue p, List<QueryFilter<JsonPointer>> subFilters) {
            for (QueryFilter<JsonPointer> subFilter : subFilters) {
                if (!((Boolean)subFilter.accept((QueryFilterVisitor)this, (Object)p)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visitPresentFilter(JsonValue p, JsonPointer field) {
            JsonValue value = p.get(field);
            return value != null;
        }

        public Boolean visitStartsWithFilter(JsonValue p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!this.isCompatible(valueAssertion, value)) continue;
                if (valueAssertion instanceof String) {
                    String s1 = ((String)valueAssertion).toLowerCase(Locale.ENGLISH);
                    String s2 = ((String)value).toLowerCase(Locale.ENGLISH);
                    if (!s2.startsWith(s1)) continue;
                    return Boolean.TRUE;
                }
                if (this.compareValues(valueAssertion, value) != 0) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        private List<Object> getValues(JsonValue resource, JsonPointer field) {
            JsonValue value = resource.get(field);
            if (value == null) {
                return Collections.emptyList();
            }
            if (value.isList()) {
                return value.asList();
            }
            return Collections.singletonList(value.getObject());
        }

        private int compareValues(Object v1, Object v2) {
            if (v1 instanceof String && v2 instanceof String) {
                String s1 = (String)v1;
                String s2 = (String)v2;
                return s1.compareToIgnoreCase(s2);
            }
            if (v1 instanceof Number && v2 instanceof Number) {
                Double n1 = ((Number)v1).doubleValue();
                Double n2 = ((Number)v2).doubleValue();
                return n1.compareTo(n2);
            }
            if (v1 instanceof Boolean && v2 instanceof Boolean) {
                Boolean b1 = (Boolean)v1;
                Boolean b2 = (Boolean)v2;
                return b1.compareTo(b2);
            }
            return v1.getClass().getName().compareTo(v2.getClass().getName());
        }

        private boolean isCompatible(Object v1, Object v2) {
            return v1 instanceof String && v2 instanceof String || v1 instanceof Number && v2 instanceof Number || v1 instanceof Boolean && v2 instanceof Boolean;
        }
    };

    private JsonValueUtils() {
    }

    public static JsonValue expand(Map<String, Object> object) {
        TreeMap<String, Object> sortedObjects = new TreeMap<String, Object>(object);
        return JsonValueUtils.buildObject(sortedObjects);
    }

    public static Map<String, Object> flatten(JsonValue jsonValue) {
        LinkedHashMap<String, Object> flatObject = new LinkedHashMap<String, Object>();
        JsonValueUtils.flatten(new JsonPointer(), jsonValue, flatObject);
        return flatObject;
    }

    public static String extractValueAsString(JsonValue json, String fieldName) {
        JsonValue value = json.get(new JsonPointer(fieldName));
        if (value == null || value.isNull()) {
            return null;
        }
        if (value.isString()) {
            return value.asString();
        }
        String rawStr = null;
        try {
            rawStr = mapper.writeValueAsString(value.getObject());
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to write the value for field {} as a string.", (Object)fieldName);
        }
        return rawStr;
    }

    private static JsonValue buildObject(Map<String, Object> objectSet) {
        JsonValue jsonValue = new JsonValue(new LinkedHashMap());
        for (Map.Entry<String, Object> entry : objectSet.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (jsonValue.get(new JsonPointer(key)) != null && !jsonValue.get(new JsonPointer(key)).isNull()) continue;
            JsonPointer jsonPointer = new JsonPointer(key);
            int numberOfIndexTokens = JsonValueUtils.getIndexTokens(jsonPointer);
            if (numberOfIndexTokens > 1) {
                int firstIndexTokenPos = JsonValueUtils.getNextIndexToken(jsonPointer, 0);
                JsonPointer prefix = JsonValueUtils.subJsonPointer(jsonPointer, 0, firstIndexTokenPos + 1);
                jsonValue.putPermissive(JsonValueUtils.replaceLastIndexToken(prefix), JsonValueUtils.buildObject(JsonValueUtils.findObjectsThatMatchPrefix(prefix, objectSet)).getObject());
                continue;
            }
            jsonValue.putPermissive(JsonValueUtils.replaceLastIndexToken(jsonPointer), value);
        }
        return jsonValue;
    }

    private static Map<String, Object> findObjectsThatMatchPrefix(JsonPointer prefix, Map<String, Object> objectSet) {
        LinkedHashMap<String, Object> matchingObjects = new LinkedHashMap<String, Object>();
        for (String key : objectSet.keySet()) {
            if (!key.startsWith(prefix.toString())) continue;
            matchingObjects.put(key.substring(prefix.toString().length(), key.length()), objectSet.get(key));
        }
        return matchingObjects;
    }

    private static boolean isIndexToken(String token) {
        if (token.isEmpty()) {
            return false;
        }
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static JsonPointer replaceLastIndexToken(JsonPointer jsonPointer) {
        String[] jsonPointerTokens = jsonPointer.toArray();
        if (JsonValueUtils.getNextIndexToken(jsonPointer, jsonPointer.size() - 1) != -1) {
            jsonPointerTokens[jsonPointerTokens.length - 1] = "-";
        }
        return new JsonPointer(jsonPointerTokens);
    }

    private static int getNextIndexToken(JsonPointer jsonPointer, int start) {
        String[] jsonPointerTokens = jsonPointer.toArray();
        for (int i = start; i < jsonPointerTokens.length; ++i) {
            if (!JsonValueUtils.isIndexToken(jsonPointerTokens[i])) continue;
            return i;
        }
        return -1;
    }

    private static JsonPointer subJsonPointer(JsonPointer jsonPointer, int start, int end) {
        String[] jsonPointerTokens = jsonPointer.toArray();
        ArrayList<String> newJsonPointerTokens = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            newJsonPointerTokens.add(jsonPointerTokens[i]);
        }
        return new JsonPointer(newJsonPointerTokens.toArray(new String[newJsonPointerTokens.size()]));
    }

    private static int getIndexTokens(JsonPointer jsonPointer) {
        int numberOfIndexTokens = 0;
        String[] jsonPointerTokens = jsonPointer.toArray();
        for (int i = 0; i < jsonPointerTokens.length; ++i) {
            if (!JsonValueUtils.isIndexToken(jsonPointerTokens[i])) continue;
            ++numberOfIndexTokens;
        }
        return numberOfIndexTokens;
    }

    private static void flatten(JsonPointer pointer, JsonValue jsonValue, Map<String, Object> flatObject) {
        Set jsonValueKeys = jsonValue.get(pointer).keys();
        for (String key : jsonValueKeys) {
            JsonPointer keyPointer = JsonValueUtils.concatJsonPointer(pointer, key);
            JsonValue temp = jsonValue.get(keyPointer);
            if (temp.isMap() || temp.isList()) {
                JsonValueUtils.flatten(keyPointer, jsonValue, flatObject);
                continue;
            }
            flatObject.put(keyPointer.toString(), jsonValue.get(keyPointer).getObject());
        }
    }

    private static JsonPointer concatJsonPointer(JsonPointer pointer, String key) {
        String[] pointerTokens = pointer.toArray();
        String[] newPointerTokens = Arrays.copyOf(pointerTokens, pointerTokens.length + 1);
        newPointerTokens[pointerTokens.length] = key;
        return new JsonPointer(newPointerTokens);
    }
}

