/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.secure;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.SecretKey;
import org.forgerock.audit.secure.KeyStoreHandler;
import org.forgerock.audit.secure.KeyStoreHandlerDecorator;
import org.forgerock.audit.secure.SecureStorage;
import org.forgerock.audit.secure.SecureStorageException;

public class KeyStoreSecureStorage
implements SecureStorage {
    public static final String ENTRY_INITIAL_KEY = "InitialKey";
    public static final String ENTRY_SIGNATURE = "Signature";
    public static final String ENTRY_CURRENT_SIGNATURE = "CurrentSignature";
    public static final String ENTRY_CURRENT_KEY = "CurrentKey";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    public static final String HMAC_ALGORITHM = "HmacSHA256";
    public static final String JCEKS_KEYSTORE_TYPE = "JCEKS";
    private KeyStoreHandlerDecorator keyStoreHandler;
    private Signature verifier;
    private Signature signer;

    public KeyStoreSecureStorage(KeyStoreHandler keyStoreHandler, PrivateKey privateKey) {
        this(keyStoreHandler, null, privateKey);
    }

    public KeyStoreSecureStorage(KeyStoreHandler keyStoreHandler, PublicKey publicKey) {
        this(keyStoreHandler, publicKey, null);
    }

    public KeyStoreSecureStorage(KeyStoreHandler keyStoreHandler, PublicKey publicKey, PrivateKey privateKey) {
        this.setKeyStoreHandler(keyStoreHandler);
        if (privateKey != null) {
            try {
                this.signer = Signature.getInstance(SIGNATURE_ALGORITHM);
                this.signer.initSign(privateKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (publicKey != null) {
            try {
                this.verifier = Signature.getInstance(SIGNATURE_ALGORITHM);
                this.verifier.initVerify(publicKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public void setKeyStoreHandler(KeyStoreHandler keyStoreHandler) {
        this.keyStoreHandler = new KeyStoreHandlerDecorator(keyStoreHandler);
    }

    @Override
    public String getPassword() {
        return this.keyStoreHandler.getPassword();
    }

    @Override
    public SecretKey readCurrentKey() throws SecureStorageException {
        return this.keyStoreHandler.readSecretKeyFromKeyStore(ENTRY_CURRENT_KEY);
    }

    @Override
    public SecretKey readInitialKey() throws SecureStorageException {
        return this.keyStoreHandler.readSecretKeyFromKeyStore(ENTRY_INITIAL_KEY);
    }

    @Override
    public void writeCurrentSignatureKey(SecretKey key) throws SecureStorageException {
        this.keyStoreHandler.writeToKeyStore(key, ENTRY_CURRENT_SIGNATURE, this.keyStoreHandler.getPassword());
        try {
            this.keyStoreHandler.store();
        }
        catch (Exception ex) {
            throw new SecureStorageException(ex);
        }
    }

    @Override
    public void writeCurrentKey(SecretKey key) throws SecureStorageException {
        this.writeKey(key, ENTRY_CURRENT_KEY);
    }

    @Override
    public void writeInitialKey(SecretKey key) throws SecureStorageException {
        this.writeKey(key, ENTRY_INITIAL_KEY);
    }

    private void writeKey(SecretKey key, String alias) throws SecureStorageException {
        this.keyStoreHandler.writeToKeyStore(key, alias, this.keyStoreHandler.getPassword());
        try {
            this.keyStoreHandler.store();
        }
        catch (Exception ex) {
            throw new SecureStorageException(ex);
        }
    }

    @Override
    public byte[] sign(byte[] signedData) throws SecureStorageException {
        try {
            this.signer.update(signedData);
            return this.signer.sign();
        }
        catch (SignatureException e) {
            throw new SecureStorageException(e);
        }
    }

    @Override
    public boolean verify(byte[] signedData, byte[] signature) throws SecureStorageException {
        try {
            this.verifier.update(signedData);
            return this.verifier.verify(signature);
        }
        catch (SignatureException e) {
            throw new SecureStorageException(e);
        }
    }
}

