/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.secure;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;
import org.forgerock.audit.secure.KeyStoreHandler;
import org.forgerock.audit.secure.SecureStorageException;

public class KeyStoreHandlerDecorator
implements KeyStoreHandler {
    private final KeyStoreHandler delegate;

    public KeyStoreHandlerDecorator(KeyStoreHandler delegate) {
        this.delegate = delegate;
    }

    public void writeToKeyStore(SecretKey secretKey, String alias) throws SecureStorageException {
        this.writeToKeyStore(secretKey, alias, this.getPassword());
    }

    public void writeToKeyStore(SecretKey secretKey, String alias, String password) throws SecureStorageException {
        try {
            KeyStore store = this.getStore();
            if (store.containsAlias(alias)) {
                store.deleteEntry(alias);
            }
            KeyStore.SecretKeyEntry secKeyEntry = new KeyStore.SecretKeyEntry(secretKey);
            KeyStore.PasswordProtection params = new KeyStore.PasswordProtection(password.toCharArray());
            store.setEntry(alias, secKeyEntry, params);
        }
        catch (Exception ex) {
            throw new SecureStorageException(ex);
        }
    }

    public PublicKey readPublicKeyFromKeyStore(String alias) throws SecureStorageException {
        try {
            KeyStore store = this.getStore();
            Certificate certificate = store.getCertificate(alias);
            return certificate.getPublicKey();
        }
        catch (KeyStoreException ex) {
            throw new SecureStorageException("Error when reading public key: " + alias, ex);
        }
    }

    public PrivateKey readPrivateKeyFromKeyStore(String alias) throws SecureStorageException {
        return this.readPrivateKeyFromKeyStore(alias, this.getPassword());
    }

    public PrivateKey readPrivateKeyFromKeyStore(String alias, String password) throws SecureStorageException {
        try {
            KeyStore store = this.getStore();
            KeyStore.PasswordProtection params = password != null ? new KeyStore.PasswordProtection(password.toCharArray()) : null;
            KeyStore.PrivateKeyEntry keyentry = (KeyStore.PrivateKeyEntry)store.getEntry(alias, params);
            return keyentry != null ? keyentry.getPrivateKey() : null;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException ex) {
            throw new SecureStorageException(ex);
        }
    }

    public SecretKey readSecretKeyFromKeyStore(String alias) throws SecureStorageException {
        return this.readSecretKeyFromKeyStore(alias, this.getPassword());
    }

    public SecretKey readSecretKeyFromKeyStore(String alias, String password) throws SecureStorageException {
        try {
            KeyStore store = this.getStore();
            KeyStore.PasswordProtection params = new KeyStore.PasswordProtection(password.toCharArray());
            KeyStore.SecretKeyEntry keyentry = (KeyStore.SecretKeyEntry)store.getEntry(alias, params);
            return keyentry != null ? keyentry.getSecretKey() : null;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new SecureStorageException(e);
        }
    }

    @Override
    public KeyStore getStore() {
        return this.delegate.getStore();
    }

    @Override
    public void setStore(KeyStore keystore) throws Exception {
        this.delegate.setStore(keystore);
    }

    @Override
    public String getPassword() {
        return this.delegate.getPassword();
    }

    @Override
    public String getLocation() {
        return this.delegate.getLocation();
    }

    @Override
    public String getType() {
        return this.delegate.getType();
    }

    @Override
    public void store() throws Exception {
        this.delegate.store();
    }
}

