/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers.writers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.forgerock.audit.events.handlers.writers.TextWriter;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousTextWriter
implements TextWriter {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousTextWriter.class);
    private static final int CAPACITY = 5000;
    private final TextWriter writer;
    private final BlockingQueue<String> queue;
    private final ExecutorService executorService;
    private final boolean autoFlush;
    private volatile boolean stopRequested;

    public AsynchronousTextWriter(final String name, boolean autoFlush, TextWriter writer) {
        Reject.ifNull((Object)writer);
        this.autoFlush = autoFlush;
        this.writer = writer;
        this.queue = new LinkedBlockingQueue<String>(5000);
        this.stopRequested = false;
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, name);
            }
        });
        this.executorService.execute(new WriterTask());
    }

    private void writeMessage(String message) {
        try {
            this.writer.write(message);
        }
        catch (IOException e) {
            logger.error("Error when writing a message, message size: " + message.length(), (Throwable)e);
        }
    }

    @Override
    public void write(String record) throws IOException {
        boolean interrupted = false;
        boolean enqueued = false;
        while (!this.stopRequested) {
            try {
                this.queue.put(record);
                enqueued = true;
                break;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (!enqueued) {
            throw new IOException("Writer closed");
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            logger.error("Error  when flushing the writer", (Throwable)e);
        }
    }

    @Override
    public long getBytesWritten() {
        return this.writer.getBytesWritten();
    }

    public TextWriter getWrappedWriter() {
        return this.writer;
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean shutdownWrapped) {
        this.stopRequested = true;
        this.executorService.shutdown();
        boolean interrupted = false;
        while (!this.executorService.isTerminated()) {
            try {
                this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (shutdownWrapped) {
            this.writer.shutdown();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private class WriterTask
    implements Runnable {
        private WriterTask() {
        }

        @Override
        public void run() {
            ArrayList drainList = new ArrayList(5000);
            boolean interrupted = false;
            while (!AsynchronousTextWriter.this.stopRequested || !AsynchronousTextWriter.this.queue.isEmpty()) {
                try {
                    AsynchronousTextWriter.this.queue.drainTo(drainList, 5000);
                    if (drainList.isEmpty()) {
                        String message = (String)AsynchronousTextWriter.this.queue.poll(10L, TimeUnit.SECONDS);
                        if (message == null) continue;
                        AsynchronousTextWriter.this.writeMessage(message);
                        if (!AsynchronousTextWriter.this.autoFlush) continue;
                        AsynchronousTextWriter.this.flush();
                        continue;
                    }
                    for (String message : drainList) {
                        AsynchronousTextWriter.this.writeMessage(message);
                    }
                    drainList.clear();
                    if (!AsynchronousTextWriter.this.autoFlush) continue;
                    AsynchronousTextWriter.this.flush();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

