/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers;

import java.util.Set;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandler;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

public abstract class AuditEventHandlerBase
implements AuditEventHandler {
    private final String name;
    protected final EventTopicsMetaData eventTopicsMetaData;
    private final boolean enabled;

    protected AuditEventHandlerBase(String name, EventTopicsMetaData eventTopicsMetaData, Set<String> acceptedTopics, boolean enabled) {
        this.name = name;
        this.eventTopicsMetaData = eventTopicsMetaData.filter(acceptedTopics);
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getHandledTopics() {
        return this.eventTopicsMetaData.getTopics();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, String topic, ActionRequest request) {
        return new BadRequestException(String.format("Unable to handle action: %s", request.getAction())).asPromise();
    }
}

