/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.handlers.jdbc.BaseDatabaseStatementProvider;
import org.forgerock.audit.handlers.jdbc.JdbcAuditEvent;
import org.forgerock.audit.handlers.jdbc.Parameter;
import org.forgerock.audit.handlers.jdbc.SqlStatementParser;
import org.forgerock.audit.handlers.jdbc.StringSqlQueryFilterVisitor;
import org.forgerock.audit.handlers.jdbc.StringSqlRenderer;
import org.forgerock.audit.handlers.jdbc.TableMapping;
import org.forgerock.audit.handlers.jdbc.TableMappingParametersPair;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.SortKey;
import org.forgerock.util.Utils;
import org.forgerock.util.query.QueryFilterVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OracleDatabaseStatementProvider
extends BaseDatabaseStatementProvider {
    private static final Logger logger = LoggerFactory.getLogger(OracleDatabaseStatementProvider.class);
    private final StringSqlQueryFilterVisitor queryFilterVisitor = new StringSqlQueryFilterVisitor();

    OracleDatabaseStatementProvider() {
    }

    @Override
    public JdbcAuditEvent buildQueryEvent(TableMapping mapping, QueryRequest queryRequest, JsonValue eventTopicMetaData) throws AuditException {
        TableMappingParametersPair tableMappingParametersPair = new TableMappingParametersPair(mapping);
        String querySelectStatement = this.buildQuerySql(queryRequest, tableMappingParametersPair);
        logger.info("Built query select statement: {}", (Object)querySelectStatement);
        SqlStatementParser sqlStatementParser = new SqlStatementParser(querySelectStatement);
        LinkedList<Parameter> params = new LinkedList<Parameter>();
        for (String field : sqlStatementParser.getNamedParameters()) {
            params.add(new Parameter(this.getParameterType(eventTopicMetaData, new JsonPointer(field)), tableMappingParametersPair.getParameters().get(field)));
        }
        return new JdbcAuditEvent(sqlStatementParser.getSqlStatement(), params);
    }

    private String buildQuerySql(QueryRequest queryRequest, TableMappingParametersPair tableMappingParametersPair) {
        int offsetParam = queryRequest.getPagedResultsOffset();
        int pageSizeParam = queryRequest.getPageSize();
        if (pageSizeParam == 0) {
            pageSizeParam = Integer.MAX_VALUE;
        }
        String filterString = ((StringSqlRenderer)queryRequest.getQueryFilter().accept((QueryFilterVisitor)this.queryFilterVisitor, (Object)tableMappingParametersPair)).toSql();
        String keysClause = "ORDER BY id ASC";
        List sortKeys = queryRequest.getSortKeys();
        if (sortKeys != null && sortKeys.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            for (SortKey sortKey : sortKeys) {
                keys.add(tableMappingParametersPair.getColumnName(sortKey.getField()) + (sortKey.isAscendingOrder() ? " ASC" : " DESC"));
            }
            keysClause = "ORDER BY " + Utils.joinAsString((String)", ", keys);
        }
        String tableName = tableMappingParametersPair.getTableMapping().getTable();
        return String.format("SELECT * FROM ( SELECT %s.*, row_number() OVER ( %s ) AS R FROM %s WHERE %s ) WHERE R BETWEEN %d AND %d ORDER BY R", tableName, keysClause, tableName, filterString, offsetParam + 1, offsetParam + pageSizeParam);
    }
}

