/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.syslog;

import java.net.InetSocketAddress;
import javax.inject.Inject;
import org.forgerock.audit.Audit;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandlerBase;
import org.forgerock.audit.handlers.syslog.SyslogAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.syslog.SyslogFormatter;
import org.forgerock.audit.handlers.syslog.SyslogPublisher;
import org.forgerock.audit.handlers.syslog.TransportProtocol;
import org.forgerock.audit.providers.DefaultLocalHostNameProvider;
import org.forgerock.audit.providers.LocalHostNameProvider;
import org.forgerock.audit.providers.ProductInfoProvider;
import org.forgerock.audit.util.ResourceExceptionsUtil;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogAuditEventHandler
extends AuditEventHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(SyslogAuditEventHandler.class);
    private final SyslogPublisher publisher;
    private final SyslogFormatter formatter;

    @Inject
    public SyslogAuditEventHandler(SyslogAuditEventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData, @Audit ProductInfoProvider productInfoProvider, @Audit LocalHostNameProvider localHostNameProvider) {
        super(configuration.getName(), eventTopicsMetaData, configuration.getTopics(), configuration.isEnabled());
        Reject.ifNull((Object)((Object)configuration.getProtocol()), (String)"Syslog transport 'protocol' of TCP or UDP is required");
        Reject.ifNull((Object)configuration.getHost(), (String)"Syslog destination server 'host' is required");
        Reject.ifTrue((configuration.getPort() < 0 || configuration.getPort() > 65535 ? 1 : 0) != 0, (String)"Syslog destination server 'port' between 0 and 65535 is required");
        Reject.ifNull((Object)((Object)configuration.getFacility()), (String)"Syslog 'facility' is required");
        Reject.ifTrue((configuration.getProtocol() == TransportProtocol.TCP && configuration.getConnectTimeout() == 0 ? 1 : 0) != 0, (String)"Syslog 'connectTimeout' is required for TCP connections");
        InetSocketAddress socketAddress = new InetSocketAddress(configuration.getHost(), configuration.getPort());
        this.publisher = configuration.getProtocol().getPublisher(socketAddress, configuration);
        this.formatter = new SyslogFormatter(eventTopicsMetaData, configuration, this.getLocalHostNameProvider(localHostNameProvider), this.getProductNameProvider(productInfoProvider));
        logger.debug("Successfully configured Syslog audit event handler.");
    }

    private ProductInfoProvider getProductNameProvider(ProductInfoProvider productInfoProvider) {
        if (productInfoProvider != null) {
            return productInfoProvider;
        }
        logger.debug("No {} provided; using default.", (Object)ProductInfoProvider.class.getSimpleName());
        return new DefaultProductInfoProvider();
    }

    private LocalHostNameProvider getLocalHostNameProvider(LocalHostNameProvider localHostNameProvider) {
        if (localHostNameProvider != null) {
            return localHostNameProvider;
        }
        logger.debug("No {} provided; using default.", (Object)LocalHostNameProvider.class.getSimpleName());
        return new DefaultLocalHostNameProvider();
    }

    public void startup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        SyslogPublisher syslogPublisher = this.publisher;
        synchronized (syslogPublisher) {
            this.publisher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<ResourceResponse, ResourceException> publishEvent(Context context, String topic, JsonValue event) {
        try {
            String syslogMessage = this.formatAsSyslogMessage(topic, event);
            SyslogPublisher syslogPublisher = this.publisher;
            synchronized (syslogPublisher) {
                this.publisher.publishMessage(syslogMessage);
            }
            return Responses.newResourceResponse((String)event.get("_id").asString(), null, (JsonValue)event.clone()).asPromise();
        }
        catch (Exception ex) {
            return ResourceExceptionsUtil.adapt((Throwable)ex).asPromise();
        }
    }

    private String formatAsSyslogMessage(String topic, JsonValue auditEvent) throws ResourceException {
        if (!this.formatter.canFormat(topic)) {
            throw new InternalServerErrorException("Unable to format " + topic + " audit event");
        }
        try {
            return this.formatter.format(topic, auditEvent);
        }
        catch (Exception ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }

    public Promise<QueryResponse, ResourceException> queryEvents(Context context, String topic, QueryRequest queryRequest, QueryResourceHandler queryResourceHandler) {
        return ResourceExceptionsUtil.notSupported((Request)queryRequest).asPromise();
    }

    public Promise<ResourceResponse, ResourceException> readEvent(Context context, String topic, String resourceId) {
        return new NotSupportedException("query operations are not supported").asPromise();
    }

    private static class DefaultProductInfoProvider
    implements ProductInfoProvider {
        private DefaultProductInfoProvider() {
        }

        public String getProductName() {
            return null;
        }
    }
}

