/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.File;
import java.io.IOException;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.IO;
import org.forgerock.http.io.MemoryBuffer;
import org.forgerock.http.io.OverflowException;

final class TemporaryBuffer
implements Buffer {
    private File file = null;
    private File directory;
    private int fileLimit;
    private Buffer buffer;

    TemporaryBuffer(int initialLength, int memoryLimit, int fileLimit, File directory) {
        this.buffer = IO.newMemoryBuffer(initialLength, memoryLimit);
        this.fileLimit = fileLimit;
        this.directory = directory;
    }

    @Override
    public int read(int pos, byte[] b, int off, int len) throws IOException {
        this.notClosed();
        return this.buffer.read(pos, b, off, len);
    }

    @Override
    public void append(byte[] b, int off, int len) throws IOException {
        this.notClosed();
        try {
            this.buffer.append(b, off, len);
        }
        catch (OverflowException oe) {
            this.promote();
            this.append(b, off, len);
        }
    }

    @Override
    public int length() throws IOException {
        this.notClosed();
        return this.buffer.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            try {
                this.buffer.close();
            }
            finally {
                this.buffer = null;
                if (this.file != null) {
                    this.file.delete();
                }
                this.file = null;
            }
        }
    }

    private void notClosed() throws IOException {
        if (this.buffer == null) {
            throw new IOException("buffer is closed");
        }
    }

    private void promote() throws IOException {
        if (!(this.buffer instanceof MemoryBuffer)) {
            throw new OverflowException();
        }
        MemoryBuffer membuf = (MemoryBuffer)this.buffer;
        this.file = File.createTempFile("buf", null, this.directory);
        this.buffer = IO.newFileBuffer(this.file, this.fileLimit);
        this.buffer.append(membuf.data, 0, membuf.length());
        membuf.close();
    }
}

