/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.handler;

import java.util.List;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

final class Chain
implements Handler {
    private final Handler handler;
    private final List<Filter> filters;
    private final int position;

    Chain(Handler handler, List<Filter> filters, int position) {
        this.handler = handler;
        this.filters = filters;
        this.position = position;
    }

    @Override
    public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
        if (this.position < this.filters.size()) {
            return this.filters.get(this.position).filter(context, request, this.next());
        }
        return this.handler.handle(context, request);
    }

    private Handler next() {
        return new Chain(this.handler, this.filters, this.position + 1);
    }

    public String toString() {
        return this.filters.toString() + " -> " + this.handler.toString();
    }
}

