/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.annotations.Create;
import org.forgerock.json.resource.annotations.Patch;
import org.forgerock.json.resource.annotations.Query;
import org.forgerock.json.resource.annotations.Update;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

final class AnnotatedMethod {
    private final Object requestHandler;
    private final Method method;
    private final int idParameter;
    private final int contextParameter;
    private final int requestParameter;
    private final int queryHandlerParameter;
    private final int numberOfParameters;
    private final String operation;

    AnnotatedMethod(String operation, Object requestHandler, Method method, int idParameter, int contextParameter, int requestParameter, int queryHandlerParameter, int numberOfParameters) {
        this.operation = operation;
        this.requestHandler = requestHandler;
        this.method = method;
        this.idParameter = idParameter;
        this.contextParameter = contextParameter;
        this.requestParameter = requestParameter;
        this.queryHandlerParameter = queryHandlerParameter;
        this.numberOfParameters = numberOfParameters;
    }

    <T> Promise<T, ResourceException> invoke(Context context, Request request, String id) {
        return this.invoke(context, request, null, id);
    }

    <T> Promise<T, ResourceException> invoke(Context context, Request request, QueryResourceHandler queryHandler, String id) {
        if (this.method == null) {
            return new NotSupportedException(this.operation + " not supported").asPromise();
        }
        Object[] args = new Object[this.numberOfParameters];
        if (this.idParameter > -1) {
            args[this.idParameter] = id;
        }
        if (this.requestParameter > -1) {
            args[this.requestParameter] = request;
        }
        if (this.contextParameter > -1) {
            args[this.contextParameter] = context;
        }
        if (this.queryHandlerParameter > -1) {
            args[this.queryHandlerParameter] = queryHandler;
        }
        try {
            return (Promise)this.method.invoke(this.requestHandler, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot access the annotated method: " + this.method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Exception from invocation expected to be handled by promise", e);
        }
    }

    static AnnotatedMethod findMethod(Object requestHandler, Class<? extends Annotation> annotation, boolean needsId) {
        AnnotatedMethod checked;
        for (Method method : requestHandler.getClass().getMethods()) {
            if (method.getAnnotation(annotation) == null || (checked = AnnotatedMethod.checkMethod(annotation, requestHandler, method, needsId)) == null) continue;
            return checked;
        }
        for (Method method : requestHandler.getClass().getMethods()) {
            if (!method.getName().equals(annotation.getSimpleName().toLowerCase()) || (checked = AnnotatedMethod.checkMethod(annotation, requestHandler, method, needsId)) == null) continue;
            return checked;
        }
        return new AnnotatedMethod(annotation.getSimpleName(), null, null, -1, -1, -1, -1, -1);
    }

    static AnnotatedMethod checkMethod(Class<?> annotation, Object requestHandler, Method method, boolean needsId) {
        if (Promise.class.equals(method.getReturnType())) {
            int idParam = -1;
            int contextParam = -1;
            int requestParam = -1;
            int queryHandlerParam = -1;
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<QueryResourceHandler> type = method.getParameterTypes()[i];
                if (String.class.equals(type)) {
                    idParam = i;
                    continue;
                }
                if (Context.class.equals(type)) {
                    contextParam = i;
                    continue;
                }
                if (Request.class.isAssignableFrom(type)) {
                    requestParam = i;
                    continue;
                }
                if (!type.isAssignableFrom(QueryResourceHandler.class)) continue;
                queryHandlerParam = i;
            }
            if (Arrays.asList(Create.class, Update.class, Patch.class, Query.class).contains(annotation) && requestParam == -1) {
                return null;
            }
            if (queryHandlerParam == -1 && Query.class.equals(annotation) || queryHandlerParam != -1 && !Query.class.equals(annotation)) {
                return null;
            }
            if (!needsId || idParam > -1) {
                return new AnnotatedMethod(annotation.getSimpleName(), requestHandler, method, idParam, contextParam, requestParam, queryHandlerParam, method.getParameterTypes().length);
            }
        }
        return null;
    }
}

