/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.ICsvMapReader;

class CsvSecureMapReader
implements ICsvMapReader {
    private static final Logger logger = LoggerFactory.getLogger(CsvSecureMapReader.class);
    private static final String HMAC = "HMAC";
    private static final String SIGNATURE = "SIGNATURE";
    private ICsvMapReader delegate;

    public CsvSecureMapReader(ICsvMapReader delegate) {
        this.delegate = delegate;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public String get(int n) {
        return this.delegate.get(n);
    }

    public Map<String, String> read(String ... nameMapping) throws IOException {
        Map<String, Object> values = this.read(nameMapping, new CellProcessor[nameMapping.length]);
        HashMap<String, String> result = new HashMap<String, String>(values.size());
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            result.put(key, value == null ? null : value.toString());
        }
        return result;
    }

    public String[] getHeader(boolean firstLineCheck) throws IOException {
        String[] header = this.delegate.getHeader(firstLineCheck);
        if (header == null) {
            return null;
        }
        String[] result = new String[header.length - 2];
        System.arraycopy(header, 0, result, 0, result.length);
        return result;
    }

    public Map<String, Object> read(String[] nameMapping, CellProcessor[] processors) throws IOException {
        String[] newNameMapping = this.addExtraColumn(nameMapping);
        CellProcessor[] newProcessors = new CellProcessor[newNameMapping.length];
        System.arraycopy(processors, 0, newProcessors, 0, processors.length);
        newProcessors[processors.length] = null;
        newProcessors[processors.length + 1] = null;
        return this.dropExtraColumns(this.delegate.read(newNameMapping, newProcessors));
    }

    public int getLineNumber() {
        return this.delegate.getLineNumber();
    }

    public String getUntokenizedRow() {
        return this.delegate.getUntokenizedRow();
    }

    public int getRowNumber() {
        return this.delegate.getRowNumber();
    }

    public int length() {
        return this.delegate.length();
    }

    private String[] addExtraColumn(String ... header) {
        String[] newHeader = new String[header.length + 2];
        System.arraycopy(header, 0, newHeader, 0, header.length);
        newHeader[header.length] = HMAC;
        newHeader[header.length + 1] = SIGNATURE;
        return newHeader;
    }

    private <T> Map<String, T> dropExtraColumns(Map<String, T> source) {
        if (source != null) {
            source.remove(HMAC);
            source.remove(SIGNATURE);
        }
        return source;
    }
}

