/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import java.io.File;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.forgerock.audit.handlers.csv.CsvSecureVerifier;
import org.forgerock.audit.retention.FileNamingPolicy;
import org.forgerock.audit.secure.JcaKeyStoreHandler;
import org.forgerock.audit.secure.KeyStoreHandler;
import org.forgerock.audit.secure.KeyStoreSecureStorage;
import org.forgerock.audit.secure.SecureStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.prefs.CsvPreference;

class CsvSecureArchiveVerifier {
    private static final Logger logger = LoggerFactory.getLogger(CsvSecureArchiveVerifier.class);
    private final FileNamingPolicy fileNamingPolicy;
    private final String keystorePassword;
    private final PublicKey publicKey;
    private final CsvPreference csvPreference;

    CsvSecureArchiveVerifier(FileNamingPolicy fileNamingPolicy, String keystorePassword, PublicKey publicKey, CsvPreference csvPreference) {
        this.keystorePassword = keystorePassword;
        this.publicKey = publicKey;
        this.fileNamingPolicy = fileNamingPolicy;
        this.csvPreference = csvPreference;
    }

    List<CsvSecureVerifier.VerificationResult> verify() {
        List archiveFiles = this.fileNamingPolicy.listFiles();
        ArrayList<CsvSecureVerifier.VerificationResult> verificationResults = new ArrayList<CsvSecureVerifier.VerificationResult>(archiveFiles.size());
        for (File archiveFile : archiveFiles) {
            CsvSecureVerifier.VerificationResult verificationResult;
            logger.trace("Verifying file {}", (Object)archiveFile);
            try {
                verificationResult = this.verifyArchiveFile(archiveFile, this.keystorePassword, this.publicKey);
            }
            catch (Exception e) {
                verificationResult = new CsvSecureVerifier.VerificationResult(archiveFile, false, e.getMessage());
            }
            verificationResults.add(verificationResult);
        }
        return verificationResults;
    }

    private CsvSecureVerifier.VerificationResult verifyArchiveFile(File archiveFile, String keystorePassword, PublicKey publicKey) throws Exception {
        SecureStorage secureStorage = this.openSecureStorageForCsvFile(archiveFile, keystorePassword, publicKey);
        CsvSecureVerifier verifier = new CsvSecureVerifier(archiveFile, this.csvPreference, secureStorage);
        return verifier.verify();
    }

    private SecureStorage openSecureStorageForCsvFile(File csvFile, String keystorePassword, PublicKey publicKey) throws Exception {
        String keystorePath = csvFile.getPath() + ".keystore";
        JcaKeyStoreHandler keyStoreHandler = new JcaKeyStoreHandler("JCEKS", keystorePath, keystorePassword);
        return new KeyStoreSecureStorage((KeyStoreHandler)keyStoreHandler, publicKey);
    }
}

