/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.prefs.CsvPreference;

class CsvFormatter {
    private static final Logger logger = LoggerFactory.getLogger(CsvFormatter.class);
    private final CsvPreference csvPreference;

    public CsvFormatter(CsvPreference csvPreference) {
        this.csvPreference = csvPreference;
    }

    public String formatHeader(String[] headers) throws IOException {
        StringBuilderWriter buffer = new StringBuilderWriter();
        CsvMapWriter writer = new CsvMapWriter((Writer)buffer, this.csvPreference, false);
        writer.writeHeader(headers);
        return buffer.takeBufferContents();
    }

    public String formatEvent(Map<String, String> values, String[] headers) throws IOException {
        StringBuilderWriter buffer = new StringBuilderWriter();
        CsvMapWriter writer = new CsvMapWriter((Writer)buffer, this.csvPreference, false);
        writer.write(values, headers);
        String line = buffer.takeBufferContents();
        logger.trace("Formatted event: {}", (Object)line);
        return line;
    }

    private static final class StringBuilderWriter
    extends Writer {
        private final StringBuilder buffer = new StringBuilder();

        private StringBuilderWriter() {
        }

        @Override
        public void write(int c) throws IOException {
            this.buffer.append(c);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.buffer.append(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buffer.append(cbuf, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            this.buffer.append(str);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.buffer.append(str, off, len);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        public String takeBufferContents() {
            String s = this.buffer.toString();
            this.buffer.setLength(0);
            return s;
        }
    }
}

