/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 *      Portions Copyright 2014-2015 ForgeRock AS
 */

package org.opends.guitools.controlpanel.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;

import javax.swing.JTree;
import javax.swing.tree.TreeSelectionModel;

import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.renderer.TreeCellRenderer;
import org.forgerock.i18n.LocalizableMessage;

/**
 * A basic panel containing a CustomTree.
 *
 */
public class TreePanel extends StatusGenericPanel
{
  private static final long serialVersionUID = 5650902943430126109L;
  private JTree tree;

  /**
   * Default constructor.
   *
   */
  public TreePanel()
  {
    super();
    createLayout();
  }

  /**
   * Creates the layout of the panel (but the contents are not populated here).
   *
   */
  private void createLayout()
  {
    GridBagConstraints gbc = new GridBagConstraints();
    gbc.fill = GridBagConstraints.BOTH;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;

    tree = new CustomTree();
    tree.getSelectionModel().setSelectionMode(
        TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
    tree.setBackground(ColorAndFontConstants.background);
    tree.setCellRenderer(new TreeCellRenderer());
    tree.setShowsRootHandles(true);
    tree.setScrollsOnExpand(false);
    add(tree, gbc);
  }

  /**
   * Returns the tree contained in the panel.
   * @return the tree contained in the panel.
   */
  public JTree getTree()
  {
    return tree;
  }

  /** {@inheritDoc} */
  public void okClicked()
  {
    // No ok button
  }

  /** {@inheritDoc} */
  public GenericDialog.ButtonType getButtonType()
  {
    return GenericDialog.ButtonType.NO_BUTTON;
  }

  /** {@inheritDoc} */
  public LocalizableMessage getTitle()
  {
    return null;
  }

  /** {@inheritDoc} */
  public Component getPreferredFocusComponent()
  {
    return tree;
  }

  /** {@inheritDoc} */
  public void configurationChanged(ConfigurationChangeEvent ev)
  {
  }
}
