/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.AbstractConnectionWrapper;
import org.forgerock.json.resource.AnnotatedCollectionHandler;
import org.forgerock.json.resource.AnnotatedSingletonHandler;
import org.forgerock.json.resource.AnnotationCollectionInstance;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.InterfaceCollectionHandler;
import org.forgerock.json.resource.InterfaceCollectionInstance;
import org.forgerock.json.resource.InterfaceSingletonHandler;
import org.forgerock.json.resource.InternalConnection;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.RouteMatchers;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.SynchronousRequestHandler;
import org.forgerock.json.resource.SynchronousRequestHandlerAdapter;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class Resources {
    public static RequestHandler asRequestHandler(SynchronousRequestHandler syncHandler) {
        return new SynchronousRequestHandlerAdapter(syncHandler);
    }

    public static JsonValue filterResource(JsonValue resource, Collection<JsonPointer> fields) {
        if (fields.isEmpty() || resource.isNull() || resource.size() == 0) {
            return resource;
        }
        LinkedHashMap<String, Object> filtered = new LinkedHashMap<String, Object>(fields.size());
        for (JsonPointer field : fields) {
            if (field.isEmpty()) {
                filtered.putAll(resource.asMap());
                continue;
            }
            JsonValue value = resource.get(field);
            if (value == null) continue;
            String key = field.leaf();
            filtered.put(key, value.getObject());
        }
        return new JsonValue(filtered);
    }

    public static ResourceResponse filterResource(ResourceResponse resource, Collection<JsonPointer> fields) {
        Collection<JsonPointer> filterFields;
        JsonValue unfiltered = resource.getContent();
        JsonValue filtered = Resources.filterResource(unfiltered, filterFields = resource.hasFields() ? resource.getFields() : fields);
        if (filtered == unfiltered) {
            return resource;
        }
        return Responses.newResourceResponse(resource.getId(), resource.getRevision(), filtered);
    }

    public static RequestHandler newCollection(Object provider) {
        boolean fromInterface = provider instanceof CollectionResourceProvider;
        Router router = new Router();
        InterfaceCollectionHandler collectionHandler = fromInterface ? new InterfaceCollectionHandler((CollectionResourceProvider)provider) : new AnnotatedCollectionHandler(provider);
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, ""), collectionHandler);
        InterfaceCollectionInstance instanceHandler = fromInterface ? new InterfaceCollectionInstance((CollectionResourceProvider)provider) : new AnnotationCollectionInstance(provider);
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, "{id}"), instanceHandler);
        return router;
    }

    public static Connection newInternalConnection(RequestHandler handler) {
        return new InternalConnection(handler);
    }

    public static ConnectionFactory newInternalConnectionFactory(RequestHandler handler) {
        return new InternalConnectionFactory(handler);
    }

    public static RequestHandler newSingleton(Object provider) {
        if (provider instanceof SingletonResourceProvider) {
            return new InterfaceSingletonHandler((SingletonResourceProvider)provider);
        }
        return new AnnotatedSingletonHandler(provider);
    }

    public static Connection uncloseable(Connection connection) {
        return new AbstractConnectionWrapper<Connection>(connection){

            @Override
            public void close() {
            }
        };
    }

    public static ConnectionFactory uncloseable(final ConnectionFactory factory) {
        return new ConnectionFactory(){

            @Override
            public Promise<Connection, ResourceException> getConnectionAsync() {
                return factory.getConnectionAsync();
            }

            @Override
            public Connection getConnection() throws ResourceException {
                return factory.getConnection();
            }

            @Override
            public void close() {
            }
        };
    }

    static String idOf(Context context) {
        return (String)((UriRouterContext)context.asContext(UriRouterContext.class)).getUriTemplateVariables().get("id");
    }

    static ResourceException newBadRequestException(String fs, Object ... args) {
        String msg = String.format(fs, args);
        return new BadRequestException(msg);
    }

    private static <V> Promise<V, ResourceException> newSuccessfulPromise(V result) {
        return Promises.newResultPromise(result);
    }

    static Context parentOf(Context context) {
        assert (context instanceof UriRouterContext);
        return context.getParent();
    }

    private Resources() {
    }

    private static final class InternalConnectionFactory
    implements ConnectionFactory {
        private final RequestHandler handler;

        private InternalConnectionFactory(RequestHandler handler) {
            this.handler = handler;
        }

        @Override
        public void close() {
        }

        @Override
        public Connection getConnection() {
            return Resources.newInternalConnection(this.handler);
        }

        @Override
        public Promise<Connection, ResourceException> getConnectionAsync() {
            return Resources.newSuccessfulPromise(this.getConnection());
        }
    }
}

