/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.statcap;

import com.sleepycat.je.CustomStats;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.statcap.JvmStats;
import com.sleepycat.je.statcap.StatManager;
import com.sleepycat.je.statcap.StatUtils;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StringStat;
import com.sleepycat.utilint.StatLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatCapture
extends DaemonThread
implements EnvConfigObserver {
    private EnvironmentImpl env;
    private final StatsConfig clearingFastConfig;
    private StatLogger stlog = null;
    public static final String STATFILENAME = "je.stat";
    public static final String STATFILEEXT = "csv";
    private static final String CUSTOMGROUPNAME = "Custom";
    private static final String DELIMITER = ",";
    private static final String DELIMITERANDSPACE = ", ";
    private final StringBuffer values = new StringBuffer();
    private String currentHeader = null;
    private Integer statKey = null;
    private final SortedSet<String> statProjection;
    private final JvmStats jvmstats = new JvmStats();
    private final CustomStats customStats;
    private String[] customStatHeader = null;
    private boolean collectStats;
    private final Logger logger = LoggerUtils.getLogger(this.getClass());
    private StatManager statMgr;
    private Exception lastCallException = null;

    public StatCapture(EnvironmentImpl environment, String name, long waitTime, CustomStats customStats, SortedSet<String> statProjection, StatManager statMgr) {
        super(waitTime, name, environment);
        environment.addConfigObserver(this);
        this.env = environment;
        this.statMgr = statMgr;
        this.statKey = statMgr.registerStatContext();
        this.clearingFastConfig = new StatsConfig();
        this.clearingFastConfig.setFast(true);
        this.clearingFastConfig.setClear(true);
        this.customStats = customStats;
        this.statProjection = statProjection;
        String statdir = this.env.getConfigManager().get(EnvironmentParams.STATS_FILE_DIRECTORY);
        this.collectStats = this.env.getConfigManager().getBoolean(EnvironmentParams.STATS_COLLECT);
        File statdirf = statdir == null || statdir.equals("") ? this.env.getEnvironmentHome() : new File(statdir);
        try {
            this.stlog = new StatLogger(statdirf, STATFILENAME, STATFILEEXT, this.env.getConfigManager().getInt(EnvironmentParams.STATS_MAX_FILES), this.env.getConfigManager().getInt(EnvironmentParams.STATS_FILE_ROW_COUNT));
        }
        catch (IOException e) {
            throw new IllegalStateException(" Error accessing statistics capture file je.stat.csv IO Exception: " + e.getMessage());
        }
        this.jvmstats.addVMStatDefs(statProjection);
        if (customStats != null) {
            String[] customFldNames = customStats.getFieldNames();
            this.customStatHeader = new String[customFldNames.length];
            for (int i = 0; i < customFldNames.length; ++i) {
                this.customStatHeader[i] = "Custom:" + customFldNames[i];
                statProjection.add(this.customStatHeader[i]);
            }
        }
    }

    public synchronized void clearEnv() {
        if (this.statKey != null && this.statMgr != null) {
            this.statMgr.unregisterStatContext(this.statKey);
            this.statKey = null;
        }
        this.statMgr = null;
        if (this.env != null) {
            this.env.removeConfigObserver(this);
        }
        this.env = null;
    }

    @Override
    protected void onWakeup() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        if (!this.collectStats || this.env.isInvalid()) {
            return;
        }
        this.outputStats();
    }

    @Override
    public void requestShutdown() {
        super.requestShutdown();
        if (!this.collectStats || this.env.isInvalid()) {
            return;
        }
        this.outputStats();
    }

    private synchronized void outputStats() {
        if (!this.collectStats || this.env.isInvalid()) {
            return;
        }
        try {
            SortedMap<String, String> stats = this.getStats();
            if (stats != null) {
                if (this.currentHeader == null) {
                    this.values.setLength(0);
                    this.values.append("time");
                    for (String statname : this.statProjection) {
                        this.values.append(DELIMITER + statname);
                    }
                    this.stlog.setHeader(this.values.toString());
                    this.currentHeader = this.values.toString();
                }
                this.values.setLength(0);
                this.values.append(StatUtils.getDate(System.currentTimeMillis()));
                for (String statname : this.statProjection) {
                    String val = (String)stats.get(statname);
                    if (val != null) {
                        this.values.append(DELIMITER + val);
                        continue;
                    }
                    this.values.append(DELIMITERANDSPACE);
                }
                this.stlog.log(this.values.toString());
                this.values.setLength(0);
                this.lastCallException = null;
            }
        }
        catch (IOException e) {
            if (this.lastCallException == null) {
                LoggerUtils.warning(this.logger, this.env, "Error accessing statistics capture file je.stat.csv IO Exception: " + e.getMessage());
            }
            this.lastCallException = e;
        }
    }

    private SortedMap<String, String> getStats() {
        Collection<StatGroup> rsg;
        ArrayList<StatGroup> envStats = new ArrayList<StatGroup>(this.statMgr.loadStats(this.clearingFastConfig, this.statKey).getStatGroups());
        if (this.env.isReplicated() && (rsg = this.env.getRepStatGroups(this.clearingFastConfig, this.statKey)) != null) {
            envStats.addAll(rsg);
        }
        envStats.add(this.jvmstats.loadStats(this.clearingFastConfig));
        TreeMap<String, String> statsMap = new TreeMap<String, String>();
        for (StatGroup sg : envStats) {
            for (Map.Entry<StatDefinition, Stat<?>> e : sg.getStats().entrySet()) {
                String mapName = (sg.getName() + ":" + e.getKey().getName()).intern();
                Object val = e.getValue().get();
                if (val instanceof Number) {
                    statsMap.put(mapName, Long.toString(((Number)val).longValue()));
                    continue;
                }
                if (!(e.getValue() instanceof StringStat)) continue;
                if (val != null) {
                    statsMap.put(mapName, (String)val);
                    continue;
                }
                statsMap.put(mapName, " ");
            }
        }
        if (this.customStats != null) {
            String[] vals = this.customStats.getFieldValues();
            for (int i = 0; i < vals.length; ++i) {
                statsMap.put(this.customStatHeader[i], vals[i]);
            }
        }
        return statsMap;
    }

    @Override
    public void envConfigUpdate(DbConfigManager configMgr, EnvironmentMutableConfig newConfig) throws DatabaseException {
        this.stlog.setFileCount(configMgr.getInt(EnvironmentParams.STATS_MAX_FILES));
        this.stlog.setRowCount(configMgr.getInt(EnvironmentParams.STATS_FILE_ROW_COUNT));
        this.setWaitTime(configMgr.getDuration(EnvironmentParams.STATS_COLLECT_INTERVAL));
        this.collectStats = configMgr.getBoolean(EnvironmentParams.STATS_COLLECT);
    }
}

