/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.MapEntryParameter;
import com.sleepycat.collections.StoredCollection;

final class StoredMapEntry
extends MapEntryParameter {
    private BaseIterator iter;
    private StoredCollection coll;

    StoredMapEntry(Object key, Object value, StoredCollection coll, BaseIterator iter) {
        super(key, value);
        this.coll = coll;
        this.iter = iter;
    }

    public Object setValue(Object newValue) {
        Object oldValue;
        if (this.iter != null && this.iter.isCurrentData(this)) {
            oldValue = this.getValue();
            this.iter.set(newValue);
        } else {
            if (this.coll.view.dupsAllowed) {
                throw new IllegalStateException("May not insert duplicates");
            }
            oldValue = this.coll.putKeyValue(this.getKey(), newValue);
        }
        this.setValueInternal(newValue);
        return oldValue;
    }
}

