/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.StatsConfig;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.util.StaticUtils;

final class JEMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final String name;
    private final Environment env;

    JEMonitor(String name, Environment env) {
        this.name = name;
        this.env = env;
    }

    public String getMonitorInstanceName() {
        return this.name;
    }

    public List<Attribute> getMonitorData() {
        try {
            ArrayList<Attribute> monitorAttrs = new ArrayList<Attribute>();
            monitorAttrs.add(Attributes.create((String)"JEVersion", (String)JEVersion.CURRENT_VERSION.getVersionString()));
            StatsConfig statsConfig = new StatsConfig();
            this.addAttributesForStatsObject(monitorAttrs, "Environment", this.env.getStats(statsConfig));
            this.addAttributesForStatsObject(monitorAttrs, "Transaction", this.env.getTransactionStats(statsConfig));
            return monitorAttrs;
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
            return Collections.singletonList(Attributes.create((String)"JEInfo", (String)StaticUtils.stackTraceToSingleLineString((Throwable)e)));
        }
    }

    private void addAttributesForStatsObject(List<Attribute> monitorAttrs, String attrPrefix, Object stats) {
        for (Method method : stats.getClass().getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (!method.getName().startsWith("get") || !returnType.equals(Integer.TYPE) && !returnType.equals(Long.TYPE)) continue;
            this.addStatAttribute(monitorAttrs, attrPrefix, stats, method);
        }
    }

    private void addStatAttribute(List<Attribute> monitorAttrs, String attrPrefix, Object stats, Method method) {
        Syntax integerSyntax = DirectoryServer.getDefaultIntegerSyntax();
        try {
            String attrName = attrPrefix + method.getName().substring(3);
            AttributeType attrType = DirectoryServer.getAttributeTypeOrDefault((String)attrName, (String)attrName, (Syntax)integerSyntax);
            monitorAttrs.add(Attributes.create((AttributeType)attrType, (String)String.valueOf(method.invoke(stats, new Object[0]))));
        }
        catch (Exception e) {
            logger.traceException((Throwable)e);
        }
    }
}

