/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SqlStatementParser {
    private String sqlStatement;
    private final List<String> namedParameters = new LinkedList<String>();
    private static final Pattern pattern = Pattern.compile("\\$\\{([a-zA-Z0-9/_]+)\\}");

    public SqlStatementParser(String sql) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher m = pattern.matcher(sql);
        while (m.find()) {
            String parameter = m.group(1);
            m.appendReplacement(stringBuffer, "?");
            this.namedParameters.add(parameter);
        }
        m.appendTail(stringBuffer);
        this.sqlStatement = stringBuffer.toString();
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public List<String> getNamedParameters() {
        return this.namedParameters;
    }
}

