/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.jdbc;

import java.util.List;
import org.forgerock.audit.handlers.jdbc.SqlRenderer;
import org.forgerock.json.JsonPointer;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

abstract class AbstractSqlQueryFilterVisitor<R extends SqlRenderer<?>, P>
implements QueryFilterVisitor<R, P, JsonPointer> {
    AbstractSqlQueryFilterVisitor() {
    }

    public abstract R visitValueAssertion(P var1, String var2, JsonPointer var3, Object var4);

    public abstract R visitPresentFilter(P var1, JsonPointer var2);

    public abstract R visitBooleanLiteralFilter(P var1, boolean var2);

    public abstract R visitNotFilter(P var1, QueryFilter<JsonPointer> var2);

    public abstract R visitAndFilter(P var1, List<QueryFilter<JsonPointer>> var2);

    public abstract R visitOrFilter(P var1, List<QueryFilter<JsonPointer>> var2);

    public R visitContainsFilter(P parameters, JsonPointer field, Object valueAssertion) {
        return this.visitValueAssertion(parameters, "LIKE", field, "%" + valueAssertion + "%");
    }

    public R visitEqualsFilter(P parameters, JsonPointer field, Object valueAssertion) {
        return this.visitValueAssertion(parameters, "=", field, valueAssertion);
    }

    public R visitExtendedMatchFilter(P parameters, JsonPointer field, String operator, Object valueAssertion) {
        throw new UnsupportedOperationException("Extended match filter not supported on this endpoint");
    }

    public R visitGreaterThanFilter(P parameters, JsonPointer field, Object valueAssertion) {
        return this.visitValueAssertion(parameters, ">", field, valueAssertion);
    }

    public R visitGreaterThanOrEqualToFilter(P parameters, JsonPointer field, Object valueAssertion) {
        return this.visitValueAssertion(parameters, ">=", field, valueAssertion);
    }

    public R visitLessThanFilter(P parameters, JsonPointer field, Object valueAssertion) {
        return this.visitValueAssertion(parameters, "<", field, valueAssertion);
    }

    public R visitLessThanOrEqualToFilter(P parameters, JsonPointer field, Object valueAssertion) {
        return this.visitValueAssertion(parameters, "<=", field, valueAssertion);
    }

    public R visitStartsWithFilter(P parameters, JsonPointer field, Object valueAssertion) {
        return this.visitValueAssertion(parameters, "LIKE", field, valueAssertion + "%");
    }
}

