/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.retention;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.audit.retention.FileNamingPolicy;
import org.forgerock.audit.retention.RetentionPolicy;

public class SizeBasedRetentionPolicy
implements RetentionPolicy {
    private final int maxNumberOfFiles;

    public SizeBasedRetentionPolicy(int maxNumberOfFiles) {
        this.maxNumberOfFiles = maxNumberOfFiles;
    }

    @Override
    public List<File> deleteFiles(FileNamingPolicy fileNamingPolicy) {
        List<File> managedArchivedFiles = fileNamingPolicy.listFiles();
        int numberOfManagedArchiveFiles = managedArchivedFiles.size();
        if (this.maxNumberOfFiles <= 0 || numberOfManagedArchiveFiles <= this.maxNumberOfFiles) {
            return Collections.emptyList();
        }
        LinkedList<File> filesToDelete = new LinkedList<File>(managedArchivedFiles.subList(0, numberOfManagedArchiveFiles - this.maxNumberOfFiles));
        return filesToDelete;
    }
}

