/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.filter;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.filter.Filter;
import org.forgerock.audit.filter.FilterPolicy;
import org.forgerock.audit.filter.Filters;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Reject;

public class FilterChainBuilder {
    private Map<String, FilterPolicy> policies;
    private List<String> auditTopics;

    public FilterChainBuilder withAuditTopics(Collection<String> auditTopics) {
        Reject.ifNull(auditTopics);
        this.auditTopics = new LinkedList<String>(auditTopics);
        return this;
    }

    public FilterChainBuilder withPolicies(Map<String, FilterPolicy> policies) {
        Reject.ifNull(policies);
        this.policies = new LinkedHashMap<String, FilterPolicy>(policies);
        return this;
    }

    public Filter build() {
        LinkedList<Filter> filters = new LinkedList<Filter>();
        if (this.policies != null && this.auditTopics != null) {
            for (Map.Entry<String, FilterPolicy> policyEntry : this.policies.entrySet()) {
                try {
                    filters.add(Filters.newFilter(policyEntry.getKey(), this.auditTopics, policyEntry.getValue()));
                }
                catch (AuditException e) {}
            }
        }
        return new FilterChain(filters);
    }

    public static class FilterChain
    implements Filter {
        private final List<Filter> filters;

        FilterChain(List<Filter> filters) {
            this.filters = new LinkedList<Filter>(filters);
        }

        @Override
        public void doFilter(String auditTopic, JsonValue auditEvent) {
            for (Filter filter : this.filters) {
                filter.doFilter(auditTopic, auditEvent);
            }
        }
    }
}

