/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers.writers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.forgerock.audit.events.handlers.writers.MeteredStream;

public interface TextWriter {
    public void write(String var1) throws IOException;

    public void flush() throws IOException;

    public void shutdown();

    public long getBytesWritten();

    public static class Stream
    implements TextWriter {
        private final MeteredStream stream;
        private final PrintWriter writer;

        public Stream(OutputStream outputStream) {
            this.stream = new MeteredStream(outputStream, 0L);
            this.writer = new PrintWriter(this.stream, true);
        }

        @Override
        public void write(String text) {
            this.writer.print(text);
        }

        @Override
        public void flush() {
            this.writer.flush();
        }

        @Override
        public void shutdown() {
            this.writer.close();
        }

        @Override
        public long getBytesWritten() {
            return this.stream.getBytesWritten();
        }
    }
}

