/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventTopicsMetaData {
    private static final Logger logger = LoggerFactory.getLogger(EventTopicsMetaData.class);
    private final Map<String, JsonValue> eventTopicsMetaData;

    public EventTopicsMetaData(Map<String, JsonValue> eventTopicsMetaData) {
        this.eventTopicsMetaData = eventTopicsMetaData;
    }

    public boolean containsTopic(String topic) {
        return this.eventTopicsMetaData.containsKey(topic);
    }

    public JsonValue getSchema(String topic) {
        return this.eventTopicsMetaData.get(topic);
    }

    public Set<String> getTopics() {
        return this.eventTopicsMetaData.keySet();
    }

    public EventTopicsMetaData filter(Set<String> topics) {
        HashMap<String, JsonValue> filteredTopicSchemas = new HashMap<String, JsonValue>();
        for (String topic : topics) {
            if (!this.containsTopic(topic)) {
                logger.error("unknown audit event topic : {}", (Object)topic);
                continue;
            }
            filteredTopicSchemas.put(topic, this.getSchema(topic));
        }
        return new EventTopicsMetaData(filteredTopicSchemas);
    }
}

