/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.forgerock.http.header.ContentApiVersionHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Status;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.routing.Version;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.AdviceContext;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestVisitor;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourcePath;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Response;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.json.resource.http.HttpUtils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Utils;
import org.forgerock.util.encode.Base64url;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

final class RequestRunner
implements RequestVisitor<Promise<org.forgerock.http.protocol.Response, NeverThrowsException>, Void> {
    private Connection connection = null;
    private final Context context;
    private final org.forgerock.http.protocol.Request httpRequest;
    private final org.forgerock.http.protocol.Response httpResponse;
    private final Version protocolVersion;
    private final Request request;
    private final JsonGenerator writer;

    RequestRunner(Context context, Request request, org.forgerock.http.protocol.Request httpRequest, org.forgerock.http.protocol.Response httpResponse) throws Exception {
        this.context = context;
        this.request = request;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.protocolVersion = HttpUtils.getRequestedProtocolVersion(httpRequest);
        this.writer = HttpUtils.getJsonGenerator(httpRequest, httpResponse);
    }

    private boolean isUpsertSupported(CreateRequest request) {
        return this.protocolVersion.getMajor() >= 2 && HttpUtils.getIfNoneMatch(this.httpRequest) == null && request.getNewResourceId() != null;
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> handleError(ResourceException error) {
        this.onError((Exception)((Object)error));
        this.writeApiVersionHeaders((Response)error);
        this.writeAdvice();
        return HttpUtils.fail(this.httpRequest, this.httpResponse, error);
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> handleResult(Connection result) {
        this.connection = result;
        return (Promise)this.request.accept((RequestVisitor)this, null);
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitActionRequest(Void p, ActionRequest request) {
        return this.connection.actionAsync(this.context, request).thenAsync((AsyncFunction)new AsyncFunction<ActionResponse, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ActionResponse result) {
                try {
                    RequestRunner.this.writeApiVersionHeaders((Response)result);
                    RequestRunner.this.writeAdvice();
                    if (result != null) {
                        RequestRunner.this.writer.writeObject(result.getJsonContent().getObject());
                    } else {
                        RequestRunner.this.httpResponse.setStatus(Status.NO_CONTENT);
                    }
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
                return Promises.newResultPromise((Object)RequestRunner.this.httpResponse);
            }
        }, (AsyncFunction)new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitCreateRequest(final Void p, final CreateRequest request) {
        return this.connection.createAsync(this.context, request).thenAsync((AsyncFunction)new AsyncFunction<ResourceResponse, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceResponse result) {
                try {
                    RequestRunner.this.writeApiVersionHeaders((Response)result);
                    RequestRunner.this.writeAdvice();
                    if (result.getId() != null) {
                        RequestRunner.this.httpResponse.getHeaders().put("Location", (Object)RequestRunner.this.getResourceURL(request, result));
                    }
                    RequestRunner.this.httpResponse.setStatus(Status.CREATED);
                    RequestRunner.this.writeResource(result);
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
                return Promises.newResultPromise((Object)RequestRunner.this.httpResponse);
            }
        }, (AsyncFunction)new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException resourceException) {
                try {
                    if (resourceException instanceof PreconditionFailedException && RequestRunner.this.isUpsertSupported(request)) {
                        return RequestRunner.this.visitUpdateRequest(p, Requests.newUpdateRequest((ResourcePath)request.getResourcePathObject().child((Object)request.getNewResourceId()), (JsonValue)request.getContent()));
                    }
                    return RequestRunner.this.handleError(resourceException);
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                    return Promises.newResultPromise((Object)RequestRunner.this.httpResponse);
                }
            }
        });
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitDeleteRequest(Void p, DeleteRequest request) {
        return this.connection.deleteAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), (AsyncFunction)new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitPatchRequest(Void p, PatchRequest request) {
        return this.connection.patchAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), (AsyncFunction)new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitQueryRequest(Void p, QueryRequest request) {
        final AtomicBoolean isFirstResult = new AtomicBoolean(true);
        final AtomicInteger resultCount = new AtomicInteger(0);
        return this.connection.queryAsync(this.context, request, new QueryResourceHandler(){

            public boolean handleResource(ResourceResponse resource) {
                try {
                    RequestRunner.this.writeHeader((Response)resource, isFirstResult);
                    RequestRunner.this.writeResourceJsonContent(resource);
                    resultCount.incrementAndGet();
                    return true;
                }
                catch (Exception e) {
                    RequestRunner.this.handleError(HttpUtils.adapt(e));
                    return false;
                }
            }
        }).thenOnResult((ResultHandler)new ResultHandler<QueryResponse>(){

            public void handleResult(QueryResponse result) {
                try {
                    RequestRunner.this.writeHeader((Response)result, isFirstResult);
                    RequestRunner.this.writer.writeEndArray();
                    RequestRunner.this.writer.writeNumberField("resultCount", resultCount.get());
                    RequestRunner.this.writer.writeStringField("pagedResultsCookie", result.getPagedResultsCookie());
                    RequestRunner.this.writer.writeStringField("totalPagedResultsPolicy", result.getTotalPagedResultsPolicy().toString());
                    RequestRunner.this.writer.writeNumberField("totalPagedResults", result.getTotalPagedResults());
                    RequestRunner.this.writer.writeNumberField("remainingPagedResults", result.getRemainingPagedResults());
                    RequestRunner.this.writer.writeEndObject();
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
            }
        }).thenOnException((ExceptionHandler)new ExceptionHandler<ResourceException>(){

            public void handleException(ResourceException error) {
                if (isFirstResult.get()) {
                    RequestRunner.this.onError((Exception)((Object)error));
                } else {
                    try {
                        RequestRunner.this.writer.writeEndArray();
                        RequestRunner.this.writer.writeNumberField("resultCount", resultCount.get());
                        RequestRunner.this.writer.writeObjectField("error", error.toJsonValue().getObject());
                        RequestRunner.this.writer.writeEndObject();
                        RequestRunner.this.onSuccess();
                    }
                    catch (Exception e) {
                        RequestRunner.this.onError(e);
                    }
                }
            }
        }).thenAsync((AsyncFunction)new AsyncFunction<QueryResponse, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(QueryResponse queryResponse) {
                return Promises.newResultPromise((Object)RequestRunner.this.httpResponse);
            }
        }, (AsyncFunction)new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    private void writeHeader(Response response, AtomicBoolean isFirstResult) throws IOException {
        if (isFirstResult.compareAndSet(true, false)) {
            this.writeApiVersionHeaders(response);
            this.writeAdvice();
            this.writer.writeStartObject();
            this.writer.writeArrayFieldStart("result");
        }
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitReadRequest(Void p, ReadRequest request) {
        return this.connection.readAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), (AsyncFunction)new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    public final Promise<org.forgerock.http.protocol.Response, NeverThrowsException> visitUpdateRequest(Void p, UpdateRequest request) {
        return this.connection.updateAsync(this.context, request).thenAsync(this.newResourceSuccessHandler(), (AsyncFunction)new AsyncFunction<ResourceException, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceException e) {
                return RequestRunner.this.handleError(e);
            }
        });
    }

    private void onSuccess() {
        Utils.closeSilently((Closeable[])new Closeable[]{this.connection, this.writer});
    }

    private void onError(Exception e) {
        Utils.closeSilently((Closeable[])new Closeable[]{this.connection});
    }

    private String getResourceURL(CreateRequest request, ResourceResponse resource) {
        StringBuilder builder = new StringBuilder().append(this.httpRequest.getUri().getScheme()).append("://").append(this.httpRequest.getUri().getRawAuthority());
        builder.append(((UriRouterContext)this.context.asContext(UriRouterContext.class)).getMatchedUri());
        ResourcePath resourcePath = request.getResourcePathObject();
        if (!resourcePath.isEmpty()) {
            builder.append('/');
            builder.append(resourcePath);
        }
        builder.append('/');
        builder.append(resource.getId());
        return builder.toString();
    }

    private AsyncFunction<ResourceResponse, org.forgerock.http.protocol.Response, NeverThrowsException> newResourceSuccessHandler() {
        return new AsyncFunction<ResourceResponse, org.forgerock.http.protocol.Response, NeverThrowsException>(){

            public Promise<org.forgerock.http.protocol.Response, NeverThrowsException> apply(ResourceResponse result) {
                try {
                    String rev;
                    RequestRunner.this.writeApiVersionHeaders((Response)result);
                    RequestRunner.this.writeAdvice();
                    if (RequestRunner.this.request instanceof ReadRequest && (rev = HttpUtils.getIfNoneMatch(RequestRunner.this.httpRequest)) != null && rev.equals(result.getRevision())) {
                        Map responseBody = ResourceException.newResourceException((int)304).setReason("Not Modified").toJsonValue().asMap();
                        return Promises.newResultPromise((Object)new org.forgerock.http.protocol.Response().setStatus(Status.valueOf((int)304)).setEntity((Object)responseBody));
                    }
                    RequestRunner.this.writeResource(result);
                    RequestRunner.this.onSuccess();
                }
                catch (Exception e) {
                    RequestRunner.this.onError(e);
                }
                return Promises.newResultPromise((Object)RequestRunner.this.httpResponse);
            }
        };
    }

    private void writeTextValue(JsonValue json) throws IOException {
        if (json.isMap() && !json.asMap().isEmpty()) {
            this.writeToResponse(json.asMap().entrySet().iterator().next().getValue().toString().getBytes());
        } else if (json.isList() && !json.asList().isEmpty()) {
            this.writeToResponse(((String)json.asList(String.class).iterator().next()).getBytes());
        } else if (json.isString()) {
            this.writeToResponse(json.asString().getBytes());
        } else if (json.isBoolean()) {
            this.writeToResponse(json.asBoolean().toString().getBytes());
        } else if (json.isNumber()) {
            this.writeToResponse(json.asNumber().toString().getBytes());
        } else {
            throw new IOException("Content is unknown type or is empty");
        }
    }

    private void writeBinaryValue(JsonValue json) throws IOException {
        if (json.isMap() && !json.asMap().isEmpty()) {
            this.writeToResponse(Base64url.decode((String)json.asMap().entrySet().iterator().next().getValue().toString()));
        } else if (json.isList() && !json.asList().isEmpty()) {
            this.writeToResponse(Base64url.decode((String)((String)json.asList(String.class).iterator().next())));
        } else if (json.isString()) {
            this.writeToResponse(Base64url.decode((String)json.asString()));
        } else {
            throw new IOException("Content is not an accepted type or is empty");
        }
    }

    private void writeToResponse(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            throw new IOException("Content is empty or corrupt");
        }
        this.httpResponse.setEntity((Object)data);
    }

    private void writeResource(ResourceResponse resource) throws IOException, ParseException {
        ContentType contentType;
        if (resource.getRevision() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append('\"');
            builder.append(resource.getRevision());
            builder.append('\"');
            this.httpResponse.getHeaders().put("ETag", (Object)builder.toString());
        }
        if ((contentType = new ContentType(this.httpResponse.getHeaders().getFirst(ContentTypeHeader.class))).match("application/json")) {
            this.writeResourceJsonContent(resource);
        } else if (contentType.match("text/plain")) {
            this.writeTextValue(resource.getContent());
        } else {
            this.writeBinaryValue(resource.getContent());
        }
    }

    private void writeResourceJsonContent(ResourceResponse resource) throws IOException {
        if (HttpUtils.getRequestedProtocolVersion(this.httpRequest).getMajor() >= HttpUtils.PROTOCOL_VERSION_2.getMajor()) {
            this.writer.writeStartObject();
            JsonValue content = resource.getContent();
            if (resource.getId() != null) {
                this.writer.writeObjectField("_id", (Object)resource.getId());
            } else {
                Object id = content.get("_id").getObject();
                if (id != null) {
                    this.writer.writeObjectField("_id", (Object)id.toString());
                }
            }
            if (resource.getRevision() != null) {
                this.writer.writeObjectField("_rev", (Object)resource.getRevision());
            } else {
                Object rev = content.get("_rev").getObject();
                if (rev != null) {
                    this.writer.writeObjectField("_rev", (Object)rev.toString());
                }
            }
            for (Map.Entry property : content.asMap().entrySet()) {
                String key = (String)property.getKey();
                if ("_id".equals(key) || "_rev".equals(key)) continue;
                this.writer.writeObjectField(key, property.getValue());
            }
            this.writer.writeEndObject();
        } else {
            this.writer.writeObject(resource.getContent().getObject());
        }
    }

    private void writeApiVersionHeaders(Response response) {
        if (response.getResourceApiVersion() != null) {
            this.httpResponse.getHeaders().put((Header)new ContentApiVersionHeader(this.protocolVersion, response.getResourceApiVersion()));
        }
    }

    private void writeAdvice() {
        if (this.context.containsContext(AdviceContext.class)) {
            AdviceContext adviceContext = (AdviceContext)this.context.asContext(AdviceContext.class);
            for (Map.Entry entry : adviceContext.getAdvices().entrySet()) {
                this.httpResponse.getHeaders().put((String)entry.getKey(), entry.getValue());
            }
        }
    }
}

