/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.http;

import java.net.URI;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.filter.Filters;
import org.forgerock.http.handler.Handlers;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.http.CrestAdapter;
import org.forgerock.json.resource.http.HttpAdapter;
import org.forgerock.json.resource.http.HttpContextFactory;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;

public final class CrestHttp {
    private CrestHttp() {
    }

    public static Handler newHttpHandler(ConnectionFactory connectionFactory) {
        Reject.ifNull((Object)connectionFactory);
        return Handlers.chainOf((Handler)new HttpAdapter(connectionFactory), (Filter[])new Filter[]{CrestHttp.newOptionsFilter()});
    }

    public static Handler newHttpHandler(ConnectionFactory connectionFactory, Context parentContext) {
        Reject.ifNull((Object)connectionFactory);
        Reject.ifNull((Object)parentContext);
        return Handlers.chainOf((Handler)new HttpAdapter(connectionFactory, parentContext), (Filter[])new Filter[]{CrestHttp.newOptionsFilter()});
    }

    public static Handler newHttpHandler(ConnectionFactory connectionFactory, HttpContextFactory contextFactory) {
        Reject.ifNull((Object)connectionFactory);
        Reject.ifNull((Object)contextFactory);
        return Handlers.chainOf((Handler)new HttpAdapter(connectionFactory, contextFactory), (Filter[])new Filter[]{CrestHttp.newOptionsFilter()});
    }

    public static Handler newHttpHandler(RequestHandler handler) {
        Reject.ifNull((Object)handler);
        return Handlers.chainOf((Handler)new HttpAdapter(Resources.newInternalConnectionFactory((RequestHandler)handler)), (Filter[])new Filter[]{CrestHttp.newOptionsFilter()});
    }

    public static RequestHandler newRequestHandler(Handler handler, URI uri) {
        return new CrestAdapter(handler, uri);
    }

    public static ConnectionFactory newConnectionFactory(Handler handler, URI uri) {
        return Resources.newInternalConnectionFactory((RequestHandler)CrestHttp.newRequestHandler(handler, uri));
    }

    private static Filter newOptionsFilter() {
        return Filters.newOptionsFilter((String[])new String[]{"DELETE", "GET", "HEAD", "PATCH", "PUT", "OPTIONS", "TRACE"});
    }
}

