/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.policy;

import com.persistit.Buffer;
import com.persistit.Exchange;

public abstract class SplitPolicy {
    public static final SplitPolicy LEFT_BIAS = new Left();
    public static final SplitPolicy RIGHT_BIAS = new Right();
    public static final SplitPolicy EVEN_BIAS = new Even();
    public static final SplitPolicy NICE_BIAS = new Nice();
    public static final SplitPolicy PACK_BIAS = new Pack();
    public static final SplitPolicy LEFT90_BIAS = new Left90();
    public static final SplitPolicy RIGHT90_BIAS = new Right90();
    static final int KEYBLOCK_LENGTH = 4;
    private static final SplitPolicy[] POLICIES = new SplitPolicy[]{LEFT_BIAS, RIGHT_BIAS, EVEN_BIAS, NICE_BIAS, PACK_BIAS, LEFT90_BIAS, RIGHT90_BIAS};
    private static final float PACK_SHOULDER = 0.9f;

    public static SplitPolicy forName(String name) {
        for (SplitPolicy policy : POLICIES) {
            if (!policy.toString().equalsIgnoreCase(name)) continue;
            return policy;
        }
        throw new IllegalArgumentException("No such SplitPolicy " + name);
    }

    public abstract int splitFit(Buffer var1, int var2, int var3, boolean var4, int var5, int var6, int var7, int var8, int var9, int var10, Exchange.Sequence var11);

    private static class Pack
    extends SplitPolicy {
        private Pack() {
        }

        @Override
        public int splitFit(Buffer buffer, int kbOffset, int insertAt, boolean replace, int leftSize, int rightSize, int currentSize, int virtualSize, int capacity, int splitInfo, Exchange.Sequence sequence) {
            if (leftSize > capacity || rightSize > capacity) {
                return 0;
            }
            if (!replace) {
                if (sequence == Exchange.Sequence.FORWARD) {
                    int shoulder = (int)((float)capacity * 0.9f);
                    int keyOffsetCost = Math.abs(insertAt - kbOffset);
                    if (leftSize < shoulder && rightSize < shoulder) {
                        return capacity * 2 - keyOffsetCost;
                    }
                } else if (sequence == Exchange.Sequence.REVERSE) {
                    int shoulder = (int)((float)capacity * 0.9f);
                    int keyOffsetCost = Math.abs(insertAt - kbOffset + 4);
                    if (leftSize < shoulder && rightSize < shoulder) {
                        return capacity * 2 - keyOffsetCost;
                    }
                }
            }
            return NICE_BIAS.splitFit(buffer, kbOffset, insertAt, replace, leftSize, rightSize, currentSize, virtualSize, capacity, splitInfo, sequence);
        }

        public String toString() {
            return "PACK";
        }
    }

    private static class Nice
    extends SplitPolicy {
        private Nice() {
        }

        @Override
        public int splitFit(Buffer buffer, int kbOffset, int insertAt, boolean replace, int leftSize, int rightSize, int currentSize, int virtualSize, int capacity, int splitInfo, Exchange.Sequence sequence) {
            if (leftSize > capacity || rightSize > capacity) {
                return 0;
            }
            int difference = 2 * rightSize - leftSize;
            if (difference < 0) {
                difference = -difference;
            }
            return capacity * 2 - difference;
        }

        public String toString() {
            return "NICE";
        }
    }

    private static class Even
    extends SplitPolicy {
        private Even() {
        }

        @Override
        public int splitFit(Buffer buffer, int kbOffset, int insertAt, boolean replace, int leftSize, int rightSize, int currentSize, int virtualSize, int capacity, int splitInfo, Exchange.Sequence sequence) {
            if (leftSize > capacity || rightSize > capacity) {
                return 0;
            }
            int difference = rightSize - leftSize;
            if (difference < 0) {
                difference = -difference;
            }
            return capacity - difference;
        }

        public String toString() {
            return "EVEN";
        }
    }

    private static class Right90
    extends SplitPolicy {
        private Right90() {
        }

        @Override
        public int splitFit(Buffer buffer, int kbOffset, int insertAt, boolean replace, int leftSize, int rightSize, int currentSize, int virtualSize, int capacity, int splitInfo, Exchange.Sequence sequence) {
            if (leftSize > capacity || rightSize > capacity) {
                return 0;
            }
            return capacity - (int)Math.abs((float)capacity * 0.9f - (float)rightSize);
        }

        public String toString() {
            return "RIGHT90";
        }
    }

    private static class Left90
    extends SplitPolicy {
        private Left90() {
        }

        @Override
        public int splitFit(Buffer buffer, int kbOffset, int insertAt, boolean replace, int leftSize, int rightSize, int currentSize, int virtualSize, int capacity, int splitInfo, Exchange.Sequence sequence) {
            if (leftSize > capacity || rightSize > capacity) {
                return 0;
            }
            return capacity - (int)Math.abs((float)capacity * 0.9f - (float)leftSize);
        }

        public String toString() {
            return "LEFT90";
        }
    }

    private static class Right
    extends SplitPolicy {
        private Right() {
        }

        @Override
        public int splitFit(Buffer buffer, int kbOffset, int insertAt, boolean replace, int leftSize, int rightSize, int currentSize, int virtualSize, int capacity, int splitInfo, Exchange.Sequence sequence) {
            if (leftSize > capacity || rightSize > capacity) {
                return 0;
            }
            return rightSize;
        }

        public String toString() {
            return "RIGHT";
        }
    }

    private static class Left
    extends SplitPolicy {
        private Left() {
        }

        @Override
        public int splitFit(Buffer buffer, int kbOffset, int insertAt, boolean replace, int leftSize, int rightSize, int currentSize, int virtualSize, int capacity, int splitInfo, Exchange.Sequence sequence) {
            if (leftSize > capacity || rightSize > capacity) {
                return 0;
            }
            return leftSize;
        }

        public String toString() {
            return "LEFT";
        }
    }
}

