/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.spi.BindResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.ExtendedResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LDAPConnectionImpl;
import org.forgerock.opendj.ldap.spi.LdapPromiseWrapper;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;

public final class LdapPromises {
    private LdapPromises() {
    }

    public static <R> LdapPromise<R> asPromise(Promise<R, LdapException> wrappedPromise) {
        return LdapPromises.wrap(wrappedPromise, -1);
    }

    public static BindResultLdapPromiseImpl newBindLdapPromise(int requestID, BindRequest request, BindClient bindClient, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        return new BindResultLdapPromiseImpl(LdapPromises.newInnerBindOrStartTLSPromise(), requestID, request, bindClient, intermediateResponseHandler);
    }

    public static BindResultLdapPromiseImpl newBindLdapPromise(int requestID, BindRequest request, BindClient bindClient, IntermediateResponseHandler intermediateResponseHandler, LDAPConnectionImpl connection) {
        return new BindResultLdapPromiseImpl(LdapPromises.newInnerBindOrStartTLSPromise(), requestID, request, bindClient, intermediateResponseHandler);
    }

    public static ResultLdapPromiseImpl<CompareRequest, CompareResult> newCompareLdapPromise(int requestID, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        PromiseImpl innerPromise = LdapPromises.newInnerPromise(connection, requestID);
        return LdapPromises.newCompareLdapPromise(innerPromise, requestID, request, intermediateResponseHandler);
    }

    public static ResultLdapPromiseImpl<CompareRequest, CompareResult> newCompareLdapPromise(int requestID, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LDAPConnectionImpl connection) {
        PromiseImpl innerPromise = LdapPromises.newInnerPromise(connection, requestID);
        return LdapPromises.newCompareLdapPromise(innerPromise, requestID, request, intermediateResponseHandler);
    }

    private static ResultLdapPromiseImpl<CompareRequest, CompareResult> newCompareLdapPromise(PromiseImpl<CompareResult, LdapException> innerPromise, int requestID, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        return new ResultLdapPromiseImpl<CompareRequest, CompareResult>(innerPromise, requestID, request, intermediateResponseHandler){

            @Override
            protected CompareResult newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
                return Responses.newCompareResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
            }
        };
    }

    public static <S extends ExtendedResult> ExtendedResultLdapPromiseImpl<S> newExtendedLdapPromise(int requestID, ExtendedRequest<S> request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        PromiseImpl<S, LdapException> innerPromise = !"1.3.6.1.4.1.1466.20037".equals(request.getOID()) ? LdapPromises.newInnerBindOrStartTLSPromise() : LdapPromises.newInnerPromise(connection, requestID);
        return new ExtendedResultLdapPromiseImpl<S>(innerPromise, requestID, request, intermediateResponseHandler);
    }

    public static <S extends ExtendedResult> ExtendedResultLdapPromiseImpl<S> newExtendedLdapPromise(int requestID, ExtendedRequest<S> request, IntermediateResponseHandler intermediateResponseHandler, LDAPConnectionImpl connection) {
        PromiseImpl<S, LdapException> innerPromise = !"1.3.6.1.4.1.1466.20037".equals(request.getOID()) ? LdapPromises.newInnerBindOrStartTLSPromise() : LdapPromises.newInnerPromise(connection, requestID);
        return new ExtendedResultLdapPromiseImpl<S>(innerPromise, requestID, request, intermediateResponseHandler);
    }

    public static <R extends Request> ResultLdapPromiseImpl<R, Result> newResultLdapPromise(int requestID, R request, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        PromiseImpl innerPromise = LdapPromises.newInnerPromise(connection, requestID);
        return LdapPromises.newResultLdapPromise(innerPromise, requestID, request, intermediateResponseHandler);
    }

    public static <R extends Request> ResultLdapPromiseImpl<R, Result> newResultLdapPromise(int requestID, R request, IntermediateResponseHandler intermediateResponseHandler, LDAPConnectionImpl connection) {
        PromiseImpl innerPromise = LdapPromises.newInnerPromise(connection, requestID);
        return LdapPromises.newResultLdapPromise(innerPromise, requestID, request, intermediateResponseHandler);
    }

    private static <R extends Request> ResultLdapPromiseImpl<R, Result> newResultLdapPromise(PromiseImpl<Result, LdapException> innerPromise, int requestID, R request, IntermediateResponseHandler intermediateResponseHandler) {
        return new ResultLdapPromiseImpl<R, Result>(innerPromise, requestID, request, intermediateResponseHandler){

            @Override
            protected Result newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
                return Responses.newResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
            }
        };
    }

    public static SearchResultLdapPromiseImpl newSearchLdapPromise(int requestID, SearchRequest request, SearchResultHandler resultHandler, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        return new SearchResultLdapPromiseImpl(LdapPromises.newInnerPromise(connection, requestID), requestID, request, resultHandler, intermediateResponseHandler);
    }

    public static SearchResultLdapPromiseImpl newSearchLdapPromise(int requestID, SearchRequest request, SearchResultHandler resultHandler, IntermediateResponseHandler intermediateResponseHandler, LDAPConnectionImpl connection) {
        return new SearchResultLdapPromiseImpl(LdapPromises.newInnerPromise(connection, requestID), requestID, request, resultHandler, intermediateResponseHandler);
    }

    public static <R, E extends LdapException> LdapPromise<R> newFailedLdapPromise(E error) {
        return LdapPromises.wrap(Promises.newExceptionPromise(error), -1);
    }

    public static <R, E extends LdapException> LdapPromise<R> newFailedLdapPromise(E error, int requestID) {
        return LdapPromises.wrap(Promises.newExceptionPromise(error), requestID);
    }

    public static <R> LdapPromise<R> newSuccessfulLdapPromise(R result) {
        return LdapPromises.wrap(Promises.newResultPromise(result), -1);
    }

    public static <R> LdapPromise<R> newSuccessfulLdapPromise(R result, int requestID) {
        return LdapPromises.wrap(Promises.newResultPromise(result), requestID);
    }

    private static <S extends Result> PromiseImpl<S, LdapException> newInnerBindOrStartTLSPromise() {
        return new PromiseImpl<S, LdapException>(){

            protected LdapException tryCancel(boolean mayInterruptIfRunning) {
                return null;
            }
        };
    }

    private static <S extends Result> PromiseImpl<S, LdapException> newInnerPromise(final Connection connection, final int requestID) {
        return new PromiseImpl<S, LdapException>(){

            protected final LdapException tryCancel(boolean mayInterruptIfRunning) {
                connection.abandonAsync(Requests.newAbandonRequest(requestID));
                return LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED);
            }
        };
    }

    private static <S extends Result> PromiseImpl<S, LdapException> newInnerPromise(final LDAPConnectionImpl connection, final int requestID) {
        return new PromiseImpl<S, LdapException>(){

            protected final LdapException tryCancel(boolean mayInterruptIfRunning) {
                connection.abandonAsync(Requests.newAbandonRequest(requestID));
                return LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED);
            }
        };
    }

    static <R> LdapPromise<R> wrap(Promise<R, LdapException> wrappedPromise, int requestID) {
        return new LdapPromiseWrapper(wrappedPromise, requestID);
    }
}

