/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeTypeSyntaxImpl;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.AuthPasswordExactEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.AuthPasswordSyntaxImpl;
import org.forgerock.opendj.ldap.schema.BinarySyntaxImpl;
import org.forgerock.opendj.ldap.schema.BitStringEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.BitStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.BooleanEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.BooleanSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CaseExactEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseExactIA5EqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseExactIA5SubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseExactOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseExactSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreIA5EqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreIA5SubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreListEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreListSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CertificateExactAssertionSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CertificateExactMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CertificateListSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CertificatePairSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CertificateSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CollationMatchingRulesImpl;
import org.forgerock.opendj.ldap.schema.CoreSchemaSupportedLocales;
import org.forgerock.opendj.ldap.schema.CountryStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DITContentRuleSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DITStructureRuleSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DeliveryMethodSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DirectoryStringFirstComponentEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.DirectoryStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DistinguishedNameEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.DistinguishedNameSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DoubleMetaphoneApproximateMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.EnhancedGuideSyntaxImpl;
import org.forgerock.opendj.ldap.schema.FacsimileNumberSyntaxImpl;
import org.forgerock.opendj.ldap.schema.FaxSyntaxImpl;
import org.forgerock.opendj.ldap.schema.GeneralizedTimeEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.GeneralizedTimeOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.GeneralizedTimeSyntaxImpl;
import org.forgerock.opendj.ldap.schema.GuideSyntaxImpl;
import org.forgerock.opendj.ldap.schema.IA5StringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.IntegerEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.IntegerFirstComponentEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.IntegerOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.IntegerSyntaxImpl;
import org.forgerock.opendj.ldap.schema.JPEGSyntaxImpl;
import org.forgerock.opendj.ldap.schema.KeywordEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.LDAPSyntaxDescriptionSyntaxImpl;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.MatchingRuleSyntaxImpl;
import org.forgerock.opendj.ldap.schema.MatchingRuleUseSyntaxImpl;
import org.forgerock.opendj.ldap.schema.NameAndOptionalUIDSyntaxImpl;
import org.forgerock.opendj.ldap.schema.NameFormSyntaxImpl;
import org.forgerock.opendj.ldap.schema.NumericStringEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.NumericStringOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.NumericStringSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.NumericStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.OIDSyntaxImpl;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassSyntaxImpl;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.ObjectIdentifierEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.ObjectIdentifierFirstComponentEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.OctetStringEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.OctetStringOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.OctetStringSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.OctetStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.OtherMailboxSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PostalAddressSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PresentationAddressEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.PresentationAddressSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PrintableStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.ProtocolInformationEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.ProtocolInformationSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SubstringAssertionSyntaxImpl;
import org.forgerock.opendj.ldap.schema.SupportedAlgorithmSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.TelephoneNumberEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.TelephoneNumberSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.TelephoneNumberSyntaxImpl;
import org.forgerock.opendj.ldap.schema.TeletexTerminalIdentifierSyntaxImpl;
import org.forgerock.opendj.ldap.schema.TelexNumberSyntaxImpl;
import org.forgerock.opendj.ldap.schema.TimeBasedMatchingRulesImpl;
import org.forgerock.opendj.ldap.schema.UTCTimeSyntaxImpl;
import org.forgerock.opendj.ldap.schema.UUIDEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.UUIDOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.UUIDSyntaxImpl;
import org.forgerock.opendj.ldap.schema.UniqueMemberEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.UserPasswordExactEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.UserPasswordSyntaxImpl;

final class CoreSchemaImpl {
    private static final Map<String, List<String>> X500_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("X.500"));
    private static final Map<String, List<String>> RFC2252_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 2252"));
    private static final Map<String, List<String>> RFC3045_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 3045"));
    private static final Map<String, List<String>> RFC3112_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 3112"));
    private static final Map<String, List<String>> RFC4512_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4512"));
    private static final Map<String, List<String>> RFC4517_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4517"));
    private static final Map<String, List<String>> RFC4519_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4519"));
    private static final Map<String, List<String>> RFC4523_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4523"));
    private static final Map<String, List<String>> RFC4530_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4530"));
    private static final Map<String, List<String>> RFC5020_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 5020"));
    static final Map<String, List<String>> OPENDS_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("OpenDS Directory Server"));
    private static final Map<String, List<String>> OPENDJ_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("OpenDJ Directory Server"));
    private static final Schema SINGLETON;
    public static final Map<String, String> JVM_SUPPORTED_LOCALE_NAMES_TO_OIDS;

    static Schema getInstance() {
        return SINGLETON;
    }

    private static void addRFC3045(SchemaBuilder builder) {
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.1.4").names("vendorName").equalityMatchingRule("1.3.6.1.4.1.1466.109.114.1").syntax("1.3.6.1.4.1.1466.115.121.1.15").singleValue(true).noUserModification(true).usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC3045_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.1.5").names("vendorVersion").equalityMatchingRule("1.3.6.1.4.1.1466.109.114.1").syntax("1.3.6.1.4.1.1466.115.121.1.15").singleValue(true).noUserModification(true).usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC3045_ORIGIN)).addToSchema();
    }

    private static void addRFC3112(SchemaBuilder builder) {
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.4203.1.1.2").description("Authentication Password Syntax").extraProperties((Map)RFC3112_ORIGIN)).implementation(new AuthPasswordSyntaxImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.4203.1.2.2").names("authPasswordExactMatch").description("authentication password exact matching rule").syntaxOID("1.3.6.1.4.1.4203.1.1.2").extraProperties((Map)RFC3112_ORIGIN)).implementation(new AuthPasswordExactEqualityMatchingRuleImpl()).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.4203.1.3.3").names("supportedAuthPasswordSchemes").description("supported password storage schemes").equalityMatchingRule("1.3.6.1.4.1.1466.109.114.1").syntax("1.3.6.1.4.1.1466.115.121.1.26").usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC3112_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.4203.1.3.4").names("authPassword").description("password authentication information").equalityMatchingRule("1.3.6.1.4.1.4203.1.2.2").syntax("1.3.6.1.4.1.4203.1.1.2").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC3112_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("1.3.6.1.4.1.4203.1.4.7").names("authPasswordObject").type(ObjectClassType.AUXILIARY).description("authentication password mix in class").optionalAttributes("authPassword").extraProperties((Map)RFC3112_ORIGIN)).addToSchema();
    }

    private static void addRFC4519(SchemaBuilder builder) {
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.15").names("businessCategory").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.41").names("name").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.6").names("c", "countryName").superiorType("name").syntax("1.3.6.1.4.1.1466.115.121.1.11").singleValue(true).usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.3").names("cn", "commonName").superiorType("name").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("0.9.2342.19200300.100.1.25").names("dc", "domainComponent").equalityMatchingRule("1.3.6.1.4.1.1466.109.114.2").substringMatchingRule("1.3.6.1.4.1.1466.109.114.3").syntax("1.3.6.1.4.1.1466.115.121.1.26").singleValue(true).usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.13").names("description").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.27").names("destinationIndicator").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.44").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.49").names("distinguishedName").equalityMatchingRule("2.5.13.1").syntax("1.3.6.1.4.1.1466.115.121.1.12").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.46").names("dnQualifier").equalityMatchingRule("2.5.13.2").orderingMatchingRule("2.5.13.3").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.44").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.47").names("enhancedSearchGuide").syntax("1.3.6.1.4.1.1466.115.121.1.21").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.23").names("facsimileTelephoneNumber").syntax("1.3.6.1.4.1.1466.115.121.1.22").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.44").names("generationQualifier").superiorType("name").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.42").names("givenName").superiorType("name").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.51").names("houseIdentifier").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.43").names("initials").superiorType("name").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.25").names("internationalISDNNumber").equalityMatchingRule("2.5.13.8").substringMatchingRule("2.5.13.10").syntax("1.3.6.1.4.1.1466.115.121.1.36").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.7").names("l", "localityName").superiorType("name").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.31").names("member").superiorType("distinguishedName").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.10").names("o", "organizationName").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.11").names("ou", "organizationalUnitName").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.32").names("owner").superiorType("distinguishedName").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.19").names("physicalDeliveryOfficeName").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.16").names("postalAddress").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.17").names("postalCode").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.18").names("postOfficeBox").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.28").names("preferredDeliveryMethod").syntax("1.3.6.1.4.1.1466.115.121.1.14").singleValue(true).usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.26").names("registeredAddress").superiorType("postalAddress").syntax("1.3.6.1.4.1.1466.115.121.1.41").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.33").names("roleOccupant").superiorType("distinguishedName").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.14").names("searchGuide").syntax("1.3.6.1.4.1.1466.115.121.1.25").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.34").names("seeAlso").superiorType("distinguishedName").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.5").names("serialNumber").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.44").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.4").names("sn", "surname").superiorType("name").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.8").names("st", "stateOrProvinceName").superiorType("name").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.9").names("street", "streetAddress").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.20").names("telephoneNumber").equalityMatchingRule("2.5.13.20").substringMatchingRule("2.5.13.21").syntax("1.3.6.1.4.1.1466.115.121.1.50").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.22").names("teletexTerminalIdentifier").syntax("1.3.6.1.4.1.1466.115.121.1.51").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.21").names("telexNumber").syntax("1.3.6.1.4.1.1466.115.121.1.52").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.12").names("title").superiorType("name").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("0.9.2342.19200300.100.1.1").names("uid", "userid").equalityMatchingRule("2.5.13.2").substringMatchingRule("2.5.13.4").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.50").names("uniqueMember").equalityMatchingRule("2.5.13.23").syntax("1.3.6.1.4.1.1466.115.121.1.34").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.35").names("userPassword").equalityMatchingRule("2.5.13.17").syntax("1.3.6.1.4.1.1466.115.121.1.40").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.24").names("x121Address").equalityMatchingRule("2.5.13.8").substringMatchingRule("2.5.13.10").syntax("1.3.6.1.4.1.1466.115.121.1.36").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.45").names("x500UniqueIdentifier").equalityMatchingRule("2.5.13.16").syntax("1.3.6.1.4.1.1466.115.121.1.6").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.11").names("applicationProcess").superiorObjectClasses("top").requiredAttributes("cn").optionalAttributes("seeAlso", "ou", "l", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.2").names("country").superiorObjectClasses("top").requiredAttributes("c").optionalAttributes("searchGuide", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("1.3.6.1.4.1.1466.344").names("dcObject").type(ObjectClassType.AUXILIARY).superiorObjectClasses("top").requiredAttributes("dc").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.14").names("device").superiorObjectClasses("top").requiredAttributes("cn").optionalAttributes("serialNumber", "seeAlso", "owner", "ou", "o", "l", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.9").names("groupOfNames").superiorObjectClasses("top").requiredAttributes("member", "cn").optionalAttributes("businessCategory", "seeAlso", "owner", "ou", "o", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.17").names("groupOfUniqueNames").superiorObjectClasses("top").requiredAttributes("member", "cn").optionalAttributes("businessCategory", "seeAlso", "owner", "ou", "o", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.3").names("locality").superiorObjectClasses("top").optionalAttributes("street", "seeAlso", "searchGuide", "st", "l", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.4").names("organization").superiorObjectClasses("top").requiredAttributes("o").optionalAttributes("userPassword", "searchGuide", "seeAlso", "businessCategory", "x121Address", "registeredAddress", "destinationIndicator", "preferredDeliveryMethod", "telexNumber", "teletexTerminalIdentifier", "telephoneNumber", "internationalISDNNumber", "facsimileTelephoneNumber", "street", "postOfficeBox", "postalCode", "postalAddress", "physicalDeliveryOfficeName", "st", "l", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.7").names("organizationalPerson").superiorObjectClasses("person").optionalAttributes("title", "x121Address", "registeredAddress", "destinationIndicator", "preferredDeliveryMethod", "telexNumber", "teletexTerminalIdentifier", "telephoneNumber", "internationalISDNNumber", "facsimileTelephoneNumber", "street", "postOfficeBox", "postalCode", "postalAddress", "physicalDeliveryOfficeName", "ou", "st", "l").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.8").names("organizationalRole").superiorObjectClasses("top").requiredAttributes("cn").optionalAttributes("x121Address", "registeredAddress", "destinationIndicator", "preferredDeliveryMethod", "telexNumber", "teletexTerminalIdentifier", "telephoneNumber", "internationalISDNNumber", "facsimileTelephoneNumber", "seeAlso", "roleOccupant", "preferredDeliveryMethod", "street", "postOfficeBox", "postalCode", "postalAddress", "physicalDeliveryOfficeName", "ou", "st", "l", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.5").names("organizationalUnit").superiorObjectClasses("top").requiredAttributes("ou").optionalAttributes("businessCategory", "description", "destinationIndicator", "facsimileTelephoneNumber", "internationalISDNNumber", "l", "physicalDeliveryOfficeName", "postalAddress", "postalCode", "postOfficeBox", "preferredDeliveryMethod", "registeredAddress", "searchGuide", "seeAlso", "st", "street", "telephoneNumber", "teletexTerminalIdentifier", "telexNumber", "userPassword", "x121Address").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.6").names("person").superiorObjectClasses("top").requiredAttributes("sn", "cn").optionalAttributes("userPassword", "telephoneNumber", "destinationIndicator", "seeAlso", "description").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.10").names("residentialPerson").superiorObjectClasses("person").requiredAttributes("l").optionalAttributes("businessCategory", "x121Address", "registeredAddress", "destinationIndicator", "preferredDeliveryMethod", "telexNumber", "teletexTerminalIdentifier", "telephoneNumber", "internationalISDNNumber", "facsimileTelephoneNumber", "preferredDeliveryMethod", "street", "postOfficeBox", "postalCode", "postalAddress", "physicalDeliveryOfficeName", "st", "l").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("1.3.6.1.1.3.1").names("uidObject").type(ObjectClassType.AUXILIARY).superiorObjectClasses("top").requiredAttributes("uid").optionalAttributes("businessCategory", "x121Address", "registeredAddress", "destinationIndicator", "preferredDeliveryMethod", "telexNumber", "teletexTerminalIdentifier", "telephoneNumber", "internationalISDNNumber", "facsimileTelephoneNumber", "preferredDeliveryMethod", "street", "postOfficeBox", "postalCode", "postalAddress", "physicalDeliveryOfficeName", "st", "l").extraProperties((Map)RFC4519_ORIGIN)).addToSchema();
    }

    private static void addRFC4523(SchemaBuilder builder) {
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.9").description("Certificate List").extraProperties((Map)RFC4523_ORIGIN)).implementation(new CertificateListSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.10").description("Certificate Pair").extraProperties((Map)RFC4523_ORIGIN)).implementation(new CertificatePairSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.8").description("Certificate").extraProperties((Map)RFC4523_ORIGIN)).implementation(new CertificateSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.1.15.1").description("X.509 Certificate Exact Assertion").extraProperties((Map)RFC4523_ORIGIN)).implementation(new CertificateExactAssertionSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.49").description("Supported Algorithm").extraProperties((Map)RFC4523_ORIGIN)).implementation(new SupportedAlgorithmSyntaxImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.34").names("certificateExactMatch").syntaxOID("1.3.6.1.1.15.1").extraProperties((Map)RFC4523_ORIGIN)).implementation(new CertificateExactMatchingRuleImpl()).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.36").names("userCertificate").description("X.509 user certificate").equalityMatchingRule("2.5.13.34").syntax("1.3.6.1.4.1.1466.115.121.1.8").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.37").names("cACertificate").description("X.509 CA certificate").equalityMatchingRule("2.5.13.34").syntax("1.3.6.1.4.1.1466.115.121.1.8").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.38").names("authorityRevocationList").description("X.509 authority revocation list").equalityMatchingRule("2.5.13.17").syntax("1.3.6.1.4.1.1466.115.121.1.9").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.39").names("certificateRevocationList").description("X.509 certificate revocation list").equalityMatchingRule("2.5.13.17").syntax("1.3.6.1.4.1.1466.115.121.1.9").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.40").names("crossCertificatePair").description("X.509 cross certificate pair").equalityMatchingRule("2.5.13.17").syntax("1.3.6.1.4.1.1466.115.121.1.10").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.52").names("supportedAlgorithms").description("X.509 supported algorithms").equalityMatchingRule("2.5.13.17").syntax("1.3.6.1.4.1.1466.115.121.1.49").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.53").names("deltaRevocationList").description("X.509 delta revocation list").equalityMatchingRule("2.5.13.17").syntax("1.3.6.1.4.1.1466.115.121.1.9").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.21").names("pkiUser").type(ObjectClassType.AUXILIARY).description("X.509 PKI User").superiorObjectClasses("top").optionalAttributes("userCertificate").extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.22").names("pkiCA").type(ObjectClassType.AUXILIARY).superiorObjectClasses("top").description("X.509 PKI Certificate Authority").optionalAttributes("cACertificate", "certificateRevocationList", "authorityRevocationList", "crossCertificatePair").extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.19").names("cRLDistributionPoint").description("X.509 CRL distribution point").superiorObjectClasses("top").requiredAttributes("cn").optionalAttributes("certificateRevocationList", "authorityRevocationList", "deltaRevocationList").extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.23").names("deltaCRL").type(ObjectClassType.AUXILIARY).description("X.509 delta CRL").superiorObjectClasses("top").optionalAttributes("deltaRevocationList").extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.15").names("strongAuthenticationUser").type(ObjectClassType.AUXILIARY).description("X.521 strong authentication user").superiorObjectClasses("top").requiredAttributes("userCertificate").extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.18").names("userSecurityInformation").type(ObjectClassType.AUXILIARY).description("X.521 user security information").superiorObjectClasses("top").optionalAttributes("supportedAlgorithms").extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.16").names("certificationAuthority").type(ObjectClassType.AUXILIARY).description("X.509 certificate authority").superiorObjectClasses("top").requiredAttributes("authorityRevocationList", "certificateRevocationList", "cACertificate").optionalAttributes("crossCertificatePair").extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.16.2").names("certificationAuthority-V2").type(ObjectClassType.AUXILIARY).description("X.509 certificate authority, version 2").superiorObjectClasses("certificationAuthority").optionalAttributes("deltaRevocationList").extraProperties((Map)RFC4523_ORIGIN)).addToSchema();
    }

    private static void addRFC4530(SchemaBuilder builder) {
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.1.16.1").description("UUID").extraProperties((Map)RFC4530_ORIGIN)).implementation(new UUIDSyntaxImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.1.16.2").names("uuidMatch").syntaxOID("1.3.6.1.1.16.1").extraProperties((Map)RFC4530_ORIGIN)).implementation(new UUIDEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.1.16.3").names("uuidOrderingMatch").syntaxOID("1.3.6.1.1.16.1").extraProperties((Map)RFC4530_ORIGIN)).implementation(new UUIDOrderingMatchingRuleImpl()).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.1.16.4").names("entryUUID").description("UUID of the entry").equalityMatchingRule("1.3.6.1.1.16.2").orderingMatchingRule("1.3.6.1.1.16.3").syntax("1.3.6.1.1.16.1").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4530_ORIGIN)).addToSchema();
    }

    private static void addRFC5020(SchemaBuilder builder) {
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.1.20").names("entryDN").description("DN of the entry").equalityMatchingRule("2.5.13.1").syntax("1.3.6.1.4.1.1466.115.121.1.12").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC5020_ORIGIN)).addToSchema();
    }

    private static void addSunProprietary(SchemaBuilder builder) {
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.26027.1.3.1").description("User Password").extraProperties((Map)OPENDS_ORIGIN)).implementation(new UserPasswordSyntaxImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.26027.1.4.2").names(Collections.singletonList("ds-mr-user-password-exact")).description("user password exact matching rule").syntaxOID("1.3.6.1.4.1.26027.1.3.1").extraProperties((Map)OPENDS_ORIGIN)).implementation(new UserPasswordExactEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.26027.1.4.1").names(Collections.singletonList("ds-mr-double-metaphone-approx")).description("Double Metaphone Approximate Match").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)OPENDS_ORIGIN)).implementation(new DoubleMetaphoneApproximateMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.26027.1.4.5").names("relativeTimeGTOrderingMatch", "relativeTimeOrderingMatch.gt").description("greater-than relative time for time-based searches").syntaxOID("1.3.6.1.4.1.1466.115.121.1.24").extraProperties((Map)OPENDS_ORIGIN)).implementation(TimeBasedMatchingRulesImpl.relativeTimeGTOMatchingRule()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.26027.1.4.6").names("relativeTimeLTOrderingMatch", "relativeTimeOrderingMatch.lt").description("less-than relative time for time-based searches").syntaxOID("1.3.6.1.4.1.1466.115.121.1.24").extraProperties((Map)OPENDS_ORIGIN)).implementation(TimeBasedMatchingRulesImpl.relativeTimeLTOMatchingRule()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.26027.1.4.7").names(Collections.singletonList("partialDateAndTimeMatchingRule")).description("partial date and time matching").syntaxOID("1.3.6.1.4.1.1466.115.121.1.24").extraProperties((Map)OPENDS_ORIGIN)).implementation(TimeBasedMatchingRulesImpl.partialDateAndTimeMatchingRule()).addToSchema();
        CoreSchemaImpl.addCollationMatchingRules(builder);
    }

    private static void addForgeRockProprietary(SchemaBuilder builder) {
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.36733.2.1.1.141").names("fullVendorVersion").equalityMatchingRule("1.3.6.1.4.1.1466.109.114.1").syntax("1.3.6.1.4.1.1466.115.121.1.15").singleValue(true).noUserModification(true).usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)OPENDJ_ORIGIN)).addToSchema();
    }

    /*
     * WARNING - void declaration
     */
    private static void addCollationMatchingRules(SchemaBuilder builder) {
        ArrayList<String> names;
        String oid;
        void var4_6;
        TreeMap<String, Locale> localesCache = new TreeMap<String, Locale>();
        Locale[] arr$ = Locale.getAvailableLocales();
        int len$ = arr$.length;
        boolean bl = false;
        while (var4_6 < len$) {
            Locale locale = arr$[var4_6];
            localesCache.put(CoreSchemaImpl.localeName(locale), locale);
            ++var4_6;
        }
        HashMap<String, ArrayList<String>> oidsCache = new HashMap<String, ArrayList<String>>();
        for (String string : localesCache.keySet()) {
            oid = JVM_SUPPORTED_LOCALE_NAMES_TO_OIDS.get(string);
            if (oid == null) continue;
            names = (ArrayList<String>)oidsCache.get(oid);
            if (names == null) {
                names = new ArrayList<String>(5);
                oidsCache.put(oid, names);
            }
            names.add(string);
        }
        for (Map.Entry entry : oidsCache.entrySet()) {
            oid = (String)entry.getKey();
            names = (List)entry.getValue();
            Locale locale = (Locale)localesCache.get(names.get(0));
            CoreSchemaImpl.addCollationMatchingRule(builder, oid, names, 1, "lt", CollationMatchingRulesImpl.collationLessThanMatchingRule(locale));
            CoreSchemaImpl.addCollationMatchingRule(builder, oid, names, 2, "lte", CollationMatchingRulesImpl.collationLessThanOrEqualMatchingRule(locale));
            MatchingRuleImpl collationEqualityMatchingRule = CollationMatchingRulesImpl.collationEqualityMatchingRule(locale);
            CoreSchemaImpl.addCollationMatchingRule(builder, oid, names, 3, "eq", collationEqualityMatchingRule);
            boolean ignored = false;
            CoreSchemaImpl.addCollationMatchingRule(builder, oid, names, 0, "", collationEqualityMatchingRule);
            CoreSchemaImpl.addCollationMatchingRule(builder, oid, names, 4, "gte", CollationMatchingRulesImpl.collationGreaterThanOrEqualToMatchingRule(locale));
            CoreSchemaImpl.addCollationMatchingRule(builder, oid, names, 5, "gt", CollationMatchingRulesImpl.collationGreaterThanMatchingRule(locale));
            CoreSchemaImpl.addCollationMatchingRule(builder, oid, names, 6, "sub", CollationMatchingRulesImpl.collationSubstringMatchingRule(locale));
        }
    }

    private static void addCollationMatchingRule(SchemaBuilder builder, String baseOid, List<String> names, int numericSuffix, String symbolicSuffix, MatchingRuleImpl matchingRuleImplementation) {
        String oid = symbolicSuffix.isEmpty() ? baseOid : baseOid + "." + numericSuffix;
        ((MatchingRule.Builder)builder.buildMatchingRule(oid).names(CoreSchemaImpl.collationMatchingRuleNames(names, numericSuffix, symbolicSuffix)).syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)OPENDS_ORIGIN)).implementation(matchingRuleImplementation).addToSchema();
    }

    private static String[] collationMatchingRuleNames(List<String> localeNames, int numSuffix, String symbolicSuffix) {
        ArrayList<String> names = new ArrayList<String>();
        for (String localeName : localeNames) {
            if (symbolicSuffix.isEmpty()) {
                names.add(localeName);
                continue;
            }
            names.add(localeName + "." + numSuffix);
            names.add(localeName + "." + symbolicSuffix);
        }
        return names.toArray(new String[names.size()]);
    }

    private static String localeName(Locale locale) {
        String variant;
        StringBuilder name = new StringBuilder(locale.getLanguage());
        String country = locale.getCountry();
        if (!country.isEmpty()) {
            name.append('-').append(country);
        }
        if (!(variant = locale.getVariant()).isEmpty()) {
            name.append('-').append(variant.toUpperCase());
        }
        return name.toString();
    }

    private static void defaultAttributeTypes(SchemaBuilder builder) {
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.0").names("objectClass").equalityMatchingRule("objectIdentifierMatch").syntax("1.3.6.1.4.1.1466.115.121.1.38").usage(AttributeUsage.USER_APPLICATIONS).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.4.1").names("aliasedObjectName").equalityMatchingRule("distinguishedNameMatch").syntax("1.3.6.1.4.1.1466.115.121.1.12").singleValue(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.18.1").names("createTimestamp").equalityMatchingRule("generalizedTimeMatch").orderingMatchingRule("generalizedTimeOrderingMatch").syntax("1.3.6.1.4.1.1466.115.121.1.24").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.18.2").names("modifyTimestamp").equalityMatchingRule("generalizedTimeMatch").orderingMatchingRule("generalizedTimeOrderingMatch").syntax("1.3.6.1.4.1.1466.115.121.1.24").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.18.3").names("creatorsName").equalityMatchingRule("distinguishedNameMatch").syntax("1.3.6.1.4.1.1466.115.121.1.12").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.18.4").names("modifiersName").equalityMatchingRule("distinguishedNameMatch").syntax("1.3.6.1.4.1.1466.115.121.1.12").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.18.10").names("subschemaSubentry").equalityMatchingRule("distinguishedNameMatch").syntax("1.3.6.1.4.1.1466.115.121.1.12").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.5").names("attributeTypes").equalityMatchingRule("objectIdentifierFirstComponentMatch").syntax("1.3.6.1.4.1.1466.115.121.1.3").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.6").names("objectClasses").equalityMatchingRule("objectIdentifierFirstComponentMatch").syntax("1.3.6.1.4.1.1466.115.121.1.37").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.4").names("matchingRules").equalityMatchingRule("objectIdentifierFirstComponentMatch").syntax("1.3.6.1.4.1.1466.115.121.1.30").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.8").names("matchingRuleUse").equalityMatchingRule("objectIdentifierFirstComponentMatch").syntax("1.3.6.1.4.1.1466.115.121.1.31").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.9").names("structuralObjectClass").equalityMatchingRule("objectIdentifierMatch").syntax("1.3.6.1.4.1.1466.115.121.1.38").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.10").names("governingStructureRule").equalityMatchingRule("integerMatch").syntax("1.3.6.1.4.1.1466.115.121.1.27").singleValue(true).noUserModification(true).usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.1466.101.120.5").names("namingContexts").syntax("1.3.6.1.4.1.1466.115.121.1.12").usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.1466.101.120.6").names("altServer").syntax("1.3.6.1.4.1.1466.115.121.1.26").usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.1466.101.120.7").names("supportedExtension").syntax("1.3.6.1.4.1.1466.115.121.1.38").usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.1466.101.120.13").names("supportedControl").syntax("1.3.6.1.4.1.1466.115.121.1.38").usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.1466.101.120.14").names("supportedSASLMechanisms").syntax("1.3.6.1.4.1.1466.115.121.1.15").usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.4203.1.3.5").names("supportedFeatures").equalityMatchingRule("objectIdentifierMatch").syntax("1.3.6.1.4.1.1466.115.121.1.38").usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.1466.101.120.15").names("supportedLDAPVersion").syntax("1.3.6.1.4.1.1466.115.121.1.27").usage(AttributeUsage.DSA_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("1.3.6.1.4.1.1466.101.120.16").names("ldapSyntaxes").equalityMatchingRule("objectIdentifierFirstComponentMatch").syntax("1.3.6.1.4.1.1466.115.121.1.54").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.1").names("ditStructureRules").equalityMatchingRule("integerFirstComponentMatch").syntax("1.3.6.1.4.1.1466.115.121.1.17").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.7").names("nameForms").equalityMatchingRule("objectIdentifierFirstComponentMatch").syntax("1.3.6.1.4.1.1466.115.121.1.35").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((AttributeType.Builder)builder.buildAttributeType("2.5.21.2").names("ditContentRules").equalityMatchingRule("objectIdentifierFirstComponentMatch").syntax("1.3.6.1.4.1.1466.115.121.1.16").usage(AttributeUsage.DIRECTORY_OPERATION).extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
    }

    private static void defaultMatchingRules(SchemaBuilder builder) {
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.16").names("bitStringMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.6").extraProperties((Map)RFC4512_ORIGIN)).implementation(new BitStringEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.13").names("booleanMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.7").extraProperties((Map)RFC4512_ORIGIN)).implementation(new BooleanEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.1466.109.114.1").names("caseExactIA5Match").syntaxOID("1.3.6.1.4.1.1466.115.121.1.26").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseExactIA5EqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.26027.1.4.902").names("caseExactIA5SubstringsMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.58").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseExactIA5SubstringMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.5").names("caseExactMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseExactEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.6").names("caseExactOrderingMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseExactOrderingMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.7").names("caseExactSubstringsMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.58").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseExactSubstringMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.1466.109.114.2").names("caseIgnoreIA5Match").syntaxOID("1.3.6.1.4.1.1466.115.121.1.26").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseIgnoreIA5EqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("1.3.6.1.4.1.1466.109.114.3").names("caseIgnoreIA5SubstringsMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.58").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseIgnoreIA5SubstringMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.11").names("caseIgnoreListMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.41").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseIgnoreListEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.12").names("caseIgnoreListSubstringsMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.58").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseIgnoreListSubstringMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.2").names("caseIgnoreMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseIgnoreEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.3").names("caseIgnoreOrderingMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseIgnoreOrderingMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.4").names("caseIgnoreSubstringsMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.58").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CaseIgnoreSubstringMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.31").names(Collections.singletonList("directoryStringFirstComponentMatch")).syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)RFC4512_ORIGIN)).implementation(new DirectoryStringFirstComponentEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.1").names("distinguishedNameMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.12").extraProperties((Map)RFC4512_ORIGIN)).implementation(new DistinguishedNameEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.27").names("generalizedTimeMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.24").extraProperties((Map)RFC4512_ORIGIN)).implementation(new GeneralizedTimeEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.28").names("generalizedTimeOrderingMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.24").extraProperties((Map)RFC4512_ORIGIN)).implementation(new GeneralizedTimeOrderingMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.29").names("integerFirstComponentMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.27").extraProperties((Map)RFC4512_ORIGIN)).implementation(new IntegerFirstComponentEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.14").names("integerMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.27").extraProperties((Map)RFC4512_ORIGIN)).implementation(new IntegerEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.15").names("integerOrderingMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.27").extraProperties((Map)RFC4512_ORIGIN)).implementation(new IntegerOrderingMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.33").names("keywordMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)RFC4512_ORIGIN)).implementation(new KeywordEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.8").names("numericStringMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.36").extraProperties((Map)RFC4512_ORIGIN)).implementation(new NumericStringEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.9").names("numericStringOrderingMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.36").extraProperties((Map)RFC4512_ORIGIN)).implementation(new NumericStringOrderingMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.10").names("numericStringSubstringsMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.58").extraProperties((Map)RFC4512_ORIGIN)).implementation(new NumericStringSubstringMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.30").names("objectIdentifierFirstComponentMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.38").extraProperties((Map)RFC4512_ORIGIN)).implementation(new ObjectIdentifierFirstComponentEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.0").names("objectIdentifierMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.38").extraProperties((Map)RFC4512_ORIGIN)).implementation(new ObjectIdentifierEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.17").names("octetStringMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.40").extraProperties((Map)RFC4512_ORIGIN)).implementation(new OctetStringEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.18").names("octetStringOrderingMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.40").extraProperties((Map)RFC4512_ORIGIN)).implementation(new OctetStringOrderingMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.19").names("octetStringSubstringsMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.40").extraProperties((Map)X500_ORIGIN)).implementation(new OctetStringSubstringMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.24").names("protocolInformationMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.42").extraProperties((Map)RFC2252_ORIGIN)).implementation(new ProtocolInformationEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.22").names("presentationAddressMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.43").extraProperties((Map)RFC2252_ORIGIN)).implementation(new PresentationAddressEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.20").names("telephoneNumberMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.50").extraProperties((Map)RFC2252_ORIGIN)).implementation(new TelephoneNumberEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.21").names("telephoneNumberSubstringsMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.58").extraProperties((Map)RFC4512_ORIGIN)).implementation(new TelephoneNumberSubstringMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.23").names("uniqueMemberMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.34").extraProperties((Map)RFC4512_ORIGIN)).implementation(new UniqueMemberEqualityMatchingRuleImpl()).addToSchema();
        ((MatchingRule.Builder)builder.buildMatchingRule("2.5.13.32").names("wordMatch").syntaxOID("1.3.6.1.4.1.1466.115.121.1.15").extraProperties((Map)RFC4512_ORIGIN)).implementation(new KeywordEqualityMatchingRuleImpl()).addToSchema();
    }

    private static void defaultObjectClasses(SchemaBuilder builder) {
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.0").names("top").type(ObjectClassType.ABSTRACT).description("Topmost ObjectClass").requiredAttributes("objectClass").extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.6.1").names("alias").superiorObjectClasses("top").requiredAttributes("aliasedObjectName").extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("1.3.6.1.4.1.1466.101.120.111").names("extensibleObject").type(ObjectClassType.AUXILIARY).superiorObjectClasses("top").extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
        ((ObjectClass.Builder)builder.buildObjectClass("2.5.20.1").names("subschema").type(ObjectClassType.AUXILIARY).superiorObjectClasses("top").optionalAttributes("dITStructureRules", "nameForms", "ditContentRules", "objectClasses", "attributeTypes", "matchingRules", "matchingRuleUse").extraProperties((Map)RFC4512_ORIGIN)).addToSchema();
    }

    private static void defaultSyntaxes(SchemaBuilder builder) {
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.3").description("Attribute Type Description").extraProperties((Map)RFC4512_ORIGIN)).implementation(new AttributeTypeSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.5").description("Binary").extraProperties((Map)RFC4512_ORIGIN)).implementation(new BinarySyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.6").description("Bit String").extraProperties((Map)RFC4512_ORIGIN)).implementation(new BitStringSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.7").description("Boolean").extraProperties((Map)RFC4512_ORIGIN)).implementation(new BooleanSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.11").description("Country String").extraProperties((Map)RFC4512_ORIGIN)).implementation(new CountryStringSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.14").description("Delivery Method").extraProperties((Map)RFC4512_ORIGIN)).implementation(new DeliveryMethodSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.15").description("Directory String").extraProperties((Map)RFC4512_ORIGIN)).implementation(new DirectoryStringSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.16").description("DIT Content Rule Description").extraProperties((Map)RFC4512_ORIGIN)).implementation(new DITContentRuleSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.17").description("DIT Structure Rule Description").extraProperties((Map)RFC4512_ORIGIN)).implementation(new DITStructureRuleSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.12").description("DN").extraProperties((Map)RFC4512_ORIGIN)).implementation(new DistinguishedNameSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.21").description("Enhanced Guide").extraProperties((Map)RFC4512_ORIGIN)).implementation(new EnhancedGuideSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.22").description("Facsimile Telephone Number").extraProperties((Map)RFC4512_ORIGIN)).implementation(new FacsimileNumberSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.23").description("Fax").extraProperties((Map)RFC4512_ORIGIN)).implementation(new FaxSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.24").description("Generalized Time").extraProperties((Map)RFC4512_ORIGIN)).implementation(new GeneralizedTimeSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.25").description("Guide").extraProperties((Map)RFC4512_ORIGIN)).implementation(new GuideSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.26").description("IA5 String").extraProperties((Map)RFC4512_ORIGIN)).implementation(new IA5StringSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.27").description("Integer").extraProperties((Map)RFC4512_ORIGIN)).implementation(new IntegerSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.28").description("JPEG").extraProperties((Map)RFC4512_ORIGIN)).implementation(new JPEGSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.30").description("Matching Rule Description").extraProperties((Map)RFC4512_ORIGIN)).implementation(new MatchingRuleSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.31").description("Matching Rule Use Description").extraProperties((Map)RFC4512_ORIGIN)).implementation(new MatchingRuleUseSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.54").description("LDAP Syntax Description").extraProperties((Map)RFC4512_ORIGIN)).implementation(new LDAPSyntaxDescriptionSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.34").description("Name and Optional UID").extraProperties((Map)RFC4517_ORIGIN)).implementation(new NameAndOptionalUIDSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.35").description("Name Form Description").extraProperties((Map)RFC4512_ORIGIN)).implementation(new NameFormSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.36").description("Numeric String").extraProperties((Map)RFC4512_ORIGIN)).implementation(new NumericStringSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.37").description("Object Class Description").extraProperties((Map)RFC4512_ORIGIN)).implementation(new ObjectClassSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.40").description("Octet String").extraProperties((Map)RFC4512_ORIGIN)).implementation(new OctetStringSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.38").description("OID").extraProperties((Map)RFC4512_ORIGIN)).implementation(new OIDSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.39").description("Other Mailbox").extraProperties((Map)RFC4512_ORIGIN)).implementation(new OtherMailboxSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.41").description("Postal Address").extraProperties((Map)RFC4512_ORIGIN)).implementation(new PostalAddressSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.43").description("Presentation Address").extraProperties((Map)RFC2252_ORIGIN)).implementation(new PresentationAddressSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.44").description("Printable String").extraProperties((Map)RFC4512_ORIGIN)).implementation(new PrintableStringSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.42").description("Protocol Information").extraProperties((Map)RFC2252_ORIGIN)).implementation(new ProtocolInformationSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.58").description("Substring Assertion").extraProperties((Map)RFC4512_ORIGIN)).implementation(new SubstringAssertionSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.50").description("Telephone Number").extraProperties((Map)RFC4512_ORIGIN)).implementation(new TelephoneNumberSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.51").description("Teletex Terminal Identifier").extraProperties((Map)RFC4512_ORIGIN)).implementation(new TeletexTerminalIdentifierSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.52").description("Telex Number").extraProperties((Map)RFC4512_ORIGIN)).implementation(new TelexNumberSyntaxImpl()).addToSchema();
        ((Syntax.Builder)builder.buildSyntax("1.3.6.1.4.1.1466.115.121.1.53").description("UTC Time").extraProperties((Map)RFC4512_ORIGIN)).implementation(new UTCTimeSyntaxImpl()).addToSchema();
    }

    private CoreSchemaImpl() {
    }

    static {
        JVM_SUPPORTED_LOCALE_NAMES_TO_OIDS = CoreSchemaSupportedLocales.getJvmSupportedLocaleNamesToOids();
        SchemaBuilder builder = new SchemaBuilder("Core Schema");
        CoreSchemaImpl.defaultSyntaxes(builder);
        CoreSchemaImpl.defaultMatchingRules(builder);
        CoreSchemaImpl.defaultAttributeTypes(builder);
        CoreSchemaImpl.defaultObjectClasses(builder);
        CoreSchemaImpl.addRFC4519(builder);
        CoreSchemaImpl.addRFC4523(builder);
        CoreSchemaImpl.addRFC4530(builder);
        CoreSchemaImpl.addRFC3045(builder);
        CoreSchemaImpl.addRFC3112(builder);
        CoreSchemaImpl.addRFC5020(builder);
        CoreSchemaImpl.addSunProprietary(builder);
        CoreSchemaImpl.addForgeRockProprietary(builder);
        SINGLETON = builder.toSchema().asNonStrictSchema();
    }
}

