/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaConstants;

final class BooleanEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    BooleanEqualityMatchingRuleImpl() {
        super("booleanMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String valueString = value.toString().toUpperCase();
        if ("TRUE".equals(valueString) || "YES".equals(valueString) || "ON".equals(valueString) || "1".equals(valueString)) {
            return SchemaConstants.TRUE_VALUE;
        }
        if ("FALSE".equals(valueString) || "NO".equals(valueString) || "OFF".equals(valueString) || "0".equals(valueString)) {
            return SchemaConstants.FALSE_VALUE;
        }
        throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get((Object)value.toString()));
    }
}

