/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DNPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectOption;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.RootDSEBackendCfgClient;
import org.forgerock.opendj.server.config.server.RootDSEBackendCfg;

public final class RootDSEBackendCfgDefn
extends ManagedObjectDefinition<RootDSEBackendCfgClient, RootDSEBackendCfg> {
    private static final RootDSEBackendCfgDefn INSTANCE = new RootDSEBackendCfgDefn();
    private static final BooleanPropertyDefinition PD_SHOW_ALL_ATTRIBUTES;
    private static final DNPropertyDefinition PD_SUBORDINATE_BASE_DN;

    public static RootDSEBackendCfgDefn getInstance() {
        return INSTANCE;
    }

    private RootDSEBackendCfgDefn() {
        super("root-dse-backend", TopCfgDefn.getInstance());
    }

    @Override
    public RootDSEBackendCfgClient createClientConfiguration(ManagedObject<? extends RootDSEBackendCfgClient> impl) {
        return new RootDSEBackendCfgClientImpl(impl);
    }

    @Override
    public RootDSEBackendCfg createServerConfiguration(ServerManagedObject<? extends RootDSEBackendCfg> impl) {
        return new RootDSEBackendCfgServerImpl(impl);
    }

    @Override
    public Class<RootDSEBackendCfg> getServerConfigurationClass() {
        return RootDSEBackendCfg.class;
    }

    public BooleanPropertyDefinition getShowAllAttributesPropertyDefinition() {
        return PD_SHOW_ALL_ATTRIBUTES;
    }

    public DNPropertyDefinition getSubordinateBaseDNPropertyDefinition() {
        return PD_SUBORDINATE_BASE_DN;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "show-all-attributes");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "show-all-attributes"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_SHOW_ALL_ATTRIBUTES = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SHOW_ALL_ATTRIBUTES);
        builder = DNPropertyDefinition.createBuilder(INSTANCE, "subordinate-base-dn");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "subordinate-base-dn"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "subordinate-base-dn"));
        PD_SUBORDINATE_BASE_DN = (DNPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SUBORDINATE_BASE_DN);
        INSTANCE.registerOption(ManagedObjectOption.ADVANCED);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
        INSTANCE.registerTag(Tag.valueOf("database"));
    }

    private static class RootDSEBackendCfgServerImpl
    implements RootDSEBackendCfg {
        private ServerManagedObject<? extends RootDSEBackendCfg> impl;
        private final boolean pShowAllAttributes;
        private final SortedSet<DN> pSubordinateBaseDN;

        private RootDSEBackendCfgServerImpl(ServerManagedObject<? extends RootDSEBackendCfg> impl) {
            this.impl = impl;
            this.pShowAllAttributes = impl.getPropertyValue(INSTANCE.getShowAllAttributesPropertyDefinition());
            this.pSubordinateBaseDN = impl.getPropertyValues((PropertyDefinition)INSTANCE.getSubordinateBaseDNPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<RootDSEBackendCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<RootDSEBackendCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isShowAllAttributes() {
            return this.pShowAllAttributes;
        }

        @Override
        public SortedSet<DN> getSubordinateBaseDN() {
            return this.pSubordinateBaseDN;
        }

        @Override
        public Class<? extends RootDSEBackendCfg> configurationClass() {
            return RootDSEBackendCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class RootDSEBackendCfgClientImpl
    implements RootDSEBackendCfgClient {
        private ManagedObject<? extends RootDSEBackendCfgClient> impl;

        private RootDSEBackendCfgClientImpl(ManagedObject<? extends RootDSEBackendCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isShowAllAttributes() {
            return this.impl.getPropertyValue(INSTANCE.getShowAllAttributesPropertyDefinition());
        }

        @Override
        public void setShowAllAttributes(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getShowAllAttributesPropertyDefinition(), value);
        }

        @Override
        public SortedSet<DN> getSubordinateBaseDN() {
            return this.impl.getPropertyValues(INSTANCE.getSubordinateBaseDNPropertyDefinition());
        }

        @Override
        public void setSubordinateBaseDN(Collection<DN> values) {
            this.impl.setPropertyValues(INSTANCE.getSubordinateBaseDNPropertyDefinition(), values);
        }

        @Override
        public ManagedObjectDefinition<? extends RootDSEBackendCfgClient, ? extends RootDSEBackendCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

