/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.IntegerPropertyDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.TopCfgDefn;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.DebugTargetCfgClient;
import org.forgerock.opendj.server.config.server.DebugTargetCfg;

public final class DebugTargetCfgDefn
extends ManagedObjectDefinition<DebugTargetCfgClient, DebugTargetCfg> {
    private static final DebugTargetCfgDefn INSTANCE = new DebugTargetCfgDefn();
    private static final BooleanPropertyDefinition PD_DEBUG_EXCEPTIONS_ONLY;
    private static final StringPropertyDefinition PD_DEBUG_SCOPE;
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final BooleanPropertyDefinition PD_INCLUDE_THROWABLE_CAUSE;
    private static final BooleanPropertyDefinition PD_OMIT_METHOD_ENTRY_ARGUMENTS;
    private static final BooleanPropertyDefinition PD_OMIT_METHOD_RETURN_VALUE;
    private static final IntegerPropertyDefinition PD_THROWABLE_STACK_FRAMES;

    public static DebugTargetCfgDefn getInstance() {
        return INSTANCE;
    }

    private DebugTargetCfgDefn() {
        super("debug-target", TopCfgDefn.getInstance());
    }

    @Override
    public DebugTargetCfgClient createClientConfiguration(ManagedObject<? extends DebugTargetCfgClient> impl) {
        return new DebugTargetCfgClientImpl(impl);
    }

    @Override
    public DebugTargetCfg createServerConfiguration(ServerManagedObject<? extends DebugTargetCfg> impl) {
        return new DebugTargetCfgServerImpl(impl);
    }

    @Override
    public Class<DebugTargetCfg> getServerConfigurationClass() {
        return DebugTargetCfg.class;
    }

    public BooleanPropertyDefinition getDebugExceptionsOnlyPropertyDefinition() {
        return PD_DEBUG_EXCEPTIONS_ONLY;
    }

    public StringPropertyDefinition getDebugScopePropertyDefinition() {
        return PD_DEBUG_SCOPE;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public BooleanPropertyDefinition getIncludeThrowableCausePropertyDefinition() {
        return PD_INCLUDE_THROWABLE_CAUSE;
    }

    public BooleanPropertyDefinition getOmitMethodEntryArgumentsPropertyDefinition() {
        return PD_OMIT_METHOD_ENTRY_ARGUMENTS;
    }

    public BooleanPropertyDefinition getOmitMethodReturnValuePropertyDefinition() {
        return PD_OMIT_METHOD_RETURN_VALUE;
    }

    public IntegerPropertyDefinition getThrowableStackFramesPropertyDefinition() {
        return PD_THROWABLE_STACK_FRAMES;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "debug-exceptions-only");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "debug-exceptions-only"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_DEBUG_EXCEPTIONS_ONLY = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEBUG_EXCEPTIONS_ONLY);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "debug-scope");
        builder.setOption(PropertyOption.READ_ONLY);
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "debug-scope"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern("^([A-Za-z][A-Za-z0-9_]*\\.)*[A-Za-z][A-Za-z0-9_]*(#[A-Za-z][A-Za-z0-9_]*)?$", "STRING");
        PD_DEBUG_SCOPE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_DEBUG_SCOPE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "include-throwable-cause");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "include-throwable-cause"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_INCLUDE_THROWABLE_CAUSE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_INCLUDE_THROWABLE_CAUSE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "omit-method-entry-arguments");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "omit-method-entry-arguments"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_OMIT_METHOD_ENTRY_ARGUMENTS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_OMIT_METHOD_ENTRY_ARGUMENTS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "omit-method-return-value");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "omit-method-return-value"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_OMIT_METHOD_RETURN_VALUE = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_OMIT_METHOD_RETURN_VALUE);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "throwable-stack-frames");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "throwable-stack-frames"));
        provider = new DefinedDefaultBehaviorProvider("0");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(0);
        PD_THROWABLE_STACK_FRAMES = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_THROWABLE_STACK_FRAMES);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    private static class DebugTargetCfgServerImpl
    implements DebugTargetCfg {
        private ServerManagedObject<? extends DebugTargetCfg> impl;
        private final boolean pDebugExceptionsOnly;
        private final String pDebugScope;
        private final boolean pEnabled;
        private final boolean pIncludeThrowableCause;
        private final boolean pOmitMethodEntryArguments;
        private final boolean pOmitMethodReturnValue;
        private final int pThrowableStackFrames;

        private DebugTargetCfgServerImpl(ServerManagedObject<? extends DebugTargetCfg> impl) {
            this.impl = impl;
            this.pDebugExceptionsOnly = impl.getPropertyValue(INSTANCE.getDebugExceptionsOnlyPropertyDefinition());
            this.pDebugScope = impl.getPropertyValue(INSTANCE.getDebugScopePropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pIncludeThrowableCause = impl.getPropertyValue(INSTANCE.getIncludeThrowableCausePropertyDefinition());
            this.pOmitMethodEntryArguments = impl.getPropertyValue(INSTANCE.getOmitMethodEntryArgumentsPropertyDefinition());
            this.pOmitMethodReturnValue = impl.getPropertyValue(INSTANCE.getOmitMethodReturnValuePropertyDefinition());
            this.pThrowableStackFrames = impl.getPropertyValue(INSTANCE.getThrowableStackFramesPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<DebugTargetCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<DebugTargetCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isDebugExceptionsOnly() {
            return this.pDebugExceptionsOnly;
        }

        @Override
        public String getDebugScope() {
            return this.pDebugScope;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public boolean isIncludeThrowableCause() {
            return this.pIncludeThrowableCause;
        }

        @Override
        public boolean isOmitMethodEntryArguments() {
            return this.pOmitMethodEntryArguments;
        }

        @Override
        public boolean isOmitMethodReturnValue() {
            return this.pOmitMethodReturnValue;
        }

        @Override
        public int getThrowableStackFrames() {
            return this.pThrowableStackFrames;
        }

        @Override
        public Class<? extends DebugTargetCfg> configurationClass() {
            return DebugTargetCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class DebugTargetCfgClientImpl
    implements DebugTargetCfgClient {
        private ManagedObject<? extends DebugTargetCfgClient> impl;

        private DebugTargetCfgClientImpl(ManagedObject<? extends DebugTargetCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isDebugExceptionsOnly() {
            return this.impl.getPropertyValue(INSTANCE.getDebugExceptionsOnlyPropertyDefinition());
        }

        @Override
        public void setDebugExceptionsOnly(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getDebugExceptionsOnlyPropertyDefinition(), value);
        }

        @Override
        public String getDebugScope() {
            return this.impl.getPropertyValue(INSTANCE.getDebugScopePropertyDefinition());
        }

        @Override
        public void setDebugScope(String value) throws PropertyException {
            this.impl.setPropertyValue(INSTANCE.getDebugScopePropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public boolean isIncludeThrowableCause() {
            return this.impl.getPropertyValue(INSTANCE.getIncludeThrowableCausePropertyDefinition());
        }

        @Override
        public void setIncludeThrowableCause(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getIncludeThrowableCausePropertyDefinition(), value);
        }

        @Override
        public boolean isOmitMethodEntryArguments() {
            return this.impl.getPropertyValue(INSTANCE.getOmitMethodEntryArgumentsPropertyDefinition());
        }

        @Override
        public void setOmitMethodEntryArguments(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getOmitMethodEntryArgumentsPropertyDefinition(), value);
        }

        @Override
        public boolean isOmitMethodReturnValue() {
            return this.impl.getPropertyValue(INSTANCE.getOmitMethodReturnValuePropertyDefinition());
        }

        @Override
        public void setOmitMethodReturnValue(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getOmitMethodReturnValuePropertyDefinition(), value);
        }

        @Override
        public int getThrowableStackFrames() {
            return this.impl.getPropertyValue(INSTANCE.getThrowableStackFramesPropertyDefinition());
        }

        @Override
        public void setThrowableStackFrames(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getThrowableStackFramesPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends DebugTargetCfgClient, ? extends DebugTargetCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

