/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.config.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.ClassPropertyDefinition;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.DurationPropertyDefinition;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.GenericConstraint;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectAlreadyExistsException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyProvider;
import org.forgerock.opendj.config.StringPropertyDefinition;
import org.forgerock.opendj.config.Tag;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.IllegalManagedObjectNameException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.MissingMandatoryPropertiesException;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationAddListener;
import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.client.AccessLogFilteringCriteriaCfgClient;
import org.forgerock.opendj.server.config.client.CsvFileAccessLogPublisherCfgClient;
import org.forgerock.opendj.server.config.client.LogRetentionPolicyCfgClient;
import org.forgerock.opendj.server.config.client.LogRotationPolicyCfgClient;
import org.forgerock.opendj.server.config.meta.AccessLogPublisherCfgDefn;
import org.forgerock.opendj.server.config.server.AccessLogFilteringCriteriaCfg;
import org.forgerock.opendj.server.config.server.AccessLogPublisherCfg;
import org.forgerock.opendj.server.config.server.CsvFileAccessLogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogPublisherCfg;
import org.forgerock.opendj.server.config.server.LogRetentionPolicyCfg;
import org.forgerock.opendj.server.config.server.LogRotationPolicyCfg;

public final class CsvFileAccessLogPublisherCfgDefn
extends ManagedObjectDefinition<CsvFileAccessLogPublisherCfgClient, CsvFileAccessLogPublisherCfg> {
    private static final CsvFileAccessLogPublisherCfgDefn INSTANCE = new CsvFileAccessLogPublisherCfgDefn();
    private static final BooleanPropertyDefinition PD_ASYNCHRONOUS;
    private static final BooleanPropertyDefinition PD_AUTO_FLUSH;
    private static final StringPropertyDefinition PD_CSV_DELIMITER_CHAR;
    private static final StringPropertyDefinition PD_CSV_EOL_SYMBOLS;
    private static final StringPropertyDefinition PD_CSV_QUOTE_CHAR;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_KEY_STORE_FILE;
    private static final StringPropertyDefinition PD_KEY_STORE_PIN_FILE;
    private static final BooleanPropertyDefinition PD_LOG_CONTROL_OIDS;
    private static final StringPropertyDefinition PD_LOG_DIRECTORY;
    private static final AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> PD_RETENTION_POLICY;
    private static final AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> PD_ROTATION_POLICY;
    private static final DurationPropertyDefinition PD_SIGNATURE_TIME_INTERVAL;
    private static final BooleanPropertyDefinition PD_TAMPER_EVIDENT;

    public static CsvFileAccessLogPublisherCfgDefn getInstance() {
        return INSTANCE;
    }

    private CsvFileAccessLogPublisherCfgDefn() {
        super("csv-file-access-log-publisher", AccessLogPublisherCfgDefn.getInstance());
    }

    @Override
    public CsvFileAccessLogPublisherCfgClient createClientConfiguration(ManagedObject<? extends CsvFileAccessLogPublisherCfgClient> impl) {
        return new CsvFileAccessLogPublisherCfgClientImpl(impl);
    }

    @Override
    public CsvFileAccessLogPublisherCfg createServerConfiguration(ServerManagedObject<? extends CsvFileAccessLogPublisherCfg> impl) {
        return new CsvFileAccessLogPublisherCfgServerImpl(impl);
    }

    @Override
    public Class<CsvFileAccessLogPublisherCfg> getServerConfigurationClass() {
        return CsvFileAccessLogPublisherCfg.class;
    }

    public BooleanPropertyDefinition getAsynchronousPropertyDefinition() {
        return PD_ASYNCHRONOUS;
    }

    public BooleanPropertyDefinition getAutoFlushPropertyDefinition() {
        return PD_AUTO_FLUSH;
    }

    public StringPropertyDefinition getCsvDelimiterCharPropertyDefinition() {
        return PD_CSV_DELIMITER_CHAR;
    }

    public StringPropertyDefinition getCsvEolSymbolsPropertyDefinition() {
        return PD_CSV_EOL_SYMBOLS;
    }

    public StringPropertyDefinition getCsvQuoteCharPropertyDefinition() {
        return PD_CSV_QUOTE_CHAR;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public EnumPropertyDefinition<AccessLogPublisherCfgDefn.FilteringPolicy> getFilteringPolicyPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getFilteringPolicyPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getKeyStoreFilePropertyDefinition() {
        return PD_KEY_STORE_FILE;
    }

    public StringPropertyDefinition getKeyStorePinFilePropertyDefinition() {
        return PD_KEY_STORE_PIN_FILE;
    }

    public BooleanPropertyDefinition getLogControlOidsPropertyDefinition() {
        return PD_LOG_CONTROL_OIDS;
    }

    public StringPropertyDefinition getLogDirectoryPropertyDefinition() {
        return PD_LOG_DIRECTORY;
    }

    public AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> getRetentionPolicyPropertyDefinition() {
        return PD_RETENTION_POLICY;
    }

    public AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> getRotationPolicyPropertyDefinition() {
        return PD_ROTATION_POLICY;
    }

    public DurationPropertyDefinition getSignatureTimeIntervalPropertyDefinition() {
        return PD_SIGNATURE_TIME_INTERVAL;
    }

    public BooleanPropertyDefinition getSuppressInternalOperationsPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getSuppressInternalOperationsPropertyDefinition();
    }

    public BooleanPropertyDefinition getSuppressSynchronizationOperationsPropertyDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getSuppressSynchronizationOperationsPropertyDefinition();
    }

    public BooleanPropertyDefinition getTamperEvidentPropertyDefinition() {
        return PD_TAMPER_EVIDENT;
    }

    public InstantiableRelationDefinition<AccessLogFilteringCriteriaCfgClient, AccessLogFilteringCriteriaCfg> getAccessLogFilteringCriteriaRelationDefinition() {
        return AccessLogPublisherCfgDefn.getInstance().getAccessLogFilteringCriteriaRelationDefinition();
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "asynchronous");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "asynchronous"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_ASYNCHRONOUS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ASYNCHRONOUS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "auto-flush");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "auto-flush"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_AUTO_FLUSH = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_AUTO_FLUSH);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "csv-delimiter-char");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "csv-delimiter-char"));
        provider = new DefinedDefaultBehaviorProvider(",");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "DELIMITER CHARACTER");
        PD_CSV_DELIMITER_CHAR = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CSV_DELIMITER_CHAR);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "csv-eol-symbols");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "csv-eol-symbols"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "csv-eol-symbols"));
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "STRING");
        PD_CSV_EOL_SYMBOLS = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CSV_EOL_SYMBOLS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "csv-quote-char");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "csv-quote-char"));
        provider = new DefinedDefaultBehaviorProvider("\"");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "QUOTE CHARACTER");
        PD_CSV_QUOTE_CHAR = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_CSV_QUOTE_CHAR);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.CsvFileAccessLogPublisher");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.loggers.LogPublisher");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FILE");
        PD_KEY_STORE_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "key-store-pin-file");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "key-store-pin-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "FILE");
        PD_KEY_STORE_PIN_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_KEY_STORE_PIN_FILE);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "log-control-oids");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-control-oids"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_LOG_CONTROL_OIDS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_CONTROL_OIDS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-directory");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "log-directory"));
        provider = new DefinedDefaultBehaviorProvider("logs");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern(".*", "DIRECTORY");
        PD_LOG_DIRECTORY = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_DIRECTORY);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "retention-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "retention-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "retention-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-retention-policy");
        PD_RETENTION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RETENTION_POLICY);
        INSTANCE.registerConstraint(PD_RETENTION_POLICY.getSourceConstraint());
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "rotation-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "rotation-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "rotation-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-rotation-policy");
        PD_ROTATION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ROTATION_POLICY);
        INSTANCE.registerConstraint(PD_ROTATION_POLICY.getSourceConstraint());
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "signature-time-interval");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "signature-time-interval"));
        provider = new DefinedDefaultBehaviorProvider("3s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_SIGNATURE_TIME_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_SIGNATURE_TIME_INTERVAL);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "tamper-evident");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "tamper-evident"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_TAMPER_EVIDENT = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TAMPER_EVIDENT);
        INSTANCE.registerTag(Tag.valueOf("logging"));
        INSTANCE.registerConstraint(new GenericConstraint(INSTANCE, 1, Conditions.implies(Conditions.and(Conditions.contains("enabled", "true"), Conditions.contains("tamper-evident", "true")), Conditions.and(Conditions.isPresent("key-store-file"), Conditions.isPresent("key-store-pin-file")))));
    }

    private static class CsvFileAccessLogPublisherCfgServerImpl
    implements CsvFileAccessLogPublisherCfg {
        private ServerManagedObject<? extends CsvFileAccessLogPublisherCfg> impl;
        private final boolean pAsynchronous;
        private final boolean pAutoFlush;
        private final String pCsvDelimiterChar;
        private final String pCsvEolSymbols;
        private final String pCsvQuoteChar;
        private final boolean pEnabled;
        private final AccessLogPublisherCfgDefn.FilteringPolicy pFilteringPolicy;
        private final String pJavaClass;
        private final String pKeyStoreFile;
        private final String pKeyStorePinFile;
        private final boolean pLogControlOids;
        private final String pLogDirectory;
        private final SortedSet<String> pRetentionPolicy;
        private final SortedSet<String> pRotationPolicy;
        private final long pSignatureTimeInterval;
        private final boolean pSuppressInternalOperations;
        private final boolean pSuppressSynchronizationOperations;
        private final boolean pTamperEvident;

        private CsvFileAccessLogPublisherCfgServerImpl(ServerManagedObject<? extends CsvFileAccessLogPublisherCfg> impl) {
            this.impl = impl;
            this.pAsynchronous = impl.getPropertyValue(INSTANCE.getAsynchronousPropertyDefinition());
            this.pAutoFlush = impl.getPropertyValue(INSTANCE.getAutoFlushPropertyDefinition());
            this.pCsvDelimiterChar = impl.getPropertyValue(INSTANCE.getCsvDelimiterCharPropertyDefinition());
            this.pCsvEolSymbols = impl.getPropertyValue(INSTANCE.getCsvEolSymbolsPropertyDefinition());
            this.pCsvQuoteChar = impl.getPropertyValue(INSTANCE.getCsvQuoteCharPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pFilteringPolicy = impl.getPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pKeyStoreFile = impl.getPropertyValue(INSTANCE.getKeyStoreFilePropertyDefinition());
            this.pKeyStorePinFile = impl.getPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition());
            this.pLogControlOids = impl.getPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition());
            this.pLogDirectory = impl.getPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition());
            this.pRetentionPolicy = impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
            this.pRotationPolicy = impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
            this.pSignatureTimeInterval = impl.getPropertyValue(INSTANCE.getSignatureTimeIntervalPropertyDefinition());
            this.pSuppressInternalOperations = impl.getPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition());
            this.pSuppressSynchronizationOperations = impl.getPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition());
            this.pTamperEvident = impl.getPropertyValue(INSTANCE.getTamperEvidentPropertyDefinition());
        }

        @Override
        public void addCsvFileAccessChangeListener(ConfigurationChangeListener<CsvFileAccessLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeCsvFileAccessChangeListener(ConfigurationChangeListener<CsvFileAccessLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addAccessChangeListener(ConfigurationChangeListener<AccessLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeAccessChangeListener(ConfigurationChangeListener<AccessLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAsynchronous() {
            return this.pAsynchronous;
        }

        @Override
        public boolean isAutoFlush() {
            return this.pAutoFlush;
        }

        @Override
        public String getCsvDelimiterChar() {
            return this.pCsvDelimiterChar;
        }

        @Override
        public String getCsvEolSymbols() {
            return this.pCsvEolSymbols;
        }

        @Override
        public String getCsvQuoteChar() {
            return this.pCsvQuoteChar;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public AccessLogPublisherCfgDefn.FilteringPolicy getFilteringPolicy() {
            return this.pFilteringPolicy;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getKeyStoreFile() {
            return this.pKeyStoreFile;
        }

        @Override
        public String getKeyStorePinFile() {
            return this.pKeyStorePinFile;
        }

        @Override
        public boolean isLogControlOids() {
            return this.pLogControlOids;
        }

        @Override
        public String getLogDirectory() {
            return this.pLogDirectory;
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.pRetentionPolicy;
        }

        @Override
        public SortedSet<DN> getRetentionPolicyDNs() {
            SortedSet<String> values = this.getRetentionPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRetentionPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.pRotationPolicy;
        }

        @Override
        public SortedSet<DN> getRotationPolicyDNs() {
            SortedSet<String> values = this.getRotationPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRotationPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public long getSignatureTimeInterval() {
            return this.pSignatureTimeInterval;
        }

        @Override
        public boolean isSuppressInternalOperations() {
            return this.pSuppressInternalOperations;
        }

        @Override
        public boolean isSuppressSynchronizationOperations() {
            return this.pSuppressSynchronizationOperations;
        }

        @Override
        public boolean isTamperEvident() {
            return this.pTamperEvident;
        }

        @Override
        public String[] listAccessLogFilteringCriteria() {
            return this.impl.listChildren(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition());
        }

        @Override
        public AccessLogFilteringCriteriaCfg getAccessLogFilteringCriteria(String name) throws ConfigException {
            return this.impl.getChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name).getConfiguration();
        }

        @Override
        public void addAccessLogFilteringCriteriaAddListener(ConfigurationAddListener<AccessLogFilteringCriteriaCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void removeAccessLogFilteringCriteriaAddListener(ConfigurationAddListener<AccessLogFilteringCriteriaCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void addAccessLogFilteringCriteriaDeleteListener(ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public void removeAccessLogFilteringCriteriaDeleteListener(ConfigurationDeleteListener<AccessLogFilteringCriteriaCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), listener);
        }

        @Override
        public Class<? extends CsvFileAccessLogPublisherCfg> configurationClass() {
            return CsvFileAccessLogPublisherCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }

        public String toString() {
            return this.impl.toString();
        }
    }

    private static class CsvFileAccessLogPublisherCfgClientImpl
    implements CsvFileAccessLogPublisherCfgClient {
        private ManagedObject<? extends CsvFileAccessLogPublisherCfgClient> impl;

        private CsvFileAccessLogPublisherCfgClientImpl(ManagedObject<? extends CsvFileAccessLogPublisherCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAsynchronous() {
            return this.impl.getPropertyValue(INSTANCE.getAsynchronousPropertyDefinition());
        }

        @Override
        public void setAsynchronous(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAsynchronousPropertyDefinition(), value);
        }

        @Override
        public boolean isAutoFlush() {
            return this.impl.getPropertyValue(INSTANCE.getAutoFlushPropertyDefinition());
        }

        @Override
        public void setAutoFlush(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAutoFlushPropertyDefinition(), value);
        }

        @Override
        public String getCsvDelimiterChar() {
            return this.impl.getPropertyValue(INSTANCE.getCsvDelimiterCharPropertyDefinition());
        }

        @Override
        public void setCsvDelimiterChar(String value) {
            this.impl.setPropertyValue(INSTANCE.getCsvDelimiterCharPropertyDefinition(), value);
        }

        @Override
        public String getCsvEolSymbols() {
            return this.impl.getPropertyValue(INSTANCE.getCsvEolSymbolsPropertyDefinition());
        }

        @Override
        public void setCsvEolSymbols(String value) {
            this.impl.setPropertyValue(INSTANCE.getCsvEolSymbolsPropertyDefinition(), value);
        }

        @Override
        public String getCsvQuoteChar() {
            return this.impl.getPropertyValue(INSTANCE.getCsvQuoteCharPropertyDefinition());
        }

        @Override
        public void setCsvQuoteChar(String value) {
            this.impl.setPropertyValue(INSTANCE.getCsvQuoteCharPropertyDefinition(), value);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public AccessLogPublisherCfgDefn.FilteringPolicy getFilteringPolicy() {
            return this.impl.getPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition());
        }

        @Override
        public void setFilteringPolicy(AccessLogPublisherCfgDefn.FilteringPolicy value) {
            this.impl.setPropertyValue(INSTANCE.getFilteringPolicyPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getKeyStoreFile() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStoreFilePropertyDefinition());
        }

        @Override
        public void setKeyStoreFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStoreFilePropertyDefinition(), value);
        }

        @Override
        public String getKeyStorePinFile() {
            return this.impl.getPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition());
        }

        @Override
        public void setKeyStorePinFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getKeyStorePinFilePropertyDefinition(), value);
        }

        @Override
        public boolean isLogControlOids() {
            return this.impl.getPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition());
        }

        @Override
        public void setLogControlOids(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getLogControlOidsPropertyDefinition(), value);
        }

        @Override
        public String getLogDirectory() {
            return this.impl.getPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition());
        }

        @Override
        public void setLogDirectory(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogDirectoryPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
        }

        @Override
        public void setRetentionPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
        }

        @Override
        public void setRotationPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition(), values);
        }

        @Override
        public long getSignatureTimeInterval() {
            return this.impl.getPropertyValue(INSTANCE.getSignatureTimeIntervalPropertyDefinition());
        }

        @Override
        public void setSignatureTimeInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getSignatureTimeIntervalPropertyDefinition(), value);
        }

        @Override
        public boolean isSuppressInternalOperations() {
            return this.impl.getPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition());
        }

        @Override
        public void setSuppressInternalOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSuppressInternalOperationsPropertyDefinition(), value);
        }

        @Override
        public boolean isSuppressSynchronizationOperations() {
            return this.impl.getPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition());
        }

        @Override
        public void setSuppressSynchronizationOperations(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getSuppressSynchronizationOperationsPropertyDefinition(), value);
        }

        @Override
        public boolean isTamperEvident() {
            return this.impl.getPropertyValue(INSTANCE.getTamperEvidentPropertyDefinition());
        }

        @Override
        public void setTamperEvident(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getTamperEvidentPropertyDefinition(), value);
        }

        @Override
        public String[] listAccessLogFilteringCriteria() throws ConcurrentModificationException, LdapException {
            return this.impl.listChildren(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition());
        }

        @Override
        public AccessLogFilteringCriteriaCfgClient getAccessLogFilteringCriteria(String name) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, LdapException {
            return this.impl.getChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name).getConfiguration();
        }

        public <M extends AccessLogFilteringCriteriaCfgClient> M createAccessLogFilteringCriteria(ManagedObjectDefinition<M, ? extends AccessLogFilteringCriteriaCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException {
            return (M)((AccessLogFilteringCriteriaCfgClient)this.impl.createChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), d, name, exceptions).getConfiguration());
        }

        @Override
        public void removeAccessLogFilteringCriteria(String name) throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.removeChild(INSTANCE.getAccessLogFilteringCriteriaRelationDefinition(), name);
        }

        @Override
        public ManagedObjectDefinition<? extends CsvFileAccessLogPublisherCfgClient, ? extends CsvFileAccessLogPublisherCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, LdapException {
            this.impl.commit();
        }

        public String toString() {
            return this.impl.toString();
        }
    }
}

