/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectOption;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.dsconfig.CLIProfile;
import org.forgerock.opendj.config.dsconfig.DSConfig;
import org.forgerock.opendj.config.dsconfig.LDAPManagementContextFactory;
import org.forgerock.opendj.config.dsconfig.PropertyValuePrinter;
import org.forgerock.opendj.config.dsconfig.SubCommandHandler;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.LdapException;

final class ListSubCommandHandler
extends SubCommandHandler {
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final RelationDefinition<?, ?> relation;
    private final SubCommand subCommand;

    public static ListSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(parser, p, r, r.getPluralName(), r.getUserFriendlyPluralName());
    }

    public static ListSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, SetRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(parser, p, r, r.getPluralName(), r.getUserFriendlyPluralName());
    }

    public static ListSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(parser, p, r, r.getName(), r.getUserFriendlyName());
    }

    private ListSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<?, ?> r, String rname, LocalizableMessage rufn) throws ArgumentException {
        this.path = p;
        this.relation = r;
        this.subCommand = new SubCommand(parser, "list-" + rname, false, 0, 0, null, DsconfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_LIST.get((Object)rufn));
        this.namingArgs = this.createNamingArgs(this.subCommand, this.path, false);
        this.registerPropertyNameArgument(this.subCommand);
        this.registerUnitSizeArgument(this.subCommand);
        this.registerUnitTimeArgument(this.subCommand);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.relation;
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, LDAPManagementContextFactory factory) throws ArgumentException, ClientException {
        MenuResult<ManagedObject<?>> result;
        LocalizableMessage ufn;
        Set<String> propertyNames = this.getPropertyNames();
        this.getCommandBuilder().clearArguments();
        this.updateCommandBuilderWithSubCommand();
        if (propertyNames.isEmpty()) {
            propertyNames = CLIProfile.getInstance().getDefaultListPropertyNames(this.relation);
        }
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(this.getSizeUnit(), this.getTimeUnit(), app.isScriptFriendly());
        List<String> names = this.getNamingArgValues(app, this.namingArgs);
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            ufn = irelation.getUserFriendlyPluralName();
        } else if (this.relation instanceof SetRelationDefinition) {
            SetRelationDefinition srelation = (SetRelationDefinition)this.relation;
            ufn = srelation.getUserFriendlyPluralName();
        } else {
            ufn = this.relation.getUserFriendlyName();
        }
        ManagementContext context = factory.getManagementContext(app);
        try {
            result = this.getManagedObject(app, context, this.path, names);
        }
        catch (AuthorizationException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get((Object)ufn);
            throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
        }
        catch (DefinitionDecodingException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get((Object)ufn, (Object)ufn, (Object)ufn);
            throw new ClientException(ReturnCode.OTHER, msg);
        }
        catch (ManagedObjectDecodingException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get((Object)ufn);
            throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
        }
        catch (ConcurrentModificationException e) {
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_CME.get((Object)ufn);
            throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get((Object)ufn);
            return DSConfig.interactivePrintOrThrowError(app, msg, ReturnCode.NO_SUCH_OBJECT);
        }
        catch (LdapException e) {
            throw new ClientException(ReturnCode.OTHER, LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]));
        }
        if (result.isQuit()) {
            return MenuResult.quit();
        }
        if (result.isCancel()) {
            return MenuResult.cancel();
        }
        ManagedObject parent = (ManagedObject)result.getValue();
        TreeMap children = new TreeMap();
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            try {
                for (String s : parent.listChildren(irelation)) {
                    try {
                        children.put(s, parent.getChild(irelation, s));
                    }
                    catch (ManagedObjectNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            catch (DefinitionDecodingException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_DDE.get((Object)ufn, (Object)ufn, (Object)ufn);
                throw new ClientException(ReturnCode.OTHER, msg);
            }
            catch (ManagedObjectDecodingException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_MODE.get((Object)ufn);
                throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
            }
            catch (AuthorizationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get((Object)ufn);
                throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
            }
            catch (ConcurrentModificationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_CME.get((Object)ufn);
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
            }
            catch (LdapException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_CE.get((Object)ufn, (Object)e.getMessage());
                throw new ClientException(ReturnCode.CLIENT_SIDE_SERVER_DOWN, msg);
            }
        }
        if (this.relation instanceof SetRelationDefinition) {
            SetRelationDefinition srelation = (SetRelationDefinition)this.relation;
            try {
                for (String s : parent.listChildren(srelation)) {
                    try {
                        children.put(s, parent.getChild(srelation, s));
                    }
                    catch (ManagedObjectNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            catch (DefinitionDecodingException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_DDE.get((Object)ufn, (Object)ufn, (Object)ufn);
                throw new ClientException(ReturnCode.OTHER, msg);
            }
            catch (ManagedObjectDecodingException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_MODE.get((Object)ufn);
                throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
            }
            catch (AuthorizationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get((Object)ufn);
                throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
            }
            catch (ConcurrentModificationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_CME.get((Object)ufn);
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
            }
            catch (LdapException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_CE.get((Object)ufn, (Object)e.getMessage());
                throw new ClientException(ReturnCode.CLIENT_SIDE_SERVER_DOWN, msg);
            }
        }
        if (this.relation instanceof OptionalRelationDefinition) {
            OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
            try {
                if (!parent.hasChild(orelation)) {
                    return DSConfig.interactivePrintOrThrowError(app, DsconfigMessages.ERR_DSCFG_ERROR_FINDER_NO_CHILDREN.get((Object)ufn), ReturnCode.NO_SUCH_OBJECT);
                }
                ManagedObject child = parent.getChild(orelation);
                children.put(child.getManagedObjectDefinition().getName(), child);
            }
            catch (AuthorizationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get((Object)ufn);
                throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
            }
            catch (DefinitionDecodingException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_DDE.get((Object)ufn, (Object)ufn, (Object)ufn);
                throw new ClientException(ReturnCode.OTHER, msg);
            }
            catch (ManagedObjectDecodingException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_MODE.get((Object)ufn);
                throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
            }
            catch (ConcurrentModificationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_CME.get((Object)ufn);
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
            }
            catch (LdapException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_CE.get((Object)ufn, (Object)e.getMessage());
                throw new ClientException(ReturnCode.CLIENT_SIDE_SERVER_DOWN, msg);
            }
            catch (ManagedObjectNotFoundException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_LIST_MONFE.get((Object)ufn);
                throw new ClientException(ReturnCode.NO_SUCH_OBJECT, msg);
            }
        }
        if (app.isScriptFriendly()) {
            for (String name : children.keySet()) {
                ManagedObjectDefinition d = ((ManagedObject)children.get(name)).getManagedObjectDefinition();
                if (this.cannotDisplay(app, d)) continue;
                app.println(LocalizableMessage.raw((CharSequence)name, (Object[])new Object[0]));
            }
        } else {
            TablePrinter printer;
            SortedMap<String, ManagedObjectDefinition<?, ?>> subTypes = ListSubCommandHandler.getSubTypes(this.relation.getChildDefinition());
            boolean includeTypesColumn = subTypes.size() != 1 || !subTypes.containsKey("generic");
            TableBuilder builder = new TableBuilder();
            builder.appendHeading(this.relation.getUserFriendlyName());
            if (includeTypesColumn) {
                builder.appendHeading(DsconfigMessages.INFO_DSCFG_HEADING_COMPONENT_TYPE.get());
            }
            for (String propertyName : propertyNames) {
                builder.appendHeading(LocalizableMessage.raw((CharSequence)propertyName, (Object[])new Object[0]));
            }
            builder.addSortKey(0);
            String baseType = this.relation.getChildDefinition().getName();
            String typeSuffix = "-" + baseType;
            for (String name : children.keySet()) {
                ManagedObject child = (ManagedObject)children.get(name);
                ManagedObjectDefinition d = child.getManagedObjectDefinition();
                if (this.cannotDisplay(app, d)) continue;
                builder.startRow();
                if (this.relation instanceof SetRelationDefinition) {
                    builder.appendCell((Object)d.getUserFriendlyName());
                } else {
                    builder.appendCell((Object)name);
                }
                if (includeTypesColumn) {
                    String childType = d.getName();
                    boolean isCustom = CLIProfile.getInstance().isForCustomization(d);
                    if (baseType.equals(childType)) {
                        if (isCustom) {
                            builder.appendCell((Object)"custom");
                        } else {
                            builder.appendCell((Object)"generic");
                        }
                    } else if (childType.endsWith(typeSuffix)) {
                        String ctname = childType.substring(0, childType.length() - typeSuffix.length());
                        if (isCustom) {
                            ctname = String.format("%s-%s", "custom", ctname);
                        }
                        builder.appendCell((Object)ctname);
                    } else {
                        builder.appendCell((Object)childType);
                    }
                }
                for (String propertyName : propertyNames) {
                    try {
                        PropertyDefinition<?> pd = d.getPropertyDefinition(propertyName);
                        this.displayProperty(app, builder, child, pd, valuePrinter);
                    }
                    catch (IllegalArgumentException e) {
                        if (app.isScriptFriendly()) {
                            builder.appendCell();
                            continue;
                        }
                        builder.appendCell((Object)"-");
                    }
                }
            }
            PrintStream out = app.getOutputStream();
            if (app.isScriptFriendly()) {
                printer = this.createScriptFriendlyTablePrinter(out);
                builder.print(printer);
            } else {
                if (app.isInteractive()) {
                    app.println();
                    app.println();
                }
                printer = new TextTablePrinter((OutputStream)out);
                printer.setColumnSeparator(":");
                builder.print(printer);
            }
        }
        return MenuResult.success((Object)0);
    }

    private boolean cannotDisplay(ConsoleApplication app, ManagedObjectDefinition<?, ?> d) {
        return !app.isAdvancedMode() && (d.hasOption(ManagedObjectOption.HIDDEN) || d.hasOption(ManagedObjectOption.ADVANCED));
    }

    private <T> void displayProperty(ConsoleApplication app, TableBuilder builder, ManagedObject<?> mo, PropertyDefinition<T> pd, PropertyValuePrinter valuePrinter) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        if (values.isEmpty()) {
            if (app.isScriptFriendly()) {
                builder.appendCell();
            } else {
                builder.appendCell((Object)"-");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Object value : values) {
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append((CharSequence)valuePrinter.print(pd, value));
                isFirst = false;
            }
            builder.appendCell((Object)sb.toString());
        }
    }
}

