/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.client;

import com.forgerock.opendj.ldap.config.AdminMessages;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.DecodingException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.util.Reject;

public class ManagedObjectDecodingException
extends DecodingException {
    private static final long serialVersionUID = -4268510652395945357L;
    private final Collection<PropertyException> causes;
    private final ManagedObject<?> partialManagedObject;

    private static LocalizableMessage createMessage(ManagedObject<?> partialManagedObject, Collection<PropertyException> causes) {
        Reject.ifNull(causes);
        Reject.ifFalse((!causes.isEmpty() ? 1 : 0) != 0, (String)"causes should not be empty");
        ManagedObjectDefinition<?, Configuration> d = partialManagedObject.getManagedObjectDefinition();
        if (causes.size() == 1) {
            return AdminMessages.ERR_MANAGED_OBJECT_DECODING_EXCEPTION_SINGLE.get((Object)d.getUserFriendlyName(), (Object)causes.iterator().next().getMessageObject());
        }
        LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
        boolean isFirst = true;
        for (PropertyException cause : causes) {
            if (!isFirst) {
                builder.append((CharSequence)"; ");
            }
            builder.append(cause.getMessageObject());
            isFirst = false;
        }
        return AdminMessages.ERR_MANAGED_OBJECT_DECODING_EXCEPTION_PLURAL.get((Object)d.getUserFriendlyName(), (Object)builder.toMessage());
    }

    public ManagedObjectDecodingException(ManagedObject<?> partialManagedObject, Collection<PropertyException> causes) {
        super(ManagedObjectDecodingException.createMessage(partialManagedObject, causes));
        this.partialManagedObject = partialManagedObject;
        this.causes = Collections.unmodifiableList(new LinkedList<PropertyException>(causes));
    }

    public Collection<PropertyException> getCauses() {
        return this.causes;
    }

    public ManagedObject<?> getPartialManagedObject() {
        return this.partialManagedObject;
    }
}

