/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.json;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.audit.AuditException;
import org.forgerock.audit.AuditServiceBuilder;
import org.forgerock.audit.AuditServiceConfiguration;
import org.forgerock.audit.events.handlers.AuditEventHandler;
import org.forgerock.audit.events.handlers.EventHandlerConfiguration;
import org.forgerock.audit.util.JsonValueUtils;
import org.forgerock.json.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditJsonConfig {
    private static final Logger logger = LoggerFactory.getLogger(AuditJsonConfig.class);
    private static final String NAME_FIELD = "name";
    private static final String CLASS_FIELD = "class";
    private static final String CONFIG_FIELD = "config";
    private static final String EVENTS_FIELD = "events";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final AnnotationIntrospector defaultAnnotationIntrospector = new JacksonAnnotationIntrospector();
    private static final AnnotationIntrospector helpAppenderAnnotationIntrospector = new HelpAppenderAnnotationIntrospector();

    private AuditJsonConfig() {
    }

    public static JsonValue getJson(InputStream input) throws AuditException {
        try {
            return new JsonValue(mapper.readValue(input, LinkedHashMap.class));
        }
        catch (IOException e) {
            throw new AuditException(String.format("Unable to retrieve json value from json input stream", new Object[0]), (Throwable)e);
        }
    }

    public static AuditServiceConfiguration parseAuditServiceConfiguration(InputStream input) throws AuditException {
        try {
            return (AuditServiceConfiguration)mapper.readValue(input, AuditServiceConfiguration.class);
        }
        catch (IOException e) {
            throw new AuditException(String.format("Unable to retrieve class %s from json input stream", AuditServiceConfiguration.class), (Throwable)e);
        }
    }

    public static AuditServiceConfiguration parseAuditServiceConfiguration(String json) throws AuditException {
        if (json == null) {
            return new AuditServiceConfiguration();
        }
        try {
            return (AuditServiceConfiguration)mapper.readValue(json, AuditServiceConfiguration.class);
        }
        catch (IOException e) {
            throw new AuditException(String.format("Unable to retrieve class %s from json: %s", AuditServiceConfiguration.class, json), (Throwable)e);
        }
    }

    public static AuditServiceConfiguration parseAuditServiceConfiguration(JsonValue json) throws AuditException {
        return AuditJsonConfig.parseAuditServiceConfiguration(JsonValueUtils.extractValueAsString((JsonValue)json, (String)"/"));
    }

    public static void registerHandlerToService(JsonValue jsonConfig, AuditServiceBuilder auditServiceBuilder) throws AuditException {
        AuditJsonConfig.registerHandlerToService(jsonConfig, auditServiceBuilder, auditServiceBuilder.getClass().getClassLoader());
    }

    public static void registerHandlerToService(JsonValue jsonConfig, AuditServiceBuilder auditServiceBuilder, ClassLoader classLoader) throws AuditException {
        String name = AuditJsonConfig.getHandlerName(jsonConfig);
        Class<? extends AuditEventHandler> handlerClass = AuditJsonConfig.getAuditEventHandlerClass(name, jsonConfig, classLoader);
        Class<? extends EventHandlerConfiguration> configClass = AuditJsonConfig.getAuditEventHandlerConfigurationClass(name, handlerClass, classLoader);
        EventHandlerConfiguration configuration = AuditJsonConfig.parseAuditEventHandlerConfiguration(configClass, jsonConfig);
        auditServiceBuilder.withAuditEventHandler(handlerClass, configuration);
    }

    private static String getHandlerName(JsonValue jsonConfig) throws AuditException {
        String name = jsonConfig.get(CONFIG_FIELD).get(NAME_FIELD).asString();
        if (name == null) {
            throw new AuditException(String.format("No name is defined for the provided audit handler. You must define a 'name' property in the configuration.", new Object[0]));
        }
        return name;
    }

    private static Class<? extends AuditEventHandler> getAuditEventHandlerClass(String handlerName, JsonValue jsonConfig, ClassLoader classLoader) throws AuditException {
        String className = jsonConfig.get(CLASS_FIELD).asString();
        if (className == null) {
            String errorMessage = String.format("No class is defined for the audit handler %s. You must define a 'class' property in the configuration.", handlerName);
            throw new AuditException(errorMessage);
        }
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            String errorMessage = String.format("Invalid class is defined for the audit handler %s.", handlerName);
            throw new AuditException(errorMessage, (Throwable)e);
        }
    }

    private static Class<? extends EventHandlerConfiguration> getAuditEventHandlerConfigurationClass(String handlerName, Class<? extends AuditEventHandler> handlerClass, ClassLoader classLoader) throws AuditException {
        String className = handlerClass.getName() + "Configuration";
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            String errorMessage = String.format("Unable to locate configuration class %s for the audit handler %s.", className, handlerName);
            throw new AuditException(errorMessage, (Throwable)e);
        }
    }

    private static <C extends EventHandlerConfiguration> C parseAuditEventHandlerConfiguration(Class<C> clazz, JsonValue jsonConfig) throws AuditException {
        EventHandlerConfiguration configuration = null;
        JsonValue conf = jsonConfig.get(CONFIG_FIELD);
        if (conf != null) {
            configuration = (EventHandlerConfiguration)mapper.convertValue(conf.getObject(), clazz);
        }
        return (C)configuration;
    }

    public static JsonValue getAuditEventHandlerConfigurationSchema(String className, ClassLoader classLoader) throws AuditException {
        Class<? extends EventHandlerConfiguration> eventHandlerConfiguration = AuditJsonConfig.getAuditEventHandlerConfigurationClass(className, AuditJsonConfig.getAuditEventHandlerClass(className, JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)CLASS_FIELD, (Object)className)})), classLoader), classLoader);
        try {
            mapper.setAnnotationIntrospector(helpAppenderAnnotationIntrospector);
            SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
            mapper.acceptJsonFormatVisitor(mapper.constructType(eventHandlerConfiguration), (JsonFormatVisitorWrapper)visitor);
            JsonSchema jsonSchema = visitor.finalSchema();
            JsonValue schema = JsonValue.json((Object)mapper.readValue(mapper.writeValueAsString((Object)jsonSchema), Map.class));
            mapper.setAnnotationIntrospector(defaultAnnotationIntrospector);
            return schema;
        }
        catch (IOException e) {
            String error = String.format("Unable to parse configuration class schema for configuration class %s", eventHandlerConfiguration.getName());
            logger.error(error, (Throwable)e);
            throw new AuditException(error, (Throwable)e);
        }
    }

    private static class HelpAppenderAnnotationIntrospector
    extends JacksonAnnotationIntrospector {
        private HelpAppenderAnnotationIntrospector() {
        }

        public String findPropertyDescription(Annotated ann) {
            JsonPropertyDescription desc = (JsonPropertyDescription)this._findAnnotation(ann, JsonPropertyDescription.class);
            return desc == null ? null : desc.value().concat(".help");
        }
    }
}

