/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.server.setup.model;

class RuntimeOptions {
    static final int INITIAL_MEMORY = 128;
    static final int MAXIMUM_MEMORY = 256;
    private int initialMemory = -1;
    private int maximumMemory = -1;
    private String[] additionalArguments = new String[0];

    RuntimeOptions() {
    }

    static RuntimeOptions getDefault() {
        RuntimeOptions ro = new RuntimeOptions();
        ro.initialMemory = 128;
        ro.maximumMemory = 256;
        ro.additionalArguments = new String[]{"-client"};
        return ro;
    }

    public int getInitialMemory() {
        return this.initialMemory;
    }

    public void setInitialMemory(int initialMemory) {
        this.initialMemory = initialMemory;
    }

    public int getMaximumMemory() {
        return this.maximumMemory;
    }

    public void setMaximumMemory(int maximumMemory) {
        this.maximumMemory = maximumMemory;
    }

    public String[] getAdditionalArguments() {
        return this.additionalArguments;
    }

    public void setAdditionalArguments(String ... additionalArguments) {
        if (additionalArguments == null) {
            throw new IllegalArgumentException("additionalArguments cannot be null.");
        }
        this.additionalArguments = additionalArguments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuntimeOptions)) {
            return false;
        }
        RuntimeOptions other = (RuntimeOptions)o;
        if (this.initialMemory == other.initialMemory && this.maximumMemory == other.maximumMemory && this.additionalArguments.length == other.additionalArguments.length) {
            String[] args = other.additionalArguments;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(this.additionalArguments[i])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 44 + this.initialMemory + this.maximumMemory;
        for (String arg : this.additionalArguments) {
            hashCode += arg.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Initial Memory: ").append(this.initialMemory).append("  Max Memory: ").append(this.maximumMemory);
        int i = 1;
        for (String arg : this.additionalArguments) {
            sb.append(" arg ").append(i).append(": ").append(arg);
            ++i;
        }
        return sb.toString();
    }

    public static String getInitialMemoryArgument(int value) {
        return "-Xms" + value + "m";
    }

    public static String getMaxMemoryArgument(int value) {
        return "-Xmx" + value + "m";
    }
}

