/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Pattern;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonTransformer;
import org.forgerock.json.JsonValue;

public class JsonValueKeyAccessChecker
extends JsonValue {
    private final JsonValue delegate;
    private final Set<String> accessedKeyNames = new HashSet<String>();
    private final Map<JsonPointer, JsonValueKeyAccessChecker> subCheckers = new HashMap<JsonPointer, JsonValueKeyAccessChecker>();

    public JsonValueKeyAccessChecker(JsonValue delegate) {
        super(null);
        this.delegate = delegate;
        if (delegate != null) {
            for (JsonValue value : delegate) {
                this.wrap(value);
            }
        }
    }

    private JsonValue access(JsonValue val) {
        String keyName = val.getPointer().leaf();
        if (keyName != null) {
            this.accessedKeyNames.add(keyName);
        }
        return val;
    }

    private JsonValue wrap(JsonValue val) {
        if (val == this.delegate) {
            return this;
        }
        if (val.isMap() || val.isList()) {
            JsonValueKeyAccessChecker checker = this.subCheckers.get(val.getPointer());
            if (checker == null) {
                checker = new JsonValueKeyAccessChecker(val);
                this.subCheckers.put(val.getPointer(), checker);
            }
            return checker;
        }
        return val;
    }

    @Override
    public JsonValue recordKeyAccesses() {
        return this;
    }

    @Override
    public void verifyAllKeysAccessed() {
        StringBuilder errors = new StringBuilder();
        this.verifyAllKeysAccessed(errors);
        if (errors.length() > 0) {
            throw new JsonException(errors.toString());
        }
    }

    private void verifyAllKeysAccessed(StringBuilder errors) {
        TreeSet<String> unaccessedKeys = this.isList() ? Collections.emptySet() : new TreeSet<String>(this.delegate.keys());
        unaccessedKeys.removeAll(this.accessedKeyNames);
        if (!unaccessedKeys.isEmpty()) {
            if (errors.length() > 0) {
                errors.append("\n");
            }
            errors.append(this.getPointer()).append(": ").append("Unused keys: " + unaccessedKeys);
        }
        for (JsonValueKeyAccessChecker subChecker : this.subCheckers.values()) {
            if (unaccessedKeys.contains(subChecker.getPointer().leaf())) continue;
            subChecker.verifyAllKeysAccessed(errors);
        }
    }

    @Override
    public JsonValue add(int index, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue add(JsonPointer pointer, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue add(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue add(String key, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue addPermissive(JsonPointer pointer, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyTransformers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean asBoolean() {
        return this.delegate.asBoolean();
    }

    @Override
    public Charset asCharset() {
        return this.delegate.asCharset();
    }

    @Override
    public Double asDouble() {
        return this.delegate.asDouble();
    }

    @Override
    public <T extends Enum<T>> T asEnum(Class<T> type) {
        return this.delegate.asEnum(type);
    }

    @Override
    public File asFile() {
        return this.delegate.asFile();
    }

    @Override
    public Integer asInteger() {
        return this.delegate.asInteger();
    }

    @Override
    public List<Object> asList() {
        return this.delegate.asList();
    }

    @Override
    public <E> List<E> asList(Class<E> type) {
        return this.delegate.asList(type);
    }

    @Override
    public Long asLong() {
        return this.delegate.asLong();
    }

    @Override
    public Map<String, Object> asMap() {
        return this.delegate.asMap();
    }

    @Override
    public Number asNumber() {
        return this.delegate.asNumber();
    }

    @Override
    public Pattern asPattern() {
        return this.delegate.asPattern();
    }

    @Override
    public JsonPointer asPointer() {
        return this.delegate.asPointer();
    }

    @Override
    public String asString() {
        return this.delegate.asString();
    }

    @Override
    public URI asURI() {
        return this.delegate.asURI();
    }

    @Override
    public UUID asUUID() {
        return this.delegate.asUUID();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue clone() {
        return this.wrap(this.delegate.clone());
    }

    @Override
    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    @Override
    public JsonValue copy() {
        return this.wrap(this.delegate.copy());
    }

    @Override
    public JsonValue defaultTo(Object object) {
        return this.wrap(this.delegate.defaultTo(object));
    }

    @Override
    public JsonValue expect(Class<?> type) {
        return this.wrap(this.delegate.expect(type));
    }

    @Override
    public JsonValue get(int index) {
        return this.wrap(this.access(this.delegate.get(index)));
    }

    @Override
    public JsonValue get(JsonPointer pointer) {
        return this.wrap(this.access(this.delegate.get(pointer)));
    }

    @Override
    public JsonValue get(String key) {
        return this.wrap(this.access(this.delegate.get(key)));
    }

    @Override
    public Object getObject() {
        return this.delegate.getObject();
    }

    @Override
    public JsonPointer getPointer() {
        return this.delegate.getPointer();
    }

    @Override
    public List<JsonTransformer> getTransformers() {
        return this.delegate.getTransformers();
    }

    @Override
    public boolean isBoolean() {
        return this.delegate.isBoolean();
    }

    @Override
    public boolean isDefined(String key) {
        return this.delegate.isDefined(key);
    }

    @Override
    public boolean isList() {
        return this.delegate.isList();
    }

    @Override
    public boolean isMap() {
        return this.delegate.isMap();
    }

    @Override
    public boolean isNull() {
        return this.delegate.isNull();
    }

    @Override
    public boolean isNumber() {
        return this.delegate.isNumber();
    }

    @Override
    public boolean isString() {
        return this.delegate.isString();
    }

    @Override
    public Iterator<JsonValue> iterator() {
        final Iterator<JsonValue> delegate = this.delegate.iterator();
        return new Iterator<JsonValue>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public JsonValue next() {
                return JsonValueKeyAccessChecker.this.wrap(JsonValueKeyAccessChecker.this.access((JsonValue)delegate.next()));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<String> keys() {
        return this.delegate.keys();
    }

    @Override
    public JsonValue put(int index, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue put(JsonPointer pointer, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue put(String key, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue putPermissive(JsonPointer pointer, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(JsonPointer pointer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonValue required() {
        return this.wrap(this.delegate.required());
    }

    @Override
    public void setObject(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

