/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.CoreSchemaImpl;
import org.forgerock.opendj.ldap.schema.DITContentRule;
import org.forgerock.opendj.ldap.schema.DITStructureRule;
import org.forgerock.opendj.ldap.schema.DelayedSchema;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;

public final class Schema {
    static final String ATTR_ATTRIBUTE_TYPES = "attributeTypes";
    static final String ATTR_DIT_CONTENT_RULES = "dITContentRules";
    static final String ATTR_DIT_STRUCTURE_RULES = "dITStructureRules";
    static final String ATTR_LDAP_SYNTAXES = "ldapSyntaxes";
    static final String ATTR_MATCHING_RULE_USE = "matchingRuleUse";
    static final String ATTR_MATCHING_RULES = "matchingRules";
    static final String ATTR_NAME_FORMS = "nameForms";
    static final String ATTR_OBJECT_CLASSES = "objectClasses";
    private final Impl impl;

    public static Schema getCoreSchema() {
        return CoreSchemaImpl.getInstance();
    }

    public static Schema getDefaultSchema() {
        return DelayedSchema.defaultSchema;
    }

    public static Schema getEmptySchema() {
        return DelayedSchema.EMPTY_SCHEMA;
    }

    public static Schema readSchema(Connection connection, DN name) throws LdapException {
        return new SchemaBuilder().addSchema(connection, name, true).toSchema();
    }

    public static LdapPromise<Schema> readSchemaAsync(Connection connection, DN name) {
        SchemaBuilder builder = new SchemaBuilder();
        return builder.addSchemaAsync(connection, name, true).then(new Function<SchemaBuilder, Schema, LdapException>(){

            public Schema apply(SchemaBuilder builder) throws LdapException {
                return builder.toSchema();
            }
        });
    }

    public static Schema readSchemaForEntry(Connection connection, DN name) throws LdapException {
        return new SchemaBuilder().addSchemaForEntry(connection, name, true).toSchema();
    }

    public static LdapPromise<Schema> readSchemaForEntryAsync(Connection connection, DN name) {
        SchemaBuilder builder = new SchemaBuilder();
        return builder.addSchemaForEntryAsync(connection, name, true).then(new Function<SchemaBuilder, Schema, LdapException>(){

            public Schema apply(SchemaBuilder builder) throws LdapException {
                return builder.toSchema();
            }
        });
    }

    public static void setDefaultSchema(Schema schema) {
        Reject.ifNull((Object)schema);
        DelayedSchema.defaultSchema = schema;
    }

    public static Schema valueOf(Entry entry) {
        return new SchemaBuilder(entry).toSchema();
    }

    Schema(Impl impl) {
        this.impl = impl;
    }

    public Schema asNonStrictSchema() {
        return this.impl.asNonStrictSchema();
    }

    public Schema asStrictSchema() {
        return this.impl.asStrictSchema();
    }

    MatchingRule getDefaultMatchingRule() {
        return this.impl.getDefaultMatchingRule();
    }

    Syntax getDefaultSyntax() {
        return this.impl.getDefaultSyntax();
    }

    String getOIDForName(String lowerCaseName) {
        return this.impl.getOIDForName(lowerCaseName);
    }

    public AttributeType getAttributeType(String nameOrOid) {
        return this.impl.getAttributeType(this, nameOrOid);
    }

    public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
        return this.impl.getAttributeType(nameOrOid, syntax);
    }

    public Collection<AttributeType> getAttributeTypes() {
        return this.impl.getAttributeTypes();
    }

    public List<AttributeType> getAttributeTypesWithName(String name) {
        return this.impl.getAttributeTypesWithName(name);
    }

    public DITContentRule getDITContentRule(ObjectClass structuralClass) {
        return this.impl.getDITContentRule(structuralClass);
    }

    public DITContentRule getDITContentRule(String nameOrOid) {
        return this.impl.getDITContentRule(nameOrOid);
    }

    public Collection<DITContentRule> getDITContentRules() {
        return this.impl.getDITContentRules();
    }

    public Collection<DITContentRule> getDITContentRulesWithName(String name) {
        return this.impl.getDITContentRulesWithName(name);
    }

    public DITStructureRule getDITStructureRule(int ruleID) {
        return this.impl.getDITStructureRule(ruleID);
    }

    public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
        return this.impl.getDITStructureRules(nameForm);
    }

    public Collection<DITStructureRule> getDITStructureRulesWithName(String name) {
        return this.impl.getDITStructureRulesWithName(name);
    }

    public Collection<DITStructureRule> getDITStuctureRules() {
        return this.impl.getDITStuctureRules();
    }

    public MatchingRule getMatchingRule(String nameOrOid) {
        return this.impl.getMatchingRule(nameOrOid);
    }

    public Collection<MatchingRule> getMatchingRules() {
        return this.impl.getMatchingRules();
    }

    public Collection<MatchingRule> getMatchingRulesWithName(String name) {
        return this.impl.getMatchingRulesWithName(name);
    }

    public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        return this.getMatchingRuleUse(matchingRule.getOID());
    }

    public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
        return this.impl.getMatchingRuleUse(nameOrOid);
    }

    public Collection<MatchingRuleUse> getMatchingRuleUses() {
        return this.impl.getMatchingRuleUses();
    }

    public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String name) {
        return this.impl.getMatchingRuleUsesWithName(name);
    }

    public NameForm getNameForm(String nameOrOid) {
        return this.impl.getNameForm(nameOrOid);
    }

    public Collection<NameForm> getNameForms() {
        return this.impl.getNameForms();
    }

    public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
        return this.impl.getNameForms(structuralClass);
    }

    public Collection<NameForm> getNameFormsWithName(String name) {
        return this.impl.getNameFormsWithName(name);
    }

    public ObjectClass getObjectClass(String nameOrOid) {
        return this.impl.getObjectClass(nameOrOid);
    }

    public Collection<ObjectClass> getObjectClasses() {
        return this.impl.getObjectClasses();
    }

    public Collection<ObjectClass> getObjectClassesWithName(String name) {
        return this.impl.getObjectClassesWithName(name);
    }

    public <T> T getOption(Option<T> option) {
        return (T)this.getOptions().get(option);
    }

    Options getOptions() {
        return this.impl.getOptions();
    }

    public String getSchemaName() {
        return this.impl.getSchemaName();
    }

    public Syntax getSyntax(String numericOID) {
        return this.impl.getSyntax(this, numericOID);
    }

    public Collection<Syntax> getSyntaxes() {
        return this.impl.getSyntaxes();
    }

    public Collection<LocalizableMessage> getWarnings() {
        return this.impl.getWarnings();
    }

    public boolean hasAttributeType(String nameOrOid) {
        return this.impl.hasAttributeType(nameOrOid);
    }

    public boolean hasDITContentRule(String nameOrOid) {
        return this.impl.hasDITContentRule(nameOrOid);
    }

    public boolean hasDITStructureRule(int ruleID) {
        return this.impl.hasDITStructureRule(ruleID);
    }

    public boolean hasMatchingRule(String nameOrOid) {
        return this.impl.hasMatchingRule(nameOrOid);
    }

    public boolean hasMatchingRuleUse(String nameOrOid) {
        return this.impl.hasMatchingRuleUse(nameOrOid);
    }

    public boolean hasNameForm(String nameOrOid) {
        return this.impl.hasNameForm(nameOrOid);
    }

    public boolean hasObjectClass(String nameOrOid) {
        return this.impl.hasObjectClass(nameOrOid);
    }

    public boolean hasSyntax(String numericOID) {
        return this.impl.hasSyntax(numericOID);
    }

    public boolean isStrict() {
        return this.impl.isStrict();
    }

    public Entry toEntry(Entry entry) {
        LinkedAttribute attr = new LinkedAttribute(ATTR_LDAP_SYNTAXES);
        for (Syntax syntax : this.getSyntaxes()) {
            attr.add(new Object[]{syntax.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_ATTRIBUTE_TYPES);
        for (AttributeType attributeType : this.getAttributeTypes()) {
            attr.add(new Object[]{attributeType.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_OBJECT_CLASSES);
        for (ObjectClass objectClass : this.getObjectClasses()) {
            attr.add(new Object[]{objectClass.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_MATCHING_RULE_USE);
        for (MatchingRuleUse matchingRuleUse : this.getMatchingRuleUses()) {
            attr.add(new Object[]{matchingRuleUse.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_MATCHING_RULES);
        for (MatchingRule matchingRule : this.getMatchingRules()) {
            attr.add(new Object[]{matchingRule.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_DIT_CONTENT_RULES);
        for (DITContentRule ditContentRule : this.getDITContentRules()) {
            attr.add(new Object[]{ditContentRule.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_DIT_STRUCTURE_RULES);
        for (DITStructureRule ditStructureRule : this.getDITStuctureRules()) {
            attr.add(new Object[]{ditStructureRule.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_NAME_FORMS);
        for (NameForm nameForm : this.getNameForms()) {
            attr.add(new Object[]{nameForm.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        return entry;
    }

    public boolean validateEntry(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages) {
        ObjectClass structuralObjectClass = null;
        Attribute objectClassAttribute = entry.getAttribute(AttributeDescription.objectClass());
        LinkedList<ObjectClass> objectClasses = new LinkedList<ObjectClass>();
        if (objectClassAttribute != null) {
            for (ByteString v : objectClassAttribute) {
                ObjectClass objectClass;
                String objectClassName = v.toString();
                try {
                    objectClass = this.getObjectClass(objectClassName);
                    objectClasses.add(objectClass);
                }
                catch (UnknownSchemaElementException e) {
                    if (!policy.checkAttributesAndObjectClasses().needsChecking()) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_UNKNOWN_OBJECT_CLASS.get((Object)entry.getName(), (Object)objectClassName));
                    }
                    if (!policy.checkAttributesAndObjectClasses().isReject()) continue;
                    return false;
                }
                if (objectClass.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
                if (structuralObjectClass == null || objectClass.isDescendantOf(structuralObjectClass)) {
                    structuralObjectClass = objectClass;
                    continue;
                }
                if (structuralObjectClass.isDescendantOf(objectClass) || !policy.requireSingleStructuralObjectClass().needsChecking()) continue;
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_MULTIPLE_STRUCTURAL_CLASSES.get((Object)entry.getName(), (Object)structuralObjectClass.getNameOrOID(), (Object)objectClassName));
                }
                if (!policy.requireSingleStructuralObjectClass().isReject()) continue;
                return false;
            }
        }
        Collection<Object> ditStructureRules = Collections.emptyList();
        DITContentRule ditContentRule = null;
        if (structuralObjectClass == null) {
            if (policy.requireSingleStructuralObjectClass().needsChecking()) {
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_NO_STRUCTURAL_CLASS.get((Object)entry.getName()));
                }
                if (policy.requireSingleStructuralObjectClass().isReject()) {
                    return false;
                }
            }
        } else {
            ditContentRule = this.getDITContentRule(structuralObjectClass);
            if (ditContentRule != null && ditContentRule.isObsolete()) {
                ditContentRule = null;
            }
        }
        if (!this.checkAttributesAndObjectClasses(entry, policy, errorMessages, objectClasses, ditContentRule)) {
            return false;
        }
        if (policy.checkNameForms().needsChecking() && structuralObjectClass != null) {
            boolean foundMatchingNameForms = false;
            NameForm nameForm = null;
            LinkedList<LocalizableMessage> nameFormWarnings = errorMessages != null ? new LinkedList<LocalizableMessage>() : null;
            for (NameForm nf : this.getNameForms(structuralObjectClass)) {
                if (nf.isObsolete()) continue;
                foundMatchingNameForms = true;
                if (!this.checkNameForm(entry, nameFormWarnings, nf)) continue;
                nameForm = nf;
                break;
            }
            if (foundMatchingNameForms) {
                if (nameForm != null) {
                    ditStructureRules = this.getDITStructureRules(nameForm);
                } else {
                    if (errorMessages != null) {
                        errorMessages.addAll(nameFormWarnings);
                    }
                    if (policy.checkNameForms().isReject()) {
                        return false;
                    }
                }
            }
        }
        if (policy.checkDITStructureRules().needsChecking() && !entry.getName().isRootDN()) {
            boolean foundMatchingRules = false;
            boolean foundValidRule = false;
            LinkedList<LocalizableMessage> ruleWarnings = errorMessages != null ? new LinkedList<LocalizableMessage>() : null;
            ObjectClass parentStructuralObjectClass = null;
            boolean parentEntryHasBeenRead = false;
            for (DITStructureRule rule : ditStructureRules) {
                if (rule.isObsolete()) continue;
                foundMatchingRules = true;
                if (rule.getSuperiorRules().isEmpty()) {
                    foundValidRule = true;
                    break;
                }
                if (!parentEntryHasBeenRead) {
                    parentStructuralObjectClass = this.getParentStructuralObjectClass(entry, policy, ruleWarnings);
                    parentEntryHasBeenRead = true;
                }
                if (parentStructuralObjectClass == null || !this.checkDITStructureRule(entry, ruleWarnings, rule, structuralObjectClass, parentStructuralObjectClass)) continue;
                foundValidRule = true;
                break;
            }
            if (foundMatchingRules) {
                if (!foundValidRule) {
                    if (errorMessages != null) {
                        errorMessages.addAll(ruleWarnings);
                    }
                    if (policy.checkDITStructureRules().isReject()) {
                        return false;
                    }
                }
            } else {
                parentStructuralObjectClass = this.getParentStructuralObjectClass(entry, policy, ruleWarnings);
                if (parentStructuralObjectClass == null) {
                    if (errorMessages != null) {
                        errorMessages.addAll(ruleWarnings);
                    }
                    if (policy.checkDITStructureRules().isReject()) {
                        return false;
                    }
                } else {
                    for (NameForm nf : this.getNameForms(parentStructuralObjectClass)) {
                        if (nf.isObsolete()) continue;
                        for (DITStructureRule rule : this.getDITStructureRules(nf)) {
                            if (rule.isObsolete()) continue;
                            if (errorMessages != null) {
                                errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_MISSING_DSR.get((Object)entry.getName(), (Object)rule.getNameOrRuleID()));
                            }
                            if (!policy.checkDITStructureRules().isReject()) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private boolean checkAttributesAndObjectClasses(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages, List<ObjectClass> objectClasses, DITContentRule ditContentRule) {
        boolean checkDITContentRule = policy.checkDITContentRules().needsChecking() && ditContentRule != null;
        boolean checkObjectClasses = policy.checkAttributesAndObjectClasses().needsChecking();
        boolean checkAttributeValues = policy.checkAttributeValues().needsChecking();
        if (checkObjectClasses || checkDITContentRule) {
            for (ObjectClass objectClass : objectClasses) {
                if (checkDITContentRule && objectClass.getObjectClassType() == ObjectClassType.AUXILIARY && !ditContentRule.getAuxiliaryClasses().contains(objectClass)) {
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_PROHIBITED_AUXILIARY_OC.get((Object)entry.getName(), (Object)objectClass.getNameOrOID(), (Object)ditContentRule.getNameOrOID()));
                    }
                    if (policy.checkDITContentRules().isReject()) {
                        return false;
                    }
                }
                if (!checkObjectClasses) continue;
                for (AttributeType t : objectClass.getDeclaredRequiredAttributes()) {
                    Attribute a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_OC_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)objectClass.getNameOrOID()));
                    }
                    if (!policy.checkAttributesAndObjectClasses().isReject()) continue;
                    return false;
                }
            }
            if (checkDITContentRule) {
                Attribute a;
                for (AttributeType t : ditContentRule.getRequiredAttributes()) {
                    a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID()));
                    }
                    if (!policy.checkDITContentRules().isReject()) continue;
                    return false;
                }
                for (AttributeType t : ditContentRule.getProhibitedAttributes()) {
                    a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (!entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_DCR_PROHIBITED_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID()));
                    }
                    if (!policy.checkDITContentRules().isReject()) continue;
                    return false;
                }
            }
        }
        if (checkObjectClasses || checkDITContentRule || checkAttributeValues) {
            for (Attribute attribute : entry.getAllAttributes()) {
                AttributeType t = attribute.getAttributeDescription().getAttributeType();
                if (!t.isOperational() && (checkObjectClasses || checkDITContentRule)) {
                    boolean isAllowed = false;
                    for (ObjectClass objectClass : objectClasses) {
                        if (!objectClass.isRequiredOrOptional(t)) continue;
                        isAllowed = true;
                        break;
                    }
                    if (!isAllowed && ditContentRule != null && ditContentRule.isRequiredOrOptional(t)) {
                        isAllowed = true;
                    }
                    if (!isAllowed) {
                        if (errorMessages != null) {
                            LocalizableMessage message = ditContentRule != null ? CoreMessages.ERR_ENTRY_SCHEMA_DCR_DISALLOWED_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID()) : CoreMessages.ERR_ENTRY_SCHEMA_OC_DISALLOWED_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID());
                            errorMessages.add(message);
                        }
                        if (policy.checkAttributesAndObjectClasses().isReject() || policy.checkDITContentRules().isReject()) {
                            return false;
                        }
                    }
                }
                if (!checkAttributeValues) continue;
                int sz = attribute.size();
                if (sz == 0) {
                    if (errorMessages != null) {
                        errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_AT_EMPTY_ATTRIBUTE.get((Object)entry.getName(), (Object)t.getNameOrOID()));
                    }
                    if (!policy.checkAttributeValues().isReject()) continue;
                    return false;
                }
                if (sz <= 1 || !t.isSingleValue()) continue;
                if (errorMessages != null) {
                    errorMessages.add(CoreMessages.ERR_ENTRY_SCHEMA_AT_SINGLE_VALUED_ATTRIBUTE.get((Object)entry.getName(), (Object)t.getNameOrOID()));
                }
                if (!policy.checkAttributeValues().isReject()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkDITStructureRule(Entry entry, List<LocalizableMessage> ruleWarnings, DITStructureRule rule, ObjectClass structuralObjectClass, ObjectClass parentStructuralObjectClass) {
        boolean matchFound = false;
        for (DITStructureRule parentRule : rule.getSuperiorRules()) {
            if (!parentRule.getNameForm().getStructuralClass().equals(parentStructuralObjectClass)) continue;
            matchFound = true;
        }
        if (!matchFound) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_ILLEGAL_OC.get((Object)entry.getName(), (Object)rule.getNameOrRuleID(), (Object)structuralObjectClass.getNameOrOID(), (Object)parentStructuralObjectClass.getNameOrOID()));
            }
            return false;
        }
        return true;
    }

    private boolean checkNameForm(Entry entry, List<LocalizableMessage> nameFormWarnings, NameForm nameForm) {
        RDN rdn = entry.getName().rdn();
        if (rdn != null) {
            for (AttributeType t : nameForm.getRequiredAttributes()) {
                if (rdn.getAttributeValue(t) != null) continue;
                if (nameFormWarnings != null) {
                    nameFormWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_NF_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)nameForm.getNameOrOID()));
                }
                return false;
            }
            for (AVA ava : rdn) {
                AttributeType t = ava.getAttributeType();
                if (nameForm.isRequiredOrOptional(t)) continue;
                if (nameFormWarnings != null) {
                    nameFormWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_NF_DISALLOWED_ATTRIBUTES.get((Object)entry.getName(), (Object)t.getNameOrOID(), (Object)nameForm.getNameOrOID()));
                }
                return false;
            }
        }
        return true;
    }

    private ObjectClass getParentStructuralObjectClass(Entry entry, SchemaValidationPolicy policy, List<LocalizableMessage> ruleWarnings) {
        Entry parentEntry;
        try {
            parentEntry = policy.checkDITStructureRulesEntryResolver().getEntry(entry.getName().parent());
        }
        catch (LdapException e) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_PARENT_NOT_FOUND.get((Object)entry.getName(), (Object)e.getResult().getDiagnosticMessage()));
            }
            return null;
        }
        ObjectClass parentStructuralObjectClass = Entries.getStructuralObjectClass(parentEntry, this);
        if (parentStructuralObjectClass == null) {
            if (ruleWarnings != null) {
                ruleWarnings.add(CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_OC.get((Object)entry.getName()));
            }
            return null;
        }
        return parentStructuralObjectClass;
    }

    public String toString() {
        return "Schema " + this.getSchemaName() + " mr=" + this.getMatchingRules().size() + " syntaxes=" + this.getSyntaxes().size() + " at=" + this.getAttributeTypes().size();
    }

    static final class StrictImpl
    implements Impl {
        private final Map<Integer, DITStructureRule> id2StructureRules;
        private final Map<String, List<AttributeType>> name2AttributeTypes;
        private final Map<String, List<DITContentRule>> name2ContentRules;
        private final Map<String, List<MatchingRule>> name2MatchingRules;
        private final Map<String, List<MatchingRuleUse>> name2MatchingRuleUses;
        private final Map<String, List<NameForm>> name2NameForms;
        private final Map<String, List<ObjectClass>> name2ObjectClasses;
        private final Map<String, List<DITStructureRule>> name2StructureRules;
        private final Map<String, List<DITStructureRule>> nameForm2StructureRules;
        private final Map<String, AttributeType> numericOID2AttributeTypes;
        private final Map<String, DITContentRule> numericOID2ContentRules;
        private final Map<String, MatchingRule> numericOID2MatchingRules;
        private final Map<String, MatchingRuleUse> numericOID2MatchingRuleUses;
        private final Map<String, NameForm> numericOID2NameForms;
        private final Map<String, ObjectClass> numericOID2ObjectClasses;
        private final Map<String, Syntax> numericOID2Syntaxes;
        private final Map<String, List<NameForm>> objectClass2NameForms;
        private final Map<String, String> name2OIDs;
        private final List<LocalizableMessage> warnings;
        private final String schemaName;
        private final Options options;
        private final Syntax defaultSyntax;
        private final MatchingRule defaultMatchingRule;
        private final Schema strictSchema;
        private final Schema nonStrictSchema;

        StrictImpl(String schemaName, Options options, Syntax defaultSyntax, MatchingRule defaultMatchingRule, Map<String, Syntax> numericOID2Syntaxes, Map<String, MatchingRule> numericOID2MatchingRules, Map<String, MatchingRuleUse> numericOID2MatchingRuleUses, Map<String, AttributeType> numericOID2AttributeTypes, Map<String, ObjectClass> numericOID2ObjectClasses, Map<String, NameForm> numericOID2NameForms, Map<String, DITContentRule> numericOID2ContentRules, Map<Integer, DITStructureRule> id2StructureRules, Map<String, List<MatchingRule>> name2MatchingRules, Map<String, List<MatchingRuleUse>> name2MatchingRuleUses, Map<String, List<AttributeType>> name2AttributeTypes, Map<String, List<ObjectClass>> name2ObjectClasses, Map<String, List<NameForm>> name2NameForms, Map<String, List<DITContentRule>> name2ContentRules, Map<String, List<DITStructureRule>> name2StructureRules, Map<String, List<NameForm>> objectClass2NameForms, Map<String, List<DITStructureRule>> nameForm2StructureRules, Map<String, String> name2OIDs, List<LocalizableMessage> warnings) {
            this.schemaName = schemaName;
            this.options = options;
            this.defaultSyntax = defaultSyntax;
            this.defaultMatchingRule = defaultMatchingRule;
            this.numericOID2Syntaxes = Collections.unmodifiableMap(numericOID2Syntaxes);
            this.numericOID2MatchingRules = Collections.unmodifiableMap(numericOID2MatchingRules);
            this.numericOID2MatchingRuleUses = Collections.unmodifiableMap(numericOID2MatchingRuleUses);
            this.numericOID2AttributeTypes = Collections.unmodifiableMap(numericOID2AttributeTypes);
            this.numericOID2ObjectClasses = Collections.unmodifiableMap(numericOID2ObjectClasses);
            this.numericOID2NameForms = Collections.unmodifiableMap(numericOID2NameForms);
            this.numericOID2ContentRules = Collections.unmodifiableMap(numericOID2ContentRules);
            this.id2StructureRules = Collections.unmodifiableMap(id2StructureRules);
            this.name2MatchingRules = Collections.unmodifiableMap(name2MatchingRules);
            this.name2MatchingRuleUses = Collections.unmodifiableMap(name2MatchingRuleUses);
            this.name2AttributeTypes = Collections.unmodifiableMap(name2AttributeTypes);
            this.name2ObjectClasses = Collections.unmodifiableMap(name2ObjectClasses);
            this.name2NameForms = Collections.unmodifiableMap(name2NameForms);
            this.name2ContentRules = Collections.unmodifiableMap(name2ContentRules);
            this.name2StructureRules = Collections.unmodifiableMap(name2StructureRules);
            this.objectClass2NameForms = Collections.unmodifiableMap(objectClass2NameForms);
            this.nameForm2StructureRules = Collections.unmodifiableMap(nameForm2StructureRules);
            this.name2OIDs = Collections.unmodifiableMap(name2OIDs);
            this.warnings = Collections.unmodifiableList(warnings);
            this.strictSchema = new Schema(this);
            this.nonStrictSchema = new Schema(new NonStrictImpl(this));
        }

        @Override
        public Schema asNonStrictSchema() {
            return this.nonStrictSchema;
        }

        @Override
        public Schema asStrictSchema() {
            return this.strictSchema;
        }

        @Override
        public Options getOptions() {
            return this.options;
        }

        @Override
        public Syntax getDefaultSyntax() {
            return this.defaultSyntax;
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return this.defaultMatchingRule;
        }

        @Override
        public String getOIDForName(String lowerCaseName) {
            String oid = this.name2OIDs.get(lowerCaseName);
            if ("<ambiguous-oid>".equals(oid)) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_NAME_AMBIGUOUS.get((Object)lowerCaseName));
            }
            return oid;
        }

        @Override
        public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
            return this.getAttributeType(null, nameOrOid);
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String nameOrOid) {
            AttributeType type = this.getAttributeType0(nameOrOid);
            if (type != null) {
                return type;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_ATTR_TYPE_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return this.numericOID2AttributeTypes.values();
        }

        @Override
        public List<AttributeType> getAttributeTypesWithName(String name) {
            List<AttributeType> attributes = this.name2AttributeTypes.get(StaticUtils.toLowerCase(name));
            if (attributes != null) {
                return attributes;
            }
            return Collections.emptyList();
        }

        @Override
        public DITContentRule getDITContentRule(ObjectClass structuralClass) {
            return this.numericOID2ContentRules.get(structuralClass.getOID());
        }

        @Override
        public DITContentRule getDITContentRule(String nameOrOid) {
            DITContentRule rule = this.numericOID2ContentRules.get(nameOrOid);
            if (rule != null) {
                return rule;
            }
            List<DITContentRule> rules = this.name2ContentRules.get(StaticUtils.toLowerCase(nameOrOid));
            if (rules != null) {
                if (rules.size() == 1) {
                    return rules.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_DCR_AMBIGUOUS.get((Object)nameOrOid));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_DCR_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<DITContentRule> getDITContentRules() {
            return this.numericOID2ContentRules.values();
        }

        @Override
        public Collection<DITContentRule> getDITContentRulesWithName(String name) {
            List<DITContentRule> rules = this.name2ContentRules.get(StaticUtils.toLowerCase(name));
            if (rules != null) {
                return rules;
            }
            return Collections.emptyList();
        }

        @Override
        public DITStructureRule getDITStructureRule(int ruleID) {
            DITStructureRule rule = this.id2StructureRules.get(ruleID);
            if (rule == null) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_DSR_UNKNOWN.get((Object)String.valueOf(ruleID)));
            }
            return rule;
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
            List<DITStructureRule> rules = this.nameForm2StructureRules.get(nameForm.getOID());
            if (rules != null) {
                return rules;
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRulesWithName(String name) {
            List<DITStructureRule> rules = this.name2StructureRules.get(StaticUtils.toLowerCase(name));
            if (rules != null) {
                return rules;
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<DITStructureRule> getDITStuctureRules() {
            return this.id2StructureRules.values();
        }

        @Override
        public MatchingRule getMatchingRule(String nameOrOid) {
            MatchingRule rule = this.numericOID2MatchingRules.get(nameOrOid);
            if (rule != null) {
                return rule;
            }
            List<MatchingRule> rules = this.name2MatchingRules.get(StaticUtils.toLowerCase(nameOrOid));
            if (rules != null) {
                if (rules.size() == 1) {
                    return rules.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_MR_AMBIGUOUS.get((Object)nameOrOid));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_MR_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return this.numericOID2MatchingRules.values();
        }

        @Override
        public Collection<MatchingRule> getMatchingRulesWithName(String name) {
            List<MatchingRule> rules = this.name2MatchingRules.get(StaticUtils.toLowerCase(name));
            if (rules != null) {
                return rules;
            }
            return Collections.emptyList();
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return this.numericOID2MatchingRuleUses.get(matchingRule.getOID());
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
            MatchingRuleUse rule = this.numericOID2MatchingRuleUses.get(nameOrOid);
            if (rule != null) {
                return rule;
            }
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(nameOrOid));
            if (uses != null) {
                if (uses.size() == 1) {
                    return uses.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_MRU_AMBIGUOUS.get((Object)nameOrOid));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_MRU_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return this.numericOID2MatchingRuleUses.values();
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String name) {
            List<MatchingRuleUse> rules = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(name));
            if (rules != null) {
                return rules;
            }
            return Collections.emptyList();
        }

        @Override
        public NameForm getNameForm(String nameOrOid) {
            NameForm form = this.numericOID2NameForms.get(nameOrOid);
            if (form != null) {
                return form;
            }
            List<NameForm> forms = this.name2NameForms.get(StaticUtils.toLowerCase(nameOrOid));
            if (forms != null) {
                if (forms.size() == 1) {
                    return forms.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_NAMEFORM_AMBIGUOUS.get((Object)nameOrOid));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_NAMEFORM_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return this.numericOID2NameForms.values();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            List<NameForm> forms = this.objectClass2NameForms.get(structuralClass.getOID());
            if (forms != null) {
                return forms;
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<NameForm> getNameFormsWithName(String name) {
            List<NameForm> forms = this.name2NameForms.get(StaticUtils.toLowerCase(name));
            if (forms != null) {
                return forms;
            }
            return Collections.emptyList();
        }

        @Override
        public ObjectClass getObjectClass(String nameOrOid) {
            ObjectClass oc = this.numericOID2ObjectClasses.get(nameOrOid);
            if (oc != null) {
                return oc;
            }
            List<ObjectClass> classes = this.name2ObjectClasses.get(StaticUtils.toLowerCase(nameOrOid));
            if (classes != null) {
                if (classes.size() == 1) {
                    return classes.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_OBJECTCLASS_AMBIGUOUS.get((Object)nameOrOid));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_OBJECTCLASS_UNKNOWN.get((Object)nameOrOid));
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return this.numericOID2ObjectClasses.values();
        }

        @Override
        public Collection<ObjectClass> getObjectClassesWithName(String name) {
            List<ObjectClass> classes = this.name2ObjectClasses.get(StaticUtils.toLowerCase(name));
            if (classes != null) {
                return classes;
            }
            return Collections.emptyList();
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOID) {
            Syntax syntax = this.numericOID2Syntaxes.get(numericOID);
            if (syntax == null) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_SYNTAX_UNKNOWN.get((Object)numericOID));
            }
            return syntax;
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return this.numericOID2Syntaxes.values();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return this.warnings;
        }

        @Override
        public boolean hasAttributeType(String nameOrOid) {
            if (this.numericOID2AttributeTypes.containsKey(nameOrOid)) {
                return true;
            }
            List<AttributeType> attributes = this.name2AttributeTypes.get(StaticUtils.toLowerCase(nameOrOid));
            return attributes != null && attributes.size() == 1;
        }

        @Override
        public boolean hasDITContentRule(String nameOrOid) {
            if (this.numericOID2ContentRules.containsKey(nameOrOid)) {
                return true;
            }
            List<DITContentRule> rules = this.name2ContentRules.get(StaticUtils.toLowerCase(nameOrOid));
            return rules != null && rules.size() == 1;
        }

        @Override
        public boolean hasDITStructureRule(int ruleID) {
            return this.id2StructureRules.containsKey(ruleID);
        }

        @Override
        public boolean hasMatchingRule(String nameOrOid) {
            if (this.numericOID2MatchingRules.containsKey(nameOrOid)) {
                return true;
            }
            List<MatchingRule> rules = this.name2MatchingRules.get(StaticUtils.toLowerCase(nameOrOid));
            return rules != null && rules.size() == 1;
        }

        @Override
        public boolean hasMatchingRuleUse(String nameOrOid) {
            if (this.numericOID2MatchingRuleUses.containsKey(nameOrOid)) {
                return true;
            }
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(nameOrOid));
            return uses != null && uses.size() == 1;
        }

        @Override
        public boolean hasNameForm(String nameOrOid) {
            if (this.numericOID2NameForms.containsKey(nameOrOid)) {
                return true;
            }
            List<NameForm> forms = this.name2NameForms.get(StaticUtils.toLowerCase(nameOrOid));
            return forms != null && forms.size() == 1;
        }

        @Override
        public boolean hasObjectClass(String nameOrOid) {
            if (this.numericOID2ObjectClasses.containsKey(nameOrOid)) {
                return true;
            }
            List<ObjectClass> classes = this.name2ObjectClasses.get(StaticUtils.toLowerCase(nameOrOid));
            return classes != null && classes.size() == 1;
        }

        @Override
        public boolean hasSyntax(String numericOID) {
            return this.numericOID2Syntaxes.containsKey(numericOID);
        }

        @Override
        public boolean isStrict() {
            return true;
        }

        AttributeType getAttributeType0(String nameOrOid) {
            AttributeType type = this.numericOID2AttributeTypes.get(nameOrOid);
            if (type != null) {
                return type;
            }
            List<AttributeType> attributes = this.name2AttributeTypes.get(StaticUtils.toLowerCase(nameOrOid));
            if (attributes != null) {
                if (attributes.size() == 1) {
                    return attributes.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_ATTR_TYPE_AMBIGUOUS.get((Object)nameOrOid));
            }
            return null;
        }
    }

    private static final class NonStrictImpl
    implements Impl {
        private final StrictImpl strictImpl;

        private NonStrictImpl(StrictImpl strictImpl) {
            this.strictImpl = strictImpl;
        }

        @Override
        public Schema asNonStrictSchema() {
            return this.strictImpl.asNonStrictSchema();
        }

        @Override
        public Schema asStrictSchema() {
            return this.strictImpl.asStrictSchema();
        }

        @Override
        public Options getOptions() {
            return this.strictImpl.getOptions();
        }

        @Override
        public Syntax getDefaultSyntax() {
            return this.strictImpl.getDefaultSyntax();
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return this.strictImpl.getDefaultMatchingRule();
        }

        @Override
        public String getOIDForName(String lowerCaseName) {
            return this.strictImpl.getOIDForName(lowerCaseName);
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String nameOrOid) {
            return this.getAttributeType0(nameOrOid, schema.getDefaultSyntax(), schema.getDefaultMatchingRule());
        }

        @Override
        public AttributeType getAttributeType(String nameOrOid, Syntax syntax) {
            return this.getAttributeType0(nameOrOid, syntax, syntax.getEqualityMatchingRule());
        }

        private AttributeType getAttributeType0(String nameOrOid, Syntax syntax, MatchingRule equalityMatchingRule) {
            AttributeType type = this.strictImpl.getAttributeType0(nameOrOid);
            return type != null ? type : new AttributeType(nameOrOid, syntax, equalityMatchingRule);
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return this.strictImpl.getAttributeTypes();
        }

        @Override
        public List<AttributeType> getAttributeTypesWithName(String name) {
            return this.strictImpl.getAttributeTypesWithName(name);
        }

        @Override
        public DITContentRule getDITContentRule(ObjectClass structuralClass) {
            return this.strictImpl.getDITContentRule(structuralClass);
        }

        @Override
        public DITContentRule getDITContentRule(String nameOrOid) {
            return this.strictImpl.getDITContentRule(nameOrOid);
        }

        @Override
        public Collection<DITContentRule> getDITContentRules() {
            return this.strictImpl.getDITContentRules();
        }

        @Override
        public Collection<DITContentRule> getDITContentRulesWithName(String name) {
            return this.strictImpl.getDITContentRulesWithName(name);
        }

        @Override
        public DITStructureRule getDITStructureRule(int ruleID) {
            return this.strictImpl.getDITStructureRule(ruleID);
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
            return this.strictImpl.getDITStructureRules(nameForm);
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRulesWithName(String name) {
            return this.strictImpl.getDITStructureRulesWithName(name);
        }

        @Override
        public Collection<DITStructureRule> getDITStuctureRules() {
            return this.strictImpl.getDITStuctureRules();
        }

        @Override
        public MatchingRule getMatchingRule(String nameOrOid) {
            return this.strictImpl.getMatchingRule(nameOrOid);
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return this.strictImpl.getMatchingRules();
        }

        @Override
        public Collection<MatchingRule> getMatchingRulesWithName(String name) {
            return this.strictImpl.getMatchingRulesWithName(name);
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return this.strictImpl.getMatchingRuleUse(matchingRule);
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String nameOrOid) {
            return this.strictImpl.getMatchingRuleUse(nameOrOid);
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return this.strictImpl.getMatchingRuleUses();
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String name) {
            return this.strictImpl.getMatchingRuleUsesWithName(name);
        }

        @Override
        public NameForm getNameForm(String nameOrOid) {
            return this.strictImpl.getNameForm(nameOrOid);
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return this.strictImpl.getNameForms();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            return this.strictImpl.getNameForms(structuralClass);
        }

        @Override
        public Collection<NameForm> getNameFormsWithName(String name) {
            return this.strictImpl.getNameFormsWithName(name);
        }

        @Override
        public ObjectClass getObjectClass(String nameOrOid) {
            return this.strictImpl.getObjectClass(nameOrOid);
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return this.strictImpl.getObjectClasses();
        }

        @Override
        public Collection<ObjectClass> getObjectClassesWithName(String name) {
            return this.strictImpl.getObjectClassesWithName(name);
        }

        @Override
        public String getSchemaName() {
            return this.strictImpl.getSchemaName();
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOID) {
            if (!this.strictImpl.hasSyntax(numericOID)) {
                return new Syntax(schema, numericOID);
            }
            return this.strictImpl.getSyntax(schema, numericOID);
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return this.strictImpl.getSyntaxes();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return this.strictImpl.getWarnings();
        }

        @Override
        public boolean hasAttributeType(String nameOrOid) {
            return this.strictImpl.hasAttributeType(nameOrOid);
        }

        @Override
        public boolean hasDITContentRule(String nameOrOid) {
            return this.strictImpl.hasDITContentRule(nameOrOid);
        }

        @Override
        public boolean hasDITStructureRule(int ruleID) {
            return this.strictImpl.hasDITStructureRule(ruleID);
        }

        @Override
        public boolean hasMatchingRule(String nameOrOid) {
            return this.strictImpl.hasMatchingRule(nameOrOid);
        }

        @Override
        public boolean hasMatchingRuleUse(String nameOrOid) {
            return this.strictImpl.hasMatchingRuleUse(nameOrOid);
        }

        @Override
        public boolean hasNameForm(String nameOrOid) {
            return this.strictImpl.hasNameForm(nameOrOid);
        }

        @Override
        public boolean hasObjectClass(String nameOrOid) {
            return this.strictImpl.hasObjectClass(nameOrOid);
        }

        @Override
        public boolean hasSyntax(String numericOID) {
            return this.strictImpl.hasSyntax(numericOID);
        }

        @Override
        public boolean isStrict() {
            return false;
        }
    }

    private static interface Impl {
        public Schema asNonStrictSchema();

        public Schema asStrictSchema();

        public Options getOptions();

        public MatchingRule getDefaultMatchingRule();

        public Syntax getDefaultSyntax();

        public String getOIDForName(String var1);

        public AttributeType getAttributeType(Schema var1, String var2);

        public AttributeType getAttributeType(String var1, Syntax var2);

        public Collection<AttributeType> getAttributeTypes();

        public List<AttributeType> getAttributeTypesWithName(String var1);

        public DITContentRule getDITContentRule(ObjectClass var1);

        public DITContentRule getDITContentRule(String var1);

        public Collection<DITContentRule> getDITContentRules();

        public Collection<DITContentRule> getDITContentRulesWithName(String var1);

        public DITStructureRule getDITStructureRule(int var1);

        public Collection<DITStructureRule> getDITStructureRules(NameForm var1);

        public Collection<DITStructureRule> getDITStructureRulesWithName(String var1);

        public Collection<DITStructureRule> getDITStuctureRules();

        public MatchingRule getMatchingRule(String var1);

        public Collection<MatchingRule> getMatchingRules();

        public Collection<MatchingRule> getMatchingRulesWithName(String var1);

        public MatchingRuleUse getMatchingRuleUse(MatchingRule var1);

        public MatchingRuleUse getMatchingRuleUse(String var1);

        public Collection<MatchingRuleUse> getMatchingRuleUses();

        public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String var1);

        public NameForm getNameForm(String var1);

        public Collection<NameForm> getNameForms();

        public Collection<NameForm> getNameForms(ObjectClass var1);

        public Collection<NameForm> getNameFormsWithName(String var1);

        public ObjectClass getObjectClass(String var1);

        public Collection<ObjectClass> getObjectClasses();

        public Collection<ObjectClass> getObjectClassesWithName(String var1);

        public String getSchemaName();

        public Syntax getSyntax(Schema var1, String var2);

        public Collection<Syntax> getSyntaxes();

        public Collection<LocalizableMessage> getWarnings();

        public boolean hasAttributeType(String var1);

        public boolean hasDITContentRule(String var1);

        public boolean hasDITStructureRule(int var1);

        public boolean hasMatchingRule(String var1);

        public boolean hasMatchingRuleUse(String var1);

        public boolean hasNameForm(String var1);

        public boolean hasObjectClass(String var1);

        public boolean hasSyntax(String var1);

        public boolean isStrict();
    }
}

